/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.llvm;

import java.util.Iterator;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;

public final class SmallVectorToken
implements Native.assignable<SmallVectorToken>,
Native.NativeComparable<SmallVectorToken>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Token>,
NativeCloneable<SmallVectorToken> {
    public static final SmallVectorToken DEFAULT = new SmallVectorToken(0, null);
    private static final Token[] EMPTY = new Token[0];
    protected final Token defaultValue;
    private Token[] array;
    private int end;

    public final Token[] $array() {
        return this.array;
    }

    public SmallVectorToken(int capacity, Token defaultValue) {
        this.array = capacity == 0 ? EMPTY : new Token[capacity];
        this.end = 0;
        assert (defaultValue == null);
        this.defaultValue = defaultValue;
    }

    public SmallVectorToken(int capacity, int initialSize, Token defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    public SmallVectorToken(Token[] array2, int length, Token defaultValue) {
        this.array = array2;
        this.end = length;
        assert (defaultValue == null);
        this.defaultValue = defaultValue;
    }

    public SmallVectorToken(int capacity, type.iterator<?, Token> iter, int length, Token defaultValue) {
        this(capacity, iter, (type.iterator)iter.$add(length), defaultValue);
    }

    public SmallVectorToken(int capacity, type.iterator<?, Token> begin, type.iterator<?, Token> end, Token defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    public SmallVectorToken(SmallVectorToken other) {
        this.defaultValue = other.defaultValue;
        this.array = (Token[])other.array.clone();
        this.end = other.end;
    }

    public final SmallVectorToken $assign(SmallVectorToken other) {
        this.array = other.array;
        this.end = other.end;
        return this;
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, Token defaultValue) {
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = new Token();
            }
        }
        this.end = newSize;
        return grown;
    }

    public final void reserve(int N) {
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, Token Elt) {
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
    }

    public final void assign(type.iterator<?, Token> __first, type.iterator<?, Token> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public final void swap(SmallVectorToken RHS) {
        Token[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy((type.iterator)I.$add(1), (type.iterator)this.end(), (type.iterator)I, (boolean)false);
        this.pop_back();
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
        return N;
    }

    public final iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = (iterator)std.copy((type.iterator)E, (type.iterator)this.end(), (type.iterator)S, (boolean)false);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
        return N;
    }

    public final iterator insert(iterator I, Token Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((type.iterator)I, (type.iterator)this.end().$sub(1), (type.iterator)this.end(), (boolean)false);
        I.star$ref().$set((Object)((Token)Native.$tryClone((NativeCloneable)Elt)));
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
        return I;
    }

    public final iterator insert(iterator I, int NumToInsert, Token Elt) {
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((type.iterator)I, (type.iterator)OldEnd.$sub(NumToInsert), (type.iterator)OldEnd, (boolean)false);
            std.fill_n((type.iterator)I, (int)NumToInsert, (Object)Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy((type.iterator)I, (type.iterator)OldEnd, (type.iterator)this.end().$sub(NumOverwritten), (boolean)false);
        std.fill_n((type.iterator)I, (int)NumOverwritten, (Object)Elt);
        std.fill_n((type.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (Object)Elt);
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
        return I;
    }

    public final iterator insert(iterator I, type.iterator<?, Token> From, type.iterator<?, Token> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((type.iterator)I, (type.iterator)OldEnd.$sub(NumToInsert), (type.iterator)OldEnd, (boolean)false);
            std.copy(From, To, (type.iterator)I, (boolean)false);
            assert (this.ensureConsistent()) : "Check SmallVectorToken!";
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((type.iterator)I, (type.iterator)OldEnd, (type.iterator)this.end().$sub(NumOverwritten), (boolean)false);
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set((Object)((Token)From.$star()));
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, (type.iterator)OldEnd, (boolean)false);
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
        return I;
    }

    public final void append(type.iterator<?, Token> in_start, type.iterator<?, Token> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            if (this.array[this.end] == null) {
                this.array[this.end] = new Token();
            }
            this.$set(this.end, (Token)iter.$star());
            ++this.end;
            iter.$preInc();
        }
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
    }

    public final void append(type.ptr<Token> start, int NumInputs) {
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            if (this.array[this.end] == null) {
                this.array[this.end] = new Token();
            }
            this.array[this.end++].$assign((Token)start.$at(i));
        }
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
    }

    public final void append(Token[] a) {
        this.append(a, 0, a.length);
    }

    public final void append(Token[] a, int startIdx, int count) {
        int num = count;
        if (num > this.capacity() - this.size()) {
            this.grow(this.size() + num);
        }
        int last = startIdx + count;
        for (int i = startIdx; i < last; ++i) {
            if (this.array[this.end] == null) {
                this.array[this.end] = new Token();
            }
            this.array[this.end++].$assign(a[i]);
        }
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
    }

    public final void append(int NumInputs, Token Elt) {
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
        assert (this.ensureConsistent()) : "Check SmallVectorToken!";
    }

    public final boolean prepareBeforeAppend(int num) {
        int size;
        int capacity = this.capacity();
        if (num > capacity - (size = this.size())) {
            int N = Math.max(capacity * 2, size + num);
            this.grow(N);
            assert (num <= this.capacity() - this.size()) : "must be enough for appending " + num + " into [" + this.size() + "-" + this.capacity() + "]";
            return true;
        }
        return false;
    }

    public final boolean $eq(SmallVectorToken RHS) {
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal((type.iterator)this.begin(), (type.iterator)this.end(), (type.iterator)RHS.begin());
    }

    public final boolean $noteq(SmallVectorToken RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorToken)obj).begin(), (Object)((SmallVectorToken)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((SmallVectorToken)obj);
    }

    public final type.ref<Token> ref$at(int idx) {
        return NativePointer.create_type$ref((Object[])this.array, (int)idx);
    }

    public final Token $at(uint.ref idx) {
        return this.$at(idx.$deref());
    }

    public final Token $at(int.ref idx) {
        return this.$at(idx.$deref());
    }

    public final Token $at(int idx) {
        assert (this.array[idx] != null);
        return this.array[idx];
    }

    public final Token $at$Const(int idx) {
        assert (this.array[idx] != null);
        return this.array[idx];
    }

    public final Token $set(uint.ref idx, Token value) {
        return this.$set(idx.$deref(), value);
    }

    public final Token $set(int.ref idx, Token value) {
        return this.$set(idx.$deref(), value);
    }

    public final Token $set(int idx, Token value) {
        assert (this.array[idx] != null);
        this.array[idx].$assign(value);
        return this.array[idx];
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
        this.destroy_range(0, this.end);
        this.end = 0;
    }

    public final void push_back_T$C$R(Token val) {
        this.push_back(val);
    }

    public final void push_back(Token val) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        if (this.array[this.end] == null) {
            this.array[this.end] = new Token();
        }
        this.$set(this.end, val);
        ++this.end;
    }

    public final void pop_back() {
        this.array[--this.end].$destroy();
    }

    public final Token pop_back_val() {
        Token val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final type.ptr<Token> ptr$at$begin() {
        return NativePointer.create_type$ptr((Object[])this.array);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public final type.ptr<Token> ptr$at$end() {
        return NativePointer.create_type$ptr((Object[])this.array, (int)this.end);
    }

    public final std.reverse_iterator<Token> rbegin() {
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array, (int)this.end));
    }

    public final std.reverse_iterator<Token> rend() {
        return new std.reverse_iterator((type.iterator)NativePointer.create_type$ptr((Object[])this.array));
    }

    public final type.ptr<Token> data() {
        return NativePointer.create_type$ptr((Object[])this.array);
    }

    public final Token front() {
        return this.array[0];
    }

    public final Token back() {
        return this.array[this.end - 1];
    }

    public final type.ref<Token> ref$front() {
        return new type.ref<Token>(){
            private final Token stored;
            private final int index = 0;
            {
                this.stored = SmallVectorToken.this.array[0];
                this.index = 0;
            }

            public Token $deref() {
                return this.stored;
            }

            public Token $set(Token value) {
                if (this.stored instanceof Native.assignable) {
                    this.stored.$assign(value);
                } else {
                    ((SmallVectorToken)SmallVectorToken.this).array[0] = (Token)Native.$tryClone((NativeCloneable)value);
                }
                return value;
            }

            public type.ptr<Token> deref$ptr() {
                return (type.ptr)SmallVectorToken.this.data().$add(0);
            }
        };
    }

    public final type.ref<Token> ref$back() {
        return new type.ref<Token>(){
            private final Token stored;
            private final int index;
            {
                this.stored = SmallVectorToken.this.array[SmallVectorToken.this.end - 1];
                this.index = SmallVectorToken.this.end - 1;
            }

            public Token $deref() {
                return this.stored;
            }

            public Token $set(Token value) {
                if (this.stored instanceof Native.assignable) {
                    this.stored.$assign(value);
                } else {
                    ((SmallVectorToken)SmallVectorToken.this).array[this.index] = (Token)Native.$tryClone((NativeCloneable)value);
                }
                return value;
            }

            public type.ptr<Token> deref$ptr() {
                return (type.ptr)SmallVectorToken.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final int $sizeof() {
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        int oneElemSize = Token.$sizeof_Token();
        return this.array.length * oneElemSize;
    }

    public final type.ptr<Token> ptr$at(int idx) {
        return NativePointer.create_type$ptr((Object[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            Token Tok = this.array[i];
            if (Tok != null) {
                Tok.$destroy();
                continue;
            }
            if (!NativeTrace.isDebugMode()) break;
            for (int j = i; j < to; ++j) {
                assert (this.array[j] == null) : "Non null element [" + j + "] after null [" + i + "]";
            }
            break;
        }
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int newSize) {
        Object[] oldArray = this.array;
        this.array = new Token[newSize];
        NativePointer.copy$Object((Object[])oldArray, (int)0, (Object[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        if (capacity == 0) {
            this.array = new Token[8];
        } else {
            this.grow(capacity * 2);
        }
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<Token> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public SmallVectorToken clone() {
        return new SmallVectorToken(this);
    }

    public SmallVectorToken deepCopy() {
        int size = this.size();
        SmallVectorToken other = new SmallVectorToken(size, null);
        assert (other.capacity() == size);
        for (int i = 0; i < size; ++i) {
            Token tok2 = this.array[i];
            assert (tok2 != null);
            other.array[i] = new Token(tok2);
        }
        other.end = this.end;
        return other;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorToken{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            Token element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorToken}\n");
        return out.toString();
    }

    private boolean ensureConsistent() {
        for (int i = 0; i < this.size(); ++i) {
            for (int k = i + 1; k < this.size(); ++k) {
                if (this.array[i] != this.array[k]) continue;
                return false;
            }
        }
        return true;
    }

    private static final class JavaIterator
    implements Iterator<Token> {
        private final iterator begin;
        private final iterator end;

        public JavaIterator(iterator begin, iterator end) {
            this.begin = (iterator)Native.$tryClone((NativeCloneable)begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public Token next() {
            Token val = this.begin.$star();
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator
    implements type.iterator<iterator, Token>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final SmallVectorToken delegate;
        private int index;

        private iterator(SmallVectorToken delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public Token $arrow() {
            return this.$at(0);
        }

        public Token $star() {
            return this.$at(0);
        }

        public type.ref<Token> star$ref() {
            return this.ref$at(0);
        }

        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public Token $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public type.ref<Token> ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public type.ptr<Token> toPointer() {
            return NativePointer.create_type$ptr((Object[])this.delegate.array, (int)this.index);
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

