/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.java;

import java.util.concurrent.atomic.AtomicLong;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileData;
import org.clang.basic.FileEntry;
import org.clang.basic.FileSystemStatCache;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierIterator;
import org.clang.basic.vfs.File;
import org.clang.basic.vfs.FileSystem;
import org.clang.lex.PTHLexer;
import org.clang.lex.PTHManager;
import org.clang.lex.Preprocessor;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.clank.support.literal_constants;
import org.llvm.adt.StringRef;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.openide.util.Lookup;

public final class PTHManagerDriver
extends PTHManager {
    private final PTHProducer OnDemandPTHProducer;
    private final PTHManager ExistingTokenCache;
    private final boolean tokenizeAllFiles;
    private final boolean cacheTokensWithComments;
    private final boolean cacheIncompelteTokenFlag;
    private static final AtomicLong TotalRequestedLexers = new AtomicLong(0L);
    private static final AtomicLong TotalNonBuiltinRequestedLexers = new AtomicLong(0L);
    private static final AtomicLong cachedTokensCreatedSize = new AtomicLong(0L);
    private static final AtomicLong cachedTokensCreated = new AtomicLong(0L);
    private static final AtomicLong cachedTokensMisses = new AtomicLong(0L);
    private static final AtomicLong cachedTokensHit = new AtomicLong(0L);
    private static final AtomicLong cachedTokensSkipped = new AtomicLong(0L);
    private static final AtomicLong cachedExternalTokensMisses = new AtomicLong(0L);
    private static final AtomicLong cachedExternalTokensHit = new AtomicLong(0L);
    public static final String PREPARE_ALL_FILES_PTH_PROP = "clank.pth.cache.all";
    public static final boolean PREPARE_ALL_FILES_PTH = Boolean.valueOf(System.getProperty("clank.pth.cache.all", "" + NativeTrace.USE_PTH_DRIVER_IN_TEST));
    public static final String KEEP_PTH_COMMENTS_PROP = "clank.pth.keep.comments";
    public static final boolean KEEP_PTH_COMMENTS = Boolean.valueOf(System.getProperty("clank.pth.keep.comments", "" + !NativeTrace.CLANG_MODE));
    public static final String KEEP_INCOMPLETE_TOKEN_STATE_PROP = "clank.pth.keep.incomplete.token.state";
    public static final boolean KEEP_INCOMPLETE_TOKEN_STATE = Boolean.valueOf(System.getProperty("clank.pth.keep.incomplete.token.state", "" + !NativeTrace.CLANG_MODE));

    private PTHManagerDriver(PTHManager ExistingTokenCacheManager, PTHProducer PTHProducer2, boolean allFiles, boolean keepComments, boolean keepIncompleteTokenState) {
        this.ExistingTokenCache = ExistingTokenCacheManager;
        this.OnDemandPTHProducer = PTHProducer2;
        this.tokenizeAllFiles = allFiles;
        this.cacheTokensWithComments = keepComments;
        this.cacheIncompelteTokenFlag = keepIncompleteTokenState;
    }

    public static void PreparePTHForPreprocessor(Preprocessor P) {
        PTHProducer PTHProducer2 = (PTHProducer)Lookup.getDefault().lookup(PTHProducer.class);
        if (PTHProducer2 == null) {
            throw new IllegalStateException("Forgot to add org.clang.frontend to unit tests dependency?");
        }
        PTHManagerDriver pm = new PTHManagerDriver(null, PTHProducer2, true, true, true);
        assert (P.getIdentifierTable().getExternalIdentifierLookup() == null);
        P.setPTHManager(pm);
        pm.setPreprocessor(P);
    }

    public static PTHManager Create(PTHProducer PTHProducer2, MemoryBuffer tokenCacheMemBuffer, DiagnosticsEngine Diags) {
        PTHManager ExistingTokenCacheManager = null;
        if (tokenCacheMemBuffer != null) {
            ExistingTokenCacheManager = PTHManager.Create(tokenCacheMemBuffer, Diags);
        }
        return new PTHManagerDriver(ExistingTokenCacheManager, PTHProducer2, PREPARE_ALL_FILES_PTH, KEEP_PTH_COMMENTS, KEEP_INCOMPLETE_TOKEN_STATE);
    }

    @Override
    public void setPreprocessor(Preprocessor pp) {
        if (this.ExistingTokenCache != null) {
            this.ExistingTokenCache.setPreprocessor(pp);
        }
        super.setPreprocessor(pp);
    }

    @Override
    public PTHLexer CreateLexer(int FID) {
        FileEntry FE;
        if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
            TotalRequestedLexers.incrementAndGet();
        }
        assert (this.PP != null) : "Forgot to set Preprocessor for this manager?";
        if (FID == this.PP.getPredefinesFileID().$ID()) {
            return null;
        }
        if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
            TotalNonBuiltinRequestedLexers.incrementAndGet();
        }
        if (this.ExistingTokenCache != null) {
            PTHLexer CachedLexer = this.ExistingTokenCache.CreateLexer(FID);
            if (CachedLexer != null) {
                if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
                    cachedExternalTokensHit.incrementAndGet();
                }
                return CachedLexer;
            }
            if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
                cachedExternalTokensMisses.incrementAndGet();
            }
        }
        if ((FE = this.PP.getSourceManager().getFileEntryForID(FID)) == null) {
            return null;
        }
        MemoryBuffer sourceFile = this.PP.getSourceManager().getBuffer(FID);
        assert (sourceFile != null) : "No Buffer for " + FE;
        if (sourceFile.isInvalid()) {
            return null;
        }
        assert (!sourceFile.isInvalid()) : "Invalid Buffer for " + FE;
        MemoryBuffer tokenCacheBuf = sourceFile.getTokenCacheBuffer();
        if (tokenCacheBuf == null) {
            std.string LexedFileName;
            if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
                cachedTokensMisses.incrementAndGet();
            }
            if (this.OnDemandPTHProducer != null && (this.tokenizeAllFiles || FID != this.PP.getSourceManager().getMainFileID().$ID()) && (tokenCacheBuf = this.OnDemandPTHProducer.CreateCachedTokens(FID, LexedFileName = new StringRef(FE.getName()).str(), this.PP, this.cacheTokensWithComments, this.cacheIncompelteTokenFlag)) != null) {
                tokenCacheBuf = sourceFile.setTokenCacheBuffer(tokenCacheBuf);
                if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
                    cachedTokensCreated.incrementAndGet();
                    cachedTokensCreatedSize.addAndGet(tokenCacheBuf.getBufferSize());
                }
            }
        } else if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
            cachedTokensHit.incrementAndGet();
        }
        if (tokenCacheBuf == null) {
            if (NativeTrace.VERBOSE_MODE || NativeTrace.SERVICE_STATISTICS) {
                cachedTokensSkipped.incrementAndGet();
            }
            return null;
        }
        PTHManager SingleFilePTHManager = PTHManager.CreatePTHManagerImpl(tokenCacheBuf, this.PP.getDiagnostics(), this);
        assert (SingleFilePTHManager != null) : "can not create manager for " + FE + " from " + tokenCacheBuf.getBufferIdentifier();
        MemoryBuffer pthBuf = SingleFilePTHManager.$markShared(super.$isShared());
        assert (pthBuf == tokenCacheBuf);
        SingleFilePTHManager.setPreprocessor(this.PP);
        PTHLexer Out = SingleFilePTHManager.CreateLexer(FID);
        assert (Out != null) : "can not create lexer for " + FE + " from " + tokenCacheBuf.getBufferIdentifier();
        return Out;
    }

    @Override
    public IdentifierInfo GetIdentifierInfo(int PersistentID) {
        if (this.ExistingTokenCache != null) {
            return this.ExistingTokenCache.GetIdentifierInfo(PersistentID);
        }
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public std_ptr.unique_ptr<FileSystemStatCache> createStatCache() {
        return new std_ptr.unique_ptr((Object)new EmptyStatCache());
    }

    @Override
    public IdentifierInfo get(char.ptr Name, int Len) {
        if (this.ExistingTokenCache != null) {
            return this.ExistingTokenCache.get(Name, Len);
        }
        return null;
    }

    @Override
    public IdentifierInfo get(byte[] Name, int NameStIndex, int Len) {
        if (this.ExistingTokenCache != null) {
            return this.ExistingTokenCache.get(Name, NameStIndex, Len);
        }
        return null;
    }

    @Override
    public char.ptr getOriginalSourceFile() {
        if (this.ExistingTokenCache != null) {
            return this.ExistingTokenCache.getOriginalSourceFile();
        }
        return null;
    }

    public IdentifierIterator getIdentifiers() {
        if (this.ExistingTokenCache != null) {
            return this.ExistingTokenCache.getIdentifiers();
        }
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public String toString() {
        return "PTHManagerDriver{" + (Object)((Object)this.ExistingTokenCache) + '}';
    }

    @Override
    public MemoryBuffer $markShared(boolean shared) {
        MemoryBuffer buf = null;
        if (this.ExistingTokenCache != null) {
            buf = this.ExistingTokenCache.$markShared(shared);
        }
        MemoryBuffer OwnBuf = super.$markShared(shared);
        assert (OwnBuf == null);
        return buf;
    }

    @Override
    public MemoryBuffer $getTokenCache() {
        MemoryBuffer buf = null;
        if (this.ExistingTokenCache != null) {
            buf = this.ExistingTokenCache.$getTokenCache();
        }
        MemoryBuffer OwnBuf = super.$getTokenCache();
        assert (OwnBuf == null);
        return buf;
    }

    @Override
    public void $destroy() {
        if (this.ExistingTokenCache != null) {
            this.ExistingTokenCache.$destroy();
        }
        super.$destroy();
    }

    public IdentifierInfo getPPIdentifierInfo(byte[] SpellingBuf, int IdxInBuf, int Len) {
        assert (this.PP.getIdentifierTable() != null);
        assert (this.PP.getIdentifierTable().getExternalIdentifierLookup() == this || this.ExistingTokenCache == null) : "this PTHManager must be passed to PP constructor as external IdentifierInfoLookup";
        IdentifierInfo out = this.PP.getIdentifierInfo(SpellingBuf, IdxInBuf, Len);
        assert (out != null) : "no II for internal II: " + new StringRef(SpellingBuf, IdxInBuf);
        return out;
    }

    public static void clearStatistics() {
        TotalRequestedLexers.set(0L);
        TotalNonBuiltinRequestedLexers.set(0L);
        cachedTokensCreatedSize.set(0L);
        cachedTokensCreated.set(0L);
        cachedTokensMisses.set(0L);
        cachedTokensHit.set(0L);
        cachedTokensSkipped.set(0L);
        cachedExternalTokensMisses.set(0L);
        cachedExternalTokensHit.set(0L);
    }

    public static void printStats() {
        llvm.errs().$out("PTHManagerDriver statistics:").$out("\n\tTotal Requested Lexers: ").$out(NativeTrace.formatNumber((long)TotalRequestedLexers.longValue())).$out("\n\tTotal Non Builtin Files Requested Lexers: ").$out(NativeTrace.formatNumber((long)TotalNonBuiltinRequestedLexers.longValue())).$out("\n\tCreated Token Caches TotalSize: ").$out(NativeTrace.formatNumber((long)cachedTokensCreatedSize.longValue())).$out("\n\tCreated Token Caches: ").$out(NativeTrace.formatNumber((long)cachedTokensCreated.longValue())).$out("\n\tToken Caches Miss: ").$out(NativeTrace.formatNumber((long)cachedTokensMisses.longValue())).$out("\n\tToken Caches Hit: ").$out(NativeTrace.formatNumber((long)cachedTokensHit.longValue())).$out("\n\tToken Caches Skipped: ").$out(NativeTrace.formatNumber((long)cachedTokensSkipped.longValue())).$out("\n\tExternal Token Caches Miss: ").$out(NativeTrace.formatNumber((long)cachedExternalTokensMisses.longValue())).$out("\n\tExternal Token Caches Hit: ").$out(NativeTrace.formatNumber((long)cachedExternalTokensHit.longValue())).$out(literal_constants.$LF).flush();
    }

    private static final class EmptyStatCache
    extends FileSystemStatCache {
        private EmptyStatCache() {
        }

        protected FileSystemStatCache.LookupResult getStat(char.ptr Path, int PathLen, FileData Data, boolean isFile, std_ptr.unique_ptr<File> F, FileSystem FS) {
            return super.statChained(Path, PathLen, Data, isFile, F, FS);
        }
    }

    public static interface PTHProducer {
        public MemoryBuffer CreateCachedTokens(int var1, std.string var2, Preprocessor var3, boolean var4, boolean var5);
    }
}

