/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.SourceLocation;
import org.clang.lex.PPCallbacks;
import org.clang.lex.PragmaHandler;
import org.clang.lex.PragmaIntroducerKind;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm_unreachable;

public class PragmaMessageHandler
extends PragmaHandler
implements Destructors.ClassWithDestructor {
    private PPCallbacks.PragmaMessageKind Kind;
    private StringRef Namespace;

    private static String PragmaKind(PPCallbacks.PragmaMessageKind Kind2) {
        return PragmaMessageHandler.PragmaKind(Kind2, false);
    }

    private static String PragmaKind(PPCallbacks.PragmaMessageKind Kind2, boolean PragmaNameOnly) {
        switch (Kind2) {
            case PMK_Message: {
                return PragmaNameOnly ? "message" : "pragma message";
            }
            case PMK_Warning: {
                return PragmaNameOnly ? "warning" : "pragma warning";
            }
            case PMK_Error: {
                return PragmaNameOnly ? "error" : "pragma error";
            }
        }
        throw new llvm_unreachable("Unknown PragmaMessageKind!");
    }

    public PragmaMessageHandler(PPCallbacks.PragmaMessageKind Kind2) {
        this(Kind2, new StringRef());
    }

    public PragmaMessageHandler(PPCallbacks.PragmaMessageKind Kind2, StringRef Namespace) {
        super(PragmaMessageHandler.PragmaKind(Kind2, true));
        this.Kind = Kind2;
        this.Namespace = new StringRef(Namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void HandlePragma(Preprocessor PP, PragmaIntroducerKind Introducer, Token Tok) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            SourceLocation MessageLoc = Tok.getLocation();
            PP.Lex(Tok);
            boolean ExpectClosingParen = false;
            switch (Tok.getKind()) {
                case '\u0015': {
                    ExpectClosingParen = true;
                    PP.Lex(Tok);
                    break;
                }
                case '\r': {
                    break;
                }
                default: {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(new SourceLocation(MessageLoc), 841))), (int)this.Kind.getValue()));
                    return;
                }
            }
            std.string MessageString = new std.string();
            if (!PP.FinishLexStringLiteral(Tok, MessageString, PragmaMessageHandler.PragmaKind(this.Kind), true)) {
                return;
            }
            if (ExpectClosingParen) {
                if (Tok.isNot('\u0016')) {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(Tok.getLocation(), 841))), (int)this.Kind.getValue()));
                    return;
                }
                PP.Lex(Tok);
            }
            if (Tok.isNot('\u0002')) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(Tok.getLocation(), 841))), (int)this.Kind.getValue()));
                return;
            }
            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(new SourceLocation(MessageLoc), this.Kind == PPCallbacks.PragmaMessageKind.PMK_Error ? 840 : 997))), (StringRef)new StringRef(MessageString)));
            PPCallbacks Callbacks = PP.getPPCallbacks();
            if (Callbacks != null) {
                Callbacks.PragmaMessage(new SourceLocation(MessageLoc), new StringRef(this.Namespace), this.Kind, new StringRef(MessageString));
            }
        }
        finally {
            $c$.$destroy();
        }
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public String toString() {
        return "Kind=" + (Object)((Object)this.Kind) + ", Namespace=" + this.Namespace + super.toString();
    }
}

