/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.lex.LexClangGlobals;
import org.clang.lex.Preprocessor;
import org.clang.lex.impl.LiteralSupportStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.NativeContainerChar;
import org.clank.support.aliases.char;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchBool;
import org.llvm.support.llvm;

public class NumericLiteralParser
implements Destructors.ClassWithDestructor {
    private Preprocessor PP;
    private final char.ptr ThisTokBegin;
    private static final int NULL$INDEX = -1;
    private final int ThisTokBegin$Index;
    private int ThisTokEnd$Index;
    private int DigitsBegin$Index;
    private int SuffixBegin$Index;
    private char.ptr s;
    private int radix;
    private boolean saw_exponent;
    private boolean saw_period;
    private boolean saw_ud_suffix;
    private SmallString UDSuffixBuf;
    public boolean hadError;
    public boolean isUnsigned;
    public boolean isLong;
    public boolean isLongLong;
    public boolean isHalf;
    public boolean isFloat;
    public boolean isImaginary;
    public boolean isFloat128;
    public byte MicrosoftInteger;

    public NumericLiteralParser(StringRef TokSpelling, SourceLocation TokLoc, Preprocessor PP) {
        this(TokSpelling, TokLoc.getRawEncoding(), PP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumericLiteralParser(StringRef TokSpelling, int TokLoc, Preprocessor PP) {
        this.PP = PP;
        this.ThisTokBegin = Native.$noClone((char.ptr)TokSpelling.begin());
        this.UDSuffixBuf = new SmallString(32);
        this.ThisTokBegin$Index = this.ThisTokBegin.$index();
        this.ThisTokEnd$Index = this.ThisTokBegin$Index + TokSpelling.size();
        assert (!BasicClangGlobals.isPreprocessingNumberBody((byte)this.Ptr$star(this.ThisTokEnd$Index))) : "didn't maximally munch?";
        this.DigitsBegin$Index = this.ThisTokBegin$Index;
        this.s = Native.$tryClone((char.ptr)this.ThisTokBegin);
        this.saw_exponent = false;
        this.saw_period = false;
        this.saw_ud_suffix = false;
        this.isLong = false;
        this.isUnsigned = false;
        this.isLongLong = false;
        this.isHalf = false;
        this.isFloat = false;
        this.isImaginary = false;
        this.isFloat128 = false;
        this.MicrosoftInteger = 0;
        this.hadError = false;
        if (this.s.$star() == 48) {
            this.ParseNumberStartingWithZero(TokLoc);
            if (this.hadError) {
                return;
            }
        } else {
            this.radix = 10;
            this.s = Native.$noClone((char.ptr)this.SkipDigits(this.s));
            if (this.s.$index() != this.ThisTokEnd$Index) {
                this.ParseDecimalOrOctalCommon(TokLoc);
                if (this.hadError) {
                    return;
                }
            }
        }
        this.SuffixBegin$Index = this.s.$index();
        this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
        boolean isFPConstant = this.isFloatingLiteral();
        int ImaginarySuffixLoc$Index = -1;
        while (this.s.$index() != this.ThisTokEnd$Index) {
            block38: {
                switch (this.s.$star()) {
                    case 72: 
                    case 104: {
                        if (!PP.getLangOpts().Half || !isFPConstant || this.isHalf || this.isFloat || this.isLong) break;
                        this.isHalf = true;
                        break block38;
                    }
                    case 70: 
                    case 102: {
                        if (!isFPConstant || this.isHalf || this.isFloat || this.isLong || this.isFloat128) break;
                        this.isFloat = true;
                        break block38;
                    }
                    case 81: 
                    case 113: {
                        if (!isFPConstant || this.isHalf || this.isFloat || this.isLong || this.isFloat128) break;
                        this.isFloat128 = true;
                        break block38;
                    }
                    case 85: 
                    case 117: {
                        if (isFPConstant || this.isUnsigned) break;
                        this.isUnsigned = true;
                        break block38;
                    }
                    case 76: 
                    case 108: {
                        if (this.isLong || this.isLongLong || this.isHalf || this.isFloat || this.isFloat128) break;
                        if (this.s.$at(1) == this.s.$at(0)) {
                            assert (this.s.$index() + 1 < this.ThisTokEnd$Index) : "didn't maximally munch?";
                            if (isFPConstant) break;
                            this.isLongLong = true;
                            this.s.$preInc();
                            break block38;
                        } else {
                            this.isLong = true;
                        }
                        break block38;
                    }
                    case 73: 
                    case 105: {
                        if (PP.getLangOpts().MicrosoftExt) {
                            if (this.isLong || this.isLongLong || this.MicrosoftInteger != 0) break;
                            if (!isFPConstant) {
                                switch (this.s.$at(1)) {
                                    case 56: {
                                        this.s.$inc(2);
                                        this.MicrosoftInteger = (byte)8;
                                        break;
                                    }
                                    case 49: {
                                        if (this.s.$at(2) != 54) break;
                                        this.s.$inc(3);
                                        this.MicrosoftInteger = (byte)16;
                                        break;
                                    }
                                    case 51: {
                                        if (this.s.$at(2) != 50) break;
                                        this.s.$inc(3);
                                        this.MicrosoftInteger = (byte)32;
                                        break;
                                    }
                                    case 54: {
                                        if (this.s.$at(2) != 52) break;
                                        this.s.$inc(3);
                                        this.MicrosoftInteger = (byte)64;
                                        break;
                                    }
                                }
                            }
                            if (this.MicrosoftInteger != 0) {
                                assert (this.s.$index() <= this.ThisTokEnd$Index) : "didn't maximally munch?";
                                break;
                            }
                        }
                        if (PP.getLangOpts().CPlusPlus14 && this.s.$star() == 105) break;
                    }
                    case 74: 
                    case 106: {
                        if (this.isImaginary) break;
                        this.isImaginary = true;
                        ImaginarySuffixLoc$Index = this.s.$index();
                        break block38;
                    }
                }
                break;
            }
            this.s.$preInc();
        }
        if (this.s.$index() != this.ThisTokEnd$Index) {
            LexClangGlobals.expandUCNs(this.UDSuffixBuf, new StringRef(this.$SuffixBegin(), this.ThisTokEnd$Index - this.SuffixBegin$Index));
            if (NumericLiteralParser.isValidUDSuffix(PP.getLangOpts(), this.UDSuffixBuf.$StringRef())) {
                this.isLong = false;
                this.isUnsigned = false;
                this.isLongLong = false;
                this.isFloat = false;
                this.isHalf = false;
                this.isImaginary = false;
                this.MicrosoftInteger = 0;
                this.saw_ud_suffix = true;
                return;
            }
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out$Same2Bool((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.Diag(PP.AdvanceToTokenCharacter(TokLoc, this.SuffixBegin$Index - this.ThisTokBegin$Index), 740))), (StringRef)new StringRef(this.$SuffixBegin(), this.ThisTokEnd$Index - this.SuffixBegin$Index)), (boolean)isFPConstant));
                this.hadError = true;
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        if (!this.isImaginary) return;
        assert (-1 != ImaginarySuffixLoc$Index);
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)PP.Diag(PP.AdvanceToTokenCharacter(TokLoc, ImaginarySuffixLoc$Index - this.ThisTokBegin$Index), 871))));
            return;
        }
        finally {
            $c$.$destroy();
        }
    }

    public boolean isIntegerLiteral() {
        return !this.saw_period && !this.saw_exponent;
    }

    public boolean isFloatingLiteral() {
        return this.saw_period || this.saw_exponent;
    }

    public boolean hasUDSuffix() {
        return this.saw_ud_suffix;
    }

    public StringRef getUDSuffix() {
        assert (this.saw_ud_suffix);
        return this.UDSuffixBuf.$StringRef();
    }

    public SmallString $getUDSuffix() {
        return this.UDSuffixBuf;
    }

    public int getUDSuffixOffset() {
        assert (this.saw_ud_suffix);
        return this.SuffixBegin$Index - this.ThisTokBegin$Index;
    }

    public static boolean isValidUDSuffix(LangOptions LangOpts, StringRef Suffix) {
        if (!LangOpts.CPlusPlus11 || Suffix.empty()) {
            return false;
        }
        if (Suffix.$at(0) == 95) {
            return true;
        }
        if (!LangOpts.CPlusPlus14) {
            return false;
        }
        return new StringSwitchBool(Suffix).Cases("h", "min", "s", true).Cases("ms", "us", "ns", true).Cases("il", "i", "if", true).Default(false);
    }

    public int getRadix() {
        return this.radix;
    }

    public boolean GetIntegerValue(APInt Val) {
        int NumDigits = this.SuffixBegin$Index - this.DigitsBegin$Index;
        if (LiteralSupportStatics.alwaysFitsInto64Bits(this.radix, NumDigits)) {
            long N = 0L;
            for (int Ptr = this.DigitsBegin$Index; Ptr != this.SuffixBegin$Index; ++Ptr) {
                if (NumericLiteralParser.isDigitSeparator(this.Ptr$star(Ptr))) continue;
                N = N * Unsigned.$uint2ullong((int)this.radix) + Unsigned.$uint2ullong((int)llvm.hexDigitValue((byte)this.Ptr$star(Ptr)));
            }
            Val.$assign(N);
            return Val.getZExtValue() != N;
        }
        Val.$assign(0L);
        int Ptr = this.DigitsBegin$Index;
        APInt RadixVal = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, Val.getBitWidth(), Unsigned.$uint2ulong((int)this.radix));
        APInt CharVal = new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, Val.getBitWidth(), 0L);
        APInt OldVal = new APInt(Val);
        boolean OverflowOccurred = false;
        while (Ptr < this.SuffixBegin$Index) {
            if (NumericLiteralParser.isDigitSeparator(this.Ptr$star(Ptr))) {
                ++Ptr;
                continue;
            }
            int C = llvm.hexDigitValue((byte)this.Ptr$star(Ptr));
            ++Ptr;
            assert (Unsigned.$less_uint((int)C, (int)this.radix)) : "NumericLiteralParser ctor should have rejected this";
            CharVal.$assign(Unsigned.$uint2ulong((int)C));
            OldVal.$assign(Val);
            Val.$starassign(RadixVal);
            OverflowOccurred |= Val.udiv(RadixVal).$noteq(OldVal);
            Val.$addassign(CharVal);
            OverflowOccurred |= Val.ult(CharVal);
        }
        return OverflowOccurred;
    }

    public int GetFloatValue(APFloat Result) {
        int n = std.min((int)(this.SuffixBegin$Index - this.ThisTokBegin$Index), (int)(this.ThisTokEnd$Index - this.ThisTokBegin$Index));
        SmallString Buffer = new SmallString(16);
        StringRef Str = new StringRef(this.ThisTokBegin, n);
        if (Str.find((byte)39) != StringRef.npos) {
            Buffer.reserve(n);
            std.remove_copy_if((char.iterator)Str.begin(), (char.iterator)Str.end(), (char.iterator)std.back_inserter((NativeContainerChar)Buffer), NumericLiteralParser::isDigitSeparator);
            Str.$assignMove(Buffer.$StringRef());
        }
        return Result.convertFromString(Str, APFloat.roundingMode.rmNearestTiesToEven);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ParseNumberStartingWithZero(int TokLoc) {
        byte c2;
        assert (this.s.$at(0) == 48) : "Invalid method call";
        this.s.$preInc();
        byte c1 = this.s.$at(0);
        if (!(c1 != 120 && c1 != 88 || !BasicClangGlobals.isHexDigit((byte)(c2 = this.s.$at(1))) && c2 != 46)) {
            this.s.$preInc();
            assert (this.s.$index() < this.ThisTokEnd$Index) : "didn't maximally munch?";
            this.radix = 16;
            this.DigitsBegin$Index = this.s.$index();
            byte DigitsBegin$at0 = c2;
            assert (DigitsBegin$at0 == this.s.$at(0));
            this.s = Native.$noClone((char.ptr)this.SkipHexDigits(this.s));
            boolean HasSignificandDigits = this.containsDigits(this.DigitsBegin$Index, this.s.$index(), DigitsBegin$at0);
            if (this.s.$index() != this.ThisTokEnd$Index && this.s.$star() == 46) {
                this.s.$preInc();
                this.saw_period = true;
                int floatDigitsBegin$Index = this.s.$index();
                byte floatDigitsBegin$at0 = this.s.$star();
                assert (46 == this.s.$at(-1)) : "Expected . to be seen before s.$preInc above but got " + Unsigned.$uchar2ushort((byte)this.s.$at(-1));
                this.s = Native.$noClone((char.ptr)this.SkipHexDigits(this.s));
                if (this.containsDigits(floatDigitsBegin$Index, this.s.$index(), floatDigitsBegin$at0)) {
                    HasSignificandDigits = true;
                }
                if (HasSignificandDigits) {
                    int s$index = this.s.$index();
                    char.ptr floatDigitsBegin = this.s;
                    Native.$setIndex((char.ptr)floatDigitsBegin, (int)floatDigitsBegin$Index);
                    this.checkSeparator(TokLoc, floatDigitsBegin, CheckSeparatorKind.CSK_BeforeDigits);
                    Native.$setIndex((char.ptr)floatDigitsBegin, (int)s$index);
                    assert (this.s == floatDigitsBegin) : "must be the same pointers";
                    assert (this.s.$index() == s$index) : "must be the same indices";
                }
            }
            if (!HasSignificandDigits) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_uint((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 734))), (boolean)this.PP.getLangOpts().CPlusPlus), (int)1));
                    this.hadError = true;
                    return;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (this.s.$star() == 112 || this.s.$star() == 80) {
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
                int Exponent$Index = this.s.$index();
                this.s.$preInc();
                this.saw_exponent = true;
                if (this.s.$star() == 43 || this.s.$star() == 45) {
                    this.s.$preInc();
                }
                int s$index = this.s.$index();
                byte s$at0 = this.s.$at(0);
                char.ptr first_non_digit = Native.$noClone((char.ptr)this.SkipDigits(this.s));
                assert (first_non_digit == this.s) : "we used SkipDigits above which reuse pointer";
                int first_non_digit$index = first_non_digit.$index();
                if (!this.containsDigits(s$index, first_non_digit$index, s$at0)) {
                    Native.$setIndex((char.ptr)this.s, (int)s$index);
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, Exponent$Index - this.ThisTokBegin$Index), 732))));
                        this.hadError = true;
                        return;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                Native.$setIndex((char.ptr)this.s, (int)s$index);
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
                Native.$setIndex((char.ptr)this.s, (int)first_non_digit$index);
                if (!this.PP.getLangOpts().HexFloats) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(TokLoc, this.PP.getLangOpts().CPlusPlus ? 870 : 869))));
                    }
                    finally {
                        $c$.$destroy();
                    }
                } else if (this.PP.getLangOpts().CPlusPlus1z) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(TokLoc, 953))));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            } else if (this.saw_period) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_uint((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 734))), (boolean)this.PP.getLangOpts().CPlusPlus), (int)0));
                    this.hadError = true;
                }
                finally {
                    $c$.$destroy();
                }
            }
            return;
        }
        if (!(c1 != 98 && c1 != 66 || this.s.$at(1) != 48 && this.s.$at(1) != 49)) {
            this.PP.Diag(TokLoc, this.PP.getLangOpts().CPlusPlus14 ? 947 : (this.PP.getLangOpts().CPlusPlus ? 859 : 858)).$destroy();
            this.s.$preInc();
            assert (this.s.$index() < this.ThisTokEnd$Index) : "didn't maximally munch?";
            this.radix = 2;
            this.DigitsBegin$Index = this.s.$index();
            this.s = Native.$noClone((char.ptr)this.SkipBinaryDigits(this.s));
            if (this.s.$index() != this.ThisTokEnd$Index && BasicClangGlobals.isHexDigit((byte)this.s.$star())) {
                BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 738), (StringRef)new StringRef(this.s, 1)), (int)2).$destroy();
                this.hadError = true;
            }
            return;
        }
        this.radix = 8;
        this.DigitsBegin$Index = this.s.$index();
        this.s = Native.$noClone((char.ptr)this.SkipOctalDigits(this.s));
        if (this.s.$index() == this.ThisTokEnd$Index) {
            return;
        }
        if (BasicClangGlobals.isDigit((byte)this.s.$star())) {
            int s$index = this.s.$index();
            char.ptr EndDecimal = Native.$noClone((char.ptr)this.SkipDigits(this.s));
            assert (this.s == EndDecimal) : "we used SkipDigits above which reuse pointer";
            if (EndDecimal.$at(0) == 46 || EndDecimal.$at(0) == 101 || EndDecimal.$at(0) == 69) {
                this.s = Native.$noClone((char.ptr)EndDecimal);
                this.radix = 10;
            } else {
                Native.$setIndex((char.ptr)this.s, (int)s$index);
            }
        }
        this.ParseDecimalOrOctalCommon(TokLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ParseDecimalOrOctalCommon(int TokLoc) {
        assert (this.radix == 8 || this.radix == 10) : "Unexpected radix";
        if (BasicClangGlobals.isHexDigit((byte)this.s.$star()) && this.s.$star() != 101 && this.s.$star() != 69) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 738))), (StringRef)new StringRef(this.s, 1)), (int)(this.radix == 8 ? 1 : 0)));
                this.hadError = true;
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        if (this.s.$star() == 46) {
            this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
            this.s.$preInc();
            this.radix = 10;
            this.saw_period = true;
            this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
            this.s = Native.$noClone((char.ptr)this.SkipDigits(this.s));
        }
        if (this.s.$star() == 101 || this.s.$star() == 69) {
            this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
            int Exponent$Index = this.s.$index();
            this.s.$preInc();
            this.radix = 10;
            this.saw_exponent = true;
            if (this.s.$star() == 43 || this.s.$star() == 45) {
                this.s.$preInc();
            }
            int s$index = this.s.$index();
            byte s$at0 = this.s.$at(0);
            char.ptr first_non_digit = Native.$noClone((char.ptr)this.SkipDigits(this.s));
            assert (first_non_digit == this.s) : "we used SkipDigits above which reuse pointer";
            int first_non_digit$index = first_non_digit.$index();
            if (this.containsDigits(s$index, first_non_digit$index, s$at0)) {
                Native.$setIndex((char.ptr)this.s, (int)s$index);
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
                Native.$setIndex((char.ptr)this.s, (int)first_non_digit$index);
            } else {
                Native.$setIndex((char.ptr)this.s, (int)s$index);
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, Exponent$Index - this.ThisTokBegin$Index), 732))));
                    this.hadError = true;
                    return;
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
    }

    private static boolean isDigitSeparator(byte C) {
        return C == 39;
    }

    private boolean containsDigits(int Start$Index, int End$Index, byte Start$at0) {
        return Start$Index != End$Index && (Start$Index + 1 != End$Index || !NumericLiteralParser.isDigitSeparator(Start$at0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSeparator(int TokLoc, char.ptr Pos, CheckSeparatorKind IsAfterDigits) {
        int $PosDecremented = 0;
        if (IsAfterDigits == CheckSeparatorKind.CSK_AfterDigits) {
            if (Pos.$index() == this.ThisTokBegin$Index) {
                return;
            }
            --$PosDecremented;
        } else if (Pos.$index() == this.ThisTokEnd$Index) {
            return;
        }
        if (NumericLiteralParser.isDigitSeparator(Pos.$at($PosDecremented))) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_int((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, $PosDecremented + Pos.$sub((abstract_iterator)this.ThisTokBegin)), 728))), (int)IsAfterDigits.getValue()));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    private char.ptr SkipHexDigits(char.ptr ptr2) {
        byte ptr$star;
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd$Index && (BasicClangGlobals.isHexDigit((byte)(ptr$star = ptr2.$star())) || NumericLiteralParser.isDigitSeparator(ptr$star))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    private char.ptr SkipOctalDigits(char.ptr ptr2) {
        byte ptr$star;
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd$Index && ((ptr$star = ptr2.$star()) >= 48 && ptr$star <= 55 || NumericLiteralParser.isDigitSeparator(ptr$star))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    private char.ptr SkipDigits(char.ptr ptr2) {
        byte ptr$star;
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd$Index && (BasicClangGlobals.isDigit((byte)(ptr$star = ptr2.$star())) || NumericLiteralParser.isDigitSeparator(ptr$star))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    private char.ptr SkipBinaryDigits(char.ptr ptr2) {
        byte ptr$star;
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd$Index && ((ptr$star = ptr2.$star()) == 48 || ptr$star == 49 || NumericLiteralParser.isDigitSeparator(ptr$star))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    public void $destroy() {
        this.UDSuffixBuf.$destroy();
    }

    public NumericLiteralParser(NumericLiteralParser $Prm0) {
        throw new UnsupportedOperationException();
    }

    public NumericLiteralParser(JavaDifferentiators.JD$Move _dparam, NumericLiteralParser $Prm0) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ", ThisTokBegin=" + this.ThisTokBegin + ", ThisTokEnd=" + this.ThisTokEnd$Index + ", DigitsBegin=" + this.DigitsBegin$Index + ", SuffixBegin=" + this.SuffixBegin$Index + ", s=" + this.s + ", radix=" + this.radix + ", saw_exponent=" + this.saw_exponent + ", saw_period=" + this.saw_period + ", saw_ud_suffix=" + this.saw_ud_suffix + ", UDSuffixBuf=" + this.UDSuffixBuf + ", hadError=" + this.hadError + ", isUnsigned=" + this.isUnsigned + ", isLong=" + this.isLong + ", isLongLong=" + this.isLongLong + ", isHalf=" + this.isHalf + ", isFloat=" + this.isFloat + ", isImaginary=" + this.isImaginary + ", isFloat128=" + this.isFloat128 + ", MicrosoftInteger=" + Unsigned.$uchar2uint((byte)this.MicrosoftInteger);
    }

    private char.ptr $SuffixBegin() {
        int shift = this.SuffixBegin$Index - this.ThisTokBegin$Index;
        return shift == 0 ? this.ThisTokBegin : (char.ptr)this.ThisTokBegin.$add(shift);
    }

    private byte Ptr$star(int PtrIndex) {
        return this.ThisTokBegin.$at(PtrIndex - this.ThisTokBegin$Index);
    }

    private static final class CheckSeparatorKind
    extends Enum<CheckSeparatorKind>
    implements Native.ComparableLower {
        public static final /* enum */ CheckSeparatorKind CSK_BeforeDigits = new CheckSeparatorKind(0);
        public static final /* enum */ CheckSeparatorKind CSK_AfterDigits = new CheckSeparatorKind(CSK_BeforeDigits.getValue() + 1);
        private final int value;
        private static final /* synthetic */ CheckSeparatorKind[] $VALUES;

        public static CheckSeparatorKind[] values() {
            return (CheckSeparatorKind[])$VALUES.clone();
        }

        public static CheckSeparatorKind valueOf(String name) {
            return Enum.valueOf(CheckSeparatorKind.class, name);
        }

        public static CheckSeparatorKind valueOf(int val) {
            CheckSeparatorKind out;
            CheckSeparatorKind checkSeparatorKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private CheckSeparatorKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((CheckSeparatorKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((CheckSeparatorKind)((Object)obj)).value);
        }

        static {
            $VALUES = new CheckSeparatorKind[]{CSK_BeforeDigits, CSK_AfterDigits};
        }

        private static final class Values {
            private static final CheckSeparatorKind[] VALUES;
            private static final CheckSeparatorKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CheckSeparatorKind kind : CheckSeparatorKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CheckSeparatorKind[min < 0 ? 1 - min : 0];
                VALUES = new CheckSeparatorKind[max >= 0 ? 1 + max : 0];
                for (CheckSeparatorKind kind : CheckSeparatorKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CheckSeparatorKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CheckSeparatorKind)kind).value] = kind;
                }
            }
        }
    }
}

