/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.DefMacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.UndefMacroDirective;
import org.clang.lex.VisibilityMacroDirective;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public abstract class MacroDirective {
    private int HashLoc = SourceLocation.getInvalid();
    private int EodLoc = SourceLocation.getInvalid();
    protected MacroDirective Previous = null;
    protected int Loc;
    protected Kind MDKind;
    protected boolean IsFromPCH;
    protected boolean IsPublic;

    protected void setLocationRange(int HashLoc, int EodLoc) {
        assert (SourceLocation.isInvalid((int)this.HashLoc)) : "must be initialized once";
        assert (SourceLocation.isInvalid((int)this.EodLoc)) : "must be initialized once";
        this.HashLoc = HashLoc;
        this.EodLoc = EodLoc;
    }

    public int getHashLoc() {
        return this.HashLoc;
    }

    public int getEodLoc() {
        return this.EodLoc;
    }

    protected MacroDirective(Kind K, int Loc) {
        this.Loc = Loc;
        this.MDKind = K;
        this.IsFromPCH = false;
        this.IsPublic = true;
    }

    public Kind getKind() {
        return this.MDKind;
    }

    public SourceLocation getLocation() {
        return SourceLocation.getFromRawEncoding((int)this.Loc);
    }

    public int $getLocation() {
        return this.Loc;
    }

    public void setPrevious(MacroDirective Prev) {
        this.Previous = Prev;
    }

    public MacroDirective getPrevious() {
        return this.Previous;
    }

    public boolean isFromPCH() {
        return this.IsFromPCH;
    }

    public void setIsFromPCH() {
        this.IsFromPCH = true;
    }

    public DefInfo getDefinition() {
        int UndefLoc = SourceLocation.getInvalid();
        boolean isPublic$hasValue = false;
        boolean isPublic$Value = false;
        for (MacroDirective MD = this; MD != null; MD = MD.getPrevious()) {
            if (MD instanceof DefMacroDirective) {
                return new DefInfo((DefMacroDirective)MD, UndefLoc, !isPublic$hasValue || isPublic$Value);
            }
            if (MD instanceof UndefMacroDirective) {
                UndefLoc = MD.$getLocation();
                continue;
            }
            VisibilityMacroDirective VisMD = (VisibilityMacroDirective)MD;
            if (isPublic$hasValue) continue;
            isPublic$hasValue = true;
            isPublic$Value = VisMD.isPublic();
        }
        return new DefInfo(null, UndefLoc, !isPublic$hasValue || isPublic$Value);
    }

    public DefInfo getDefinition$Const() {
        return this.getDefinition();
    }

    public boolean isDefined() {
        DefInfo Def = this.getDefinition();
        if (Def.$bool()) {
            return !Def.isUndefined();
        }
        return false;
    }

    public MacroInfo getMacroInfo$Const() {
        return this.getDefinition$Const().getMacroInfo$Const();
    }

    public MacroInfo getMacroInfo() {
        return this.getDefinition().getMacroInfo();
    }

    public DefInfo findDirectiveAtLoc(SourceLocation L, SourceManager SM) {
        return this.findDirectiveAtLoc(L.getRawEncoding(), SM);
    }

    public DefInfo findDirectiveAtLoc(int L, SourceManager SM) {
        assert (SourceLocation.isValid((int)L)) : "SourceLocation is invalid.";
        DefInfo Def = this.getDefinition();
        while (Def.$bool()) {
            if (SourceLocation.isInvalid((int)Def.getLocation()) || SM.isBeforeInTranslationUnit(Def.getLocation(), L)) {
                return !Def.isUndefined() || SM.isBeforeInTranslationUnit(L, Def.getUndefLocation()) ? Def : new DefInfo();
            }
            Def.$assign(Def.getPreviousDefinition());
        }
        return new DefInfo();
    }

    public void dump() {
        this.dump(llvm.errs());
    }

    public void dump(raw_ostream Out) {
        MacroInfo Info;
        DefMacroDirective DMD;
        switch (this.getKind()) {
            case MD_Define: {
                Out.$out("DefMacroDirective");
                break;
            }
            case MD_Undefine: {
                Out.$out("UndefMacroDirective");
                break;
            }
            case MD_Visibility: {
                Out.$out("VisibilityMacroDirective");
            }
        }
        Out.$out(NativePointer.$SPACE).$out((Object)this);
        MacroDirective Prev = this.getPrevious();
        if (Prev != null) {
            Out.$out(" prev ").$out((Object)Prev);
        }
        if (this.IsFromPCH) {
            Out.$out(" from_pch");
        }
        if (llvm.isa(VisibilityMacroDirective.class, (Object)this)) {
            Out.$out(this.IsPublic ? NativePointer.$((String)" public") : NativePointer.$((String)" private"));
        }
        if ((DMD = (DefMacroDirective)llvm.dyn_cast(DefMacroDirective.class, (Object)this)) != null && (Info = DMD.getInfo()) != null) {
            Out.$out("\n  ");
            Info.dump(Out);
        }
        Out.$out(NativePointer.$LF);
    }

    public static boolean classof(MacroDirective $Prm0) {
        return true;
    }

    public String toString() {
        return "Previous=" + this.Previous + ", Loc=" + SourceLocation.toString((int)this.Loc) + ", MDKind=" + (Object)((Object)this.MDKind) + ", IsFromPCH=" + this.IsFromPCH + ", IsPublic=" + this.IsPublic;
    }

    public static class DefInfo
    implements Native.Native$Bool {
        private DefMacroDirective DefDirective;
        private int UndefLoc;
        private boolean IsPublic;

        public DefInfo() {
            this.DefDirective = null;
            this.UndefLoc = SourceLocation.getInvalid();
            this.IsPublic = true;
        }

        public DefInfo(DefMacroDirective DefDirective, int UndefLoc, boolean isPublic) {
            this.DefDirective = DefDirective;
            this.UndefLoc = UndefLoc;
            this.IsPublic = isPublic;
        }

        public DefMacroDirective getDirective() {
            return this.DefDirective;
        }

        public int getLocation() {
            if (this.isInvalid()) {
                return SourceLocation.getInvalid();
            }
            return this.DefDirective.$getLocation();
        }

        public MacroInfo getMacroInfo() {
            if (this.isInvalid()) {
                return null;
            }
            return this.DefDirective.getInfo();
        }

        public MacroInfo getMacroInfo$Const() {
            return this.getMacroInfo();
        }

        public int getUndefLocation() {
            return this.UndefLoc;
        }

        public boolean isUndefined() {
            return SourceLocation.isValid((int)this.UndefLoc);
        }

        public boolean isPublic() {
            return this.IsPublic;
        }

        public boolean isValid() {
            return this.DefDirective != null;
        }

        public boolean isInvalid() {
            return !this.isValid();
        }

        public boolean $bool() {
            return this.isValid();
        }

        public DefInfo getPreviousDefinition() {
            if (this.isInvalid() || this.DefDirective.getPrevious() == null) {
                return new DefInfo();
            }
            return this.DefDirective.getPrevious().getDefinition();
        }

        public DefInfo(DefInfo $Prm0) {
            this.DefDirective = $Prm0.DefDirective;
            this.UndefLoc = $Prm0.UndefLoc;
            this.IsPublic = $Prm0.IsPublic;
        }

        public DefInfo(JavaDifferentiators.JD$Move _dparam, DefInfo $Prm0) {
            this.DefDirective = $Prm0.DefDirective;
            this.UndefLoc = $Prm0.UndefLoc;
            this.IsPublic = $Prm0.IsPublic;
        }

        public DefInfo $assign(DefInfo $Prm0) {
            this.DefDirective = $Prm0.DefDirective;
            this.UndefLoc = $Prm0.UndefLoc;
            this.IsPublic = $Prm0.IsPublic;
            return this;
        }

        public DefInfo $assignMove(DefInfo $Prm0) {
            this.DefDirective = $Prm0.DefDirective;
            this.UndefLoc = $Prm0.UndefLoc;
            this.IsPublic = $Prm0.IsPublic;
            return this;
        }

        public String toString() {
            return "DefDirective=" + this.DefDirective + ", UndefLoc=" + this.UndefLoc + ", IsPublic=" + this.IsPublic;
        }
    }

    public static final class Kind
    extends Enum<Kind>
    implements Native.ComparableLower {
        public static final /* enum */ Kind MD_Define = new Kind(0);
        public static final /* enum */ Kind MD_Undefine = new Kind(MD_Define.getValue() + 1);
        public static final /* enum */ Kind MD_Visibility = new Kind(MD_Undefine.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        public static Kind valueOf(int val) {
            Kind out;
            Kind kind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Kind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((Kind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((Kind)((Object)obj)).value);
        }

        static {
            $VALUES = new Kind[]{MD_Define, MD_Undefine, MD_Visibility};
        }

        private static final class Values {
            private static final Kind[] VALUES;
            private static final Kind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Kind kind : Kind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Kind[min < 0 ? 1 - min : 0];
                VALUES = new Kind[max >= 0 ? 1 + max : 0];
                for (Kind kind : Kind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Kind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Kind)kind).value] = kind;
                }
            }
        }
    }
}

