/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import java.util.Arrays;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.tok;
import org.clang.lex.Lexer;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.llvm.SmallVectorToken;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.llvm.adt.SmallString;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class MacroArgs
implements Destructors.ClassWithDestructor {
    private static final int MAX_PARAMETERS_SIZE = Integer.getInteger("apt.limit.expanded.params", 1000);
    private int NumUnexpArgTokens;
    private final Token[] UnexpArgTokens;
    private boolean VarargsElided;
    private final SmallVector<SmallVectorToken> PreExpArgTokens;
    private final SmallVectorToken StringifiedArgs;
    private MacroArgs ArgCache;
    private static long instances = 0L;

    private MacroArgs(int NumToks, boolean varargsElided) {
        this.NumUnexpArgTokens = NumToks;
        this.UnexpArgTokens = new Token[NumToks];
        for (int i = 0; i < this.UnexpArgTokens.length; ++i) {
            this.UnexpArgTokens[i] = new Token();
        }
        this.VarargsElided = varargsElided;
        this.PreExpArgTokens = new SmallVector(0, null);
        this.StringifiedArgs = new SmallVectorToken(0, null);
        this.ArgCache = null;
        MacroArgs.trackInstance();
    }

    public void $destroy() {
        this.PreExpArgTokens.set_size(0);
        this.PreExpArgTokens.set_size(0);
        this.StringifiedArgs.set_size(0);
        for (int i = 0; i < this.NumUnexpArgTokens; ++i) {
            this.UnexpArgTokens[i].$destroy();
        }
    }

    public static MacroArgs create(MacroInfo MI, SmallVectorToken UnexpArgTokens, boolean VarargsElided, Preprocessor PP) {
        MacroArgs Result;
        assert (MI.isFunctionLike()) : "Can't have args for an object-like macro!";
        MacroArgs ResultEnt = null;
        MacroArgs PreviousEnt = null;
        MacroArgs PreviousForResultEnt = null;
        int ClosestMatch = -1;
        int neededSize = UnexpArgTokens.size();
        MacroArgs Entry2 = PP.MacroArgCache;
        while (Entry2 != null) {
            if (Unsigned.$greatereq_uint((int)Entry2.NumUnexpArgTokens, (int)neededSize) && Unsigned.$less_uint((int)Native.$Deref((int)Entry2.NumUnexpArgTokens), (int)ClosestMatch)) {
                ResultEnt = Entry2;
                PreviousForResultEnt = PreviousEnt;
                if (Entry2.NumUnexpArgTokens == neededSize) break;
                ClosestMatch = Native.$Deref((int)Entry2.NumUnexpArgTokens);
            }
            PreviousEnt = Entry2;
            Entry2 = Entry2.ArgCache;
        }
        if (ResultEnt == null) {
            Result = new MacroArgs(neededSize, VarargsElided);
        } else {
            Result = ResultEnt;
            assert (Result != null);
            --PP.MacroArgCacheNumEntries;
            PP.MacroArgCacheCapacity -= Result.$UnexpArgTokens().length;
            if (PreviousForResultEnt == null) {
                assert (PP.MacroArgCache == Result);
                PP.MacroArgCache = Result.ArgCache;
            } else {
                assert (PreviousForResultEnt.ArgCache == Result);
                PreviousForResultEnt.ArgCache = Result.ArgCache;
            }
            Result.NumUnexpArgTokens = neededSize;
            Result.VarargsElided = VarargsElided;
        }
        if (!UnexpArgTokens.empty()) {
            for (int i = 0; i < neededSize; ++i) {
                Result.$UnexpArgTokens()[i].$assign(UnexpArgTokens.$array()[i]);
            }
        }
        return Result;
    }

    public void destroy(Preprocessor PP) {
        this.StringifiedArgs.clear();
        int e = this.PreExpArgTokens.size();
        for (int i = 0; i != e; ++i) {
            ((SmallVectorToken)this.PreExpArgTokens.$at(i)).clear();
        }
        int capacity = this.$UnexpArgTokens().length;
        if (capacity < Preprocessor.MACRO_ARG_ELEMENT_MAX_CAPACITY && PP.MacroArgCacheCapacity < Preprocessor.MACRO_ARG_CACHE_MAX_CAPACITY) {
            this.ArgCache = PP.MacroArgCache;
            PP.MacroArgCache = this;
            ++PP.MacroArgCacheNumEntries;
            PP.MacroArgCacheCapacity += capacity;
        } else if (NativeTrace.VERBOSE_MODE) {
            llvm.errs().$out("<=Skip MacroArg ").$out(NativeTrace.formatNumber((long)capacity, (int)12));
            llvm.errs().$out(" Where Total Capacity ").$out(NativeTrace.formatNumber((long)PP.MacroArgCacheCapacity, (int)12)).$out(NativePointer.$LF);
        }
    }

    public static boolean ArgNeedsPreexpansion(Token[] ArgTok, int ArgTokenIdx, Preprocessor PP) {
        while (ArgTok[ArgTokenIdx].isNot('\u0001')) {
            IdentifierInfo II = ArgTok[ArgTokenIdx].getIdentifierInfo();
            if (II != null && II.hasMacroDefinition()) {
                return true;
            }
            ++ArgTokenIdx;
        }
        return false;
    }

    public int getUnexpArgument(int Arg) {
        int Result = 0;
        while (Arg != 0) {
            assert (Result < this.NumUnexpArgTokens) : "Invalid arg #";
            if (this.UnexpArgTokens[Result].is('\u0001')) {
                --Arg;
            }
            ++Result;
        }
        assert (Result < this.NumUnexpArgTokens) : "Invalid arg #";
        return Result;
    }

    public Token[] $UnexpArgTokens() {
        return this.UnexpArgTokens;
    }

    public static int getArgLength(Token[] ArgPtr, int ArgPtrIdx) {
        int NumArgTokens = 0;
        while (ArgPtr[ArgPtrIdx].isNot('\u0001')) {
            ++NumArgTokens;
            ++ArgPtrIdx;
        }
        return NumArgTokens;
    }

    public SmallVectorToken getPreExpArgument(int Arg, MacroInfo MI, Preprocessor PP) {
        SmallVectorToken Result;
        boolean PreExpandingMacroArgs = PP.InMacroArgPreExpansion;
        assert (Arg < MI.getNumArgs()) : "Invalid argument number!";
        if (this.PreExpArgTokens.size() < MI.getNumArgs()) {
            this.PreExpArgTokens.resize(MI.getNumArgs(), (Object)new SmallVectorToken(0, null));
        }
        if (!(Result = (SmallVectorToken)this.PreExpArgTokens.$at(Arg)).empty()) {
            PP.InMacroArgPreExpansion = PreExpandingMacroArgs;
            return Result;
        }
        PP.InMacroArgPreExpansion = true;
        int AT = this.getUnexpArgument(Arg);
        int NumToks = MacroArgs.getArgLength(this.$UnexpArgTokens(), AT) + 1;
        PP.EnterTokenStream(this.$UnexpArgTokens(), AT, NumToks, false, false);
        boolean thresholdReached = false;
        do {
            if (thresholdReached) {
                Result.clear();
            } else if (Result.size() >= MAX_PARAMETERS_SIZE) {
                thresholdReached = true;
            }
            Result.push_back(new Token());
            Token Tok = Result.back();
            PP.Lex(Tok);
        } while (Result.back().isNot('\u0001'));
        if (PP.InCachingLexMode()) {
            PP.ExitCachingLexMode();
        }
        PP.RemoveTopOfLexerStack();
        PP.InMacroArgPreExpansion = PreExpandingMacroArgs;
        return Result;
    }

    public Token getStringifiedArgument(int ArgNo, Preprocessor PP, int ExpansionLocStart, int ExpansionLocEnd) {
        assert (ArgNo < this.NumUnexpArgTokens) : "Invalid argument number!";
        if (this.StringifiedArgs.empty()) {
            this.StringifiedArgs.resize(this.getNumArguments());
            Token[] $array = this.StringifiedArgs.$array();
            for (int i = 0; i < this.getNumArguments(); ++i) {
                $array[i].startToken();
            }
        }
        if (this.StringifiedArgs.$at(ArgNo).isNot('\r')) {
            this.StringifiedArgs.$set(ArgNo, MacroArgs.StringifyArgument(this.$UnexpArgTokens(), this.getUnexpArgument(ArgNo), PP, false, ExpansionLocStart, ExpansionLocEnd));
        }
        return this.StringifiedArgs.$at(ArgNo);
    }

    public int getNumArguments() {
        return this.NumUnexpArgTokens;
    }

    public boolean isVarargsElidedUse() {
        return this.VarargsElided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token StringifyArgument(Token[] ArgToks, int ArgToksIdx, Preprocessor PP, boolean Charify, int ExpansionLocStart, int ExpansionLocEnd) {
        Token _Tok = new Token();
        _Tok.startToken();
        _Tok.setKind(Charify ? (char)'\b' : '\r');
        int ArgTokStart = ArgToksIdx;
        SmallString Result = PP.$getStringifyArgument_Result();
        try {
            Result.$addassign(NativePointer.$((char)'\"'));
            boolean isFirst = true;
            while (ArgToks[ArgToksIdx].isNot('\u0001')) {
                Token Tok = (Token)Native.$Deref((Object)ArgToks[ArgToksIdx]);
                if (!isFirst && (Tok.hasLeadingSpace() || Tok.isAtStartOfLine())) {
                    Result.$addassign(NativePointer.$((char)' '));
                }
                isFirst = false;
                if (tok.isStringLiteral((char)Tok.getKind()) || Tok.is('\b') || Tok.is('\t') || Tok.is('\n') || Tok.is('\u000b') || Tok.is('\f')) {
                    bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
                    std.string TokStr = PP.getSpelling(Tok, (bool.ptr)Native.$AddrOf((Object)Invalid));
                    if (!Invalid.$star()) {
                        std.string Str = Lexer.Stringify(TokStr);
                        Result.append(Str);
                    }
                } else if (Tok.is('\u0003')) {
                    PP.CodeCompleteNaturalLanguage();
                } else {
                    int CurStrLen = Result.size();
                    Result.resize(CurStrLen + Tok.getLength());
                    int ActualTokLen = PP.copySpelling(Tok, Result, Native.$AddrOf((int)CurStrLen));
                    if (ActualTokLen != -1 && ActualTokLen != Tok.getLength()) {
                        Result.resize(CurStrLen + ActualTokLen);
                    }
                }
                ++ArgToksIdx;
            }
            if (Result.back() == 92) {
                int FirstNonSlash = Result.size() - 2;
                while (Result.$at(FirstNonSlash) == 92) {
                    --FirstNonSlash;
                }
                if ((Result.size() - 1 - FirstNonSlash & 1) != 0) {
                    PP.Diag(ArgToks[ArgToksIdx - 1], 929).$destroy();
                    Result.pop_back();
                }
            }
            Result.$addassign(NativePointer.$((char)'\"'));
            if (Charify) {
                Result.$set(0, NativePointer.$((char)'\''));
                Result.$set(Result.size() - 1, NativePointer.$((char)'\''));
                boolean isBad = false;
                if (Result.size() == 3) {
                    isBad = Result.$at(1) == NativePointer.$((char)'\'');
                } else {
                    boolean bl = isBad = Result.size() != 4 || Result.$at(1) != 92;
                }
                if (isBad) {
                    PP.Diag(ArgToks[ArgTokStart], 737).$destroy();
                    Result.$assign("' '");
                }
            }
            PP.CreateString(Result.$array(), 0, Result.size(), _Tok, ExpansionLocStart, ExpansionLocEnd);
            Token token = _Tok;
            return token;
        }
        finally {
            PP.$releaseStringifyArgument_Result(Result);
        }
    }

    public MacroArgs deallocate() {
        MacroArgs Next = this.ArgCache;
        this.$destroy();
        std.free((Object)this);
        return Next;
    }

    public String toString() {
        return "MacroArgs{NumUnexpArgTokens=" + this.NumUnexpArgTokens + ", UnexpArgTokens=" + Arrays.toString(this.UnexpArgTokens) + ", VarargsElided=" + this.VarargsElided + ", PreExpArgTokens=" + this.PreExpArgTokens + ", StringifiedArgs=" + this.StringifiedArgs + ", ArgCache=" + this.ArgCache + '}';
    }

    private static void trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
    }

    public static void clearStatistics() {
        instances = 0L;
    }

    public static long PrintStats(raw_ostream out) {
        out.$out(String.format("%22s created:\t", MacroArgs.class.getSimpleName())).$out(NativeTrace.formatNumber((long)instances)).$out(".\n");
        NativeTrace.dumpStatisticValue((String)MacroArgs.class.getSimpleName(), (long)instances);
        return instances;
    }
}

