/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.desktop.os;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import fleet.dock.desktop.DesktopDockResources;
import fleet.preferences.FleetPropertiesKt;
import fleet.util.FilesKt;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.util.os.Os;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\rH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\f\u0010\u0019\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lfleet/dock/desktop/os/ProtocolHandlers;", "", "()V", "StartupWMClass", "", "log", "Lfleet/util/logging/KLogger;", "containsCharsToBeQuoted", "", "str", "fixWrongStartupWMClassValue", "", "file", "Ljava/nio/file/Path;", "generateDefaultDesktopFileContent", "iconPath", "getExecutablePath", "install", "userHome", "desktopDockResources", "Lfleet/dock/desktop/DesktopDockResources;", "installLinuxProtocolHandler", "installWindowsProtocolHandler", "quoteArgument", "arg", "escapeDesktopStringType", "fleet.dock.desktop"})
@SourceDebugExtension(value={"SMAP\nProtocolHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolHandlers.kt\nfleet/dock/desktop/os/ProtocolHandlers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n+ 5 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,211:1\n766#2:212\n857#2,2:213\n1855#2,2:216\n766#2:218\n857#2,2:219\n1855#2:221\n1856#2:224\n1963#2,14:229\n1#3:215\n13#4,2:222\n13#4,2:225\n13#4,2:227\n13#4,2:243\n41#4,2:245\n13#4,2:247\n17#4,2:249\n22#5:251\n*S KotlinDebug\n*F\n+ 1 ProtocolHandlers.kt\nfleet/dock/desktop/os/ProtocolHandlers\n*L\n99#1:212\n99#1:213,2\n106#1:216,2\n111#1:218\n111#1:219,2\n116#1:221\n116#1:224\n149#1:229,14\n119#1:222,2\n131#1:225,2\n140#1:227,2\n153#1:243,2\n157#1:245,2\n168#1:247,2\n37#1:249,2\n18#1:251\n*E\n"})
public final class ProtocolHandlers {
    @NotNull
    public static final ProtocolHandlers INSTANCE = new ProtocolHandlers();
    @NotNull
    private static final KLogger log;
    @NotNull
    public static final String StartupWMClass = "jetbrains-fleet";

    private ProtocolHandlers() {
    }

    public final void install(@NotNull Path userHome, @NotNull DesktopDockResources desktopDockResources) {
        Intrinsics.checkNotNullParameter((Object)userHome, (String)"userHome");
        Intrinsics.checkNotNullParameter((Object)desktopDockResources, (String)"desktopDockResources");
        Os.Type type = Os.INSTANCE.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.installWindowsProtocolHandler();
                break;
            }
            case 2: {
                this.installLinuxProtocolHandler(userHome, desktopDockResources);
            }
        }
    }

    private final void installWindowsProtocolHandler() {
        WinReg.HKEY hKEY = WinReg.HKEY_CURRENT_USER;
        Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"HKEY_CURRENT_USER");
        ProtocolHandlers.installWindowsProtocolHandler$writeRegValue(hKEY, "Software\\Classes\\fleet", "", "\"URL: fleet Protocol\"");
        WinReg.HKEY hKEY2 = WinReg.HKEY_CURRENT_USER;
        Intrinsics.checkNotNullExpressionValue((Object)hKEY2, (String)"HKEY_CURRENT_USER");
        ProtocolHandlers.installWindowsProtocolHandler$writeRegValue(hKEY2, "Software\\Classes\\fleet", "URL Protocol", "\"\"");
        String string = this.getExecutablePath();
        if (string == null) {
            throw new IllegalStateException("Failed to locate executable. Are you trying to run Fleet from sources?".toString());
        }
        String path = string;
        String executable = this.quoteArgument(path) + " %1";
        WinReg.HKEY hKEY3 = WinReg.HKEY_CURRENT_USER;
        Intrinsics.checkNotNullExpressionValue((Object)hKEY3, (String)"HKEY_CURRENT_USER");
        ProtocolHandlers.installWindowsProtocolHandler$writeRegValue(hKEY3, "Software\\Classes\\fleet\\shell\\open\\command", "", executable);
    }

    private final String quoteArgument(String arg) {
        StringBuilder stringBuilder;
        if (((CharSequence)arg).length() == 0) {
            return "\"\"";
        }
        if (!this.containsCharsToBeQuoted(arg)) {
            return arg;
        }
        StringBuilder $this$quoteArgument_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$quoteArgument_u24lambda_u241.append('\"');
        int length = arg.length();
        for (int i = 0; i < length; ++i) {
            int backslashes = 0;
            while (i < length && arg.charAt(i) == '\\') {
                ++backslashes;
                ++i;
            }
            if (i == length) {
                $this$quoteArgument_u24lambda_u241.append(StringsKt.repeat((CharSequence)"\\", (int)(backslashes * 2)));
                continue;
            }
            if (arg.charAt(i) == '\"') {
                $this$quoteArgument_u24lambda_u241.append(StringsKt.repeat((CharSequence)"\\", (int)(backslashes * 2 + 1)));
                $this$quoteArgument_u24lambda_u241.append('\"');
                continue;
            }
            $this$quoteArgument_u24lambda_u241.append(StringsKt.repeat((CharSequence)"\\", (int)backslashes));
            $this$quoteArgument_u24lambda_u241.append(arg.charAt(i));
        }
        $this$quoteArgument_u24lambda_u241.append('\"');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean containsCharsToBeQuoted(String str) {
        return StringsKt.contains$default((CharSequence)str, (char)' ', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\"', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\n', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\t', (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void installLinuxProtocolHandler(Path userHome, DesktopDockResources desktopDockResources) {
        block37: {
            try {
                Path path;
                KLogger kLogger;
                Object object;
                KLogger $this$filterTo$iv$iv;
                Object $this$installLinuxProtocolHandler_u24lambda_u249;
                Object it;
                Object object2;
                Iterable destination$iv$iv;
                Object $this$installLinuxProtocolHandler_u24lambda_u244;
                Path desktopFilesDirectory = userHome.resolve(".local/share/applications").toAbsolutePath().normalize();
                Object object3 = this;
                try {
                    $this$installLinuxProtocolHandler_u24lambda_u244 = object3;
                    boolean bl = false;
                    Closeable closeable = Files.newDirectoryStream(desktopFilesDirectory);
                    Throwable throwable = null;
                    try {
                        void $this$filterTo$iv$iv2;
                        Iterable stream = (DirectoryStream)closeable;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)stream);
                        Iterable $this$filter$iv = stream;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            Path f = (Path)element$iv$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)f);
                            if (!(StringsKt.startsWith$default((String)PathsKt.getName((Path)f), (String)StartupWMClass, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)PathsKt.getName((Path)f), (String)".desktop", (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        stream = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    }
                    catch (Throwable stream) {
                        throwable = stream;
                        throw stream;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    $this$installLinuxProtocolHandler_u24lambda_u244 = Result.constructor-impl((Object)stream);
                }
                catch (Throwable bl) {
                    $this$installLinuxProtocolHandler_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object3 = $this$installLinuxProtocolHandler_u24lambda_u244;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                if (throwable == null) {
                    object2 = object3;
                } else {
                    Throwable it2 = throwable;
                    boolean bl = false;
                    object2 = SetsKt.emptySet();
                }
                Set fleetDesktopFiles = (Set)object2;
                Iterable $this$forEach$iv = fleetDesktopFiles;
                boolean $i$f$forEach22 = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Path)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it);
                    INSTANCE.fixWrongStartupWMClassValue((Path)it);
                }
                Object $i$f$forEach22 = this;
                try {
                    $this$installLinuxProtocolHandler_u24lambda_u249 = $i$f$forEach22;
                    boolean bl = false;
                    it = Files.newDirectoryStream(desktopFilesDirectory);
                    Throwable bl4 = null;
                    try {
                        Iterable stream = (DirectoryStream)it;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)stream);
                        Iterable $this$filter$iv = stream;
                        boolean $i$f$filter = false;
                        destination$iv$iv = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Path f = (Path)element$iv$iv;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull((Object)f);
                            if (!(StringsKt.startsWith$default((String)PathsKt.getName((Path)f), (String)"Fleet", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)PathsKt.getName((Path)f), (String)".desktop", (boolean)false, (int)2, null))) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        stream = (List)destination$iv$iv2;
                    }
                    catch (Throwable stream) {
                        bl4 = stream;
                        throw stream;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)it, (Throwable)bl4);
                    }
                    $this$installLinuxProtocolHandler_u24lambda_u249 = Result.constructor-impl((Object)stream);
                }
                catch (Throwable bl) {
                    $this$installLinuxProtocolHandler_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                $i$f$forEach22 = $this$installLinuxProtocolHandler_u24lambda_u249;
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)$i$f$forEach22);
                if (throwable2 == null) {
                    object = $i$f$forEach22;
                } else {
                    Throwable it3 = throwable2;
                    boolean bl = false;
                    object = SetsKt.emptySet();
                }
                Collection legacyFleetDesktopFiles = (Collection)object;
                Iterable $this$forEach$iv2 = legacyFleetDesktopFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Path it4 = (Path)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it4);
                    boolean deleted = Files.deleteIfExists(it4);
                    if (!deleted) continue;
                    KLogger this_$iv = log;
                    boolean $i$f$info = false;
                    if (!this_$iv.isInfoEnabled()) continue;
                    $this$filterTo$iv$iv = this_$iv;
                    boolean bl7 = false;
                    $this$filterTo$iv$iv.info((Object)("Deleted legacy `.desktop` file '" + it4 + "'"));
                }
                Path fleetGeneratedDesktopFile = desktopFilesDirectory.resolve("jetbrains-fleet.desktop");
                if (fleetDesktopFiles.isEmpty() || Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((Iterable)fleetDesktopFiles), (Object)fleetGeneratedDesktopFile)) {
                    KLogger this_$iv = log;
                    boolean $i$f$info = false;
                    if (this_$iv.isInfoEnabled()) {
                        kLogger = this_$iv;
                        boolean bl = false;
                        kLogger.info((Object)("Creating/updating Fleet-generated `.desktop` file '" + fleetGeneratedDesktopFile + "'"));
                    }
                    Intrinsics.checkNotNull((Object)fleetGeneratedDesktopFile);
                    PathsKt.writeText$default((Path)fleetGeneratedDesktopFile, (CharSequence)this.generateDefaultDesktopFileContent(desktopDockResources.getProdAppIconFile$fleet_dock_desktop()), null, (OpenOption[])new OpenOption[0], (int)2, null);
                    FilesKt.setExecutable((Path)fleetGeneratedDesktopFile);
                    FilesKt.setReadOnly((Path)fleetGeneratedDesktopFile, (boolean)false);
                    path = fleetGeneratedDesktopFile;
                } else {
                    Object v5;
                    Intrinsics.checkNotNull((Object)fleetGeneratedDesktopFile);
                    boolean deleted = Files.deleteIfExists(fleetGeneratedDesktopFile);
                    if (deleted) {
                        KLogger this_$iv = log;
                        boolean $i$f$info = false;
                        if (this_$iv.isInfoEnabled()) {
                            kLogger = this_$iv;
                            boolean bl = false;
                            kLogger.info((Object)("Deleted Fleet-generated `.desktop` file '" + fleetGeneratedDesktopFile + "' as `.desktop` files generated by Toolbox exist"));
                        }
                    }
                    Iterable $this$maxByOrNull$iv = SetsKt.minus((Set)fleetDesktopFiles, (Iterable)SetsKt.setOf((Object)fleetGeneratedDesktopFile));
                    boolean $i$f$maxByOrNull = false;
                    Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v5 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v5 = maxElem$iv;
                        } else {
                            Path it5 = (Path)maxElem$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it5);
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            FileTime fileTime = Files.getLastModifiedTime(it5, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                            Comparable maxValue$iv = fileTime;
                            do {
                                Object e$iv = iterator$iv.next();
                                Path it6 = (Path)e$iv;
                                $i$a$-maxByOrNull-ProtocolHandlers$installLinuxProtocolHandler$protocolDesktopFile$3 = false;
                                Intrinsics.checkNotNull((Object)it6);
                                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                                FileTime fileTime2 = Files.getLastModifiedTime(it6, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                                Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                                Comparable v$iv = fileTime2;
                                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v5 = maxElem$iv;
                        }
                    }
                    Intrinsics.checkNotNull(v5);
                    path = v5;
                }
                Path protocolDesktopFile = path;
                KLogger this_$iv = log;
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    kLogger = this_$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)protocolDesktopFile);
                    kLogger.info((Object)("Adding fleet:// protocol handler to mimeapps.list, linking it to " + PathsKt.getName((Path)protocolDesktopFile)));
                }
                Runtime runtime = Runtime.getRuntime();
                Intrinsics.checkNotNull((Object)protocolDesktopFile);
                runtime.exec("xdg-mime default " + PathsKt.getName((Path)protocolDesktopFile) + " x-scheme-handler/fleet");
            }
            catch (Throwable t) {
                KLogger this_$iv = log;
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break block37;
                Throwable throwable = t;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Failed to set fleet:// protocol handler";
                kLogger.error(throwable, (Object)string);
            }
        }
    }

    private final void fixWrongStartupWMClassValue(Path file) {
        String fixedContent;
        String content = PathsKt.readText$default((Path)file, null, (int)1, null);
        if (!Intrinsics.areEqual((Object)content, (Object)(fixedContent = StringsKt.replace$default((String)content, (String)"StartupWMClass=jetbrains-ide", (String)"StartupWMClass=jetbrains-fleet", (boolean)false, (int)4, null)))) {
            PathsKt.writeText$default((Path)file, (CharSequence)fixedContent, null, (OpenOption[])new OpenOption[0], (int)2, null);
            KLogger this_$iv = log;
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.info((Object)("Fixed `StartupWMClass` of '" + file + "'"));
            }
        }
    }

    private final String generateDefaultDesktopFileContent(Path iconPath) {
        String string = this.getExecutablePath();
        if (string == null) {
            throw new IllegalStateException("Failed to locate executable. Are you trying to run Fleet from sources?".toString());
        }
        String defaultExecutablePath = string;
        return StringsKt.trimIndent((String)("\n          # Generated by Fleet post-installation\n          [Desktop Entry]\n          Exec=\"" + defaultExecutablePath + "\" %u\n          Icon=" + this.escapeDesktopStringType(((Object)iconPath).toString()) + "\n          Version=1.0\n          Type=Application\n          Categories=Development\n          Name=Fleet\n          StartupWMClass=jetbrains-fleet\n          Terminal=false\n          MimeType=text/plain;inode/directory;x-scheme-handler/fleet;\n        "));
    }

    private final String escapeDesktopStringType(String $this$escapeDesktopStringType) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeDesktopStringType, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null), (String)" ", (String)"\\s", (boolean)false, (int)4, null);
    }

    /*
     * Unable to fully structure code
     */
    private final String getExecutablePath() {
        block3: {
            block2: {
                if (!FleetPropertiesKt.isFleetDistributionMode()) break block2;
                executablePath = Path.of(ProcessHandle.current().info().command().get(), new String[0]).toRealPath(new LinkOption[0]);
                v0 = executablePath.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getFileName(...)");
                if (Intrinsics.areEqual((Object)v0.toString(), (Object)"java")) ** GOTO lbl-1000
                v1 = executablePath.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getFileName(...)");
                if (Intrinsics.areEqual((Object)v1.toString(), (Object)"java.exe")) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                isCrossPlatformDistribution = v2;
                it = var3_3 = executablePath;
                $i$a$-takeIf-ProtocolHandlers$getExecutablePath$1 = false;
                v3 = isCrossPlatformDistribution == false != false ? var3_3 : null;
                v4 = v3 != null ? v3.toString() : null;
                break block3;
            }
            v4 = null;
        }
        return v4;
    }

    private static final void installWindowsProtocolHandler$writeRegValue(WinReg.HKEY key, String subKey, String valueName, String value) {
        block2: {
            try {
                Advapi32Util.registryCreateKey((WinReg.HKEY)key, (String)subKey, (int)256);
                Advapi32Util.registrySetStringValue((WinReg.HKEY)key, (String)subKey, (String)valueName, (String)value, (int)256);
            }
            catch (Win32Exception t) {
                KLogger this_$iv = log;
                boolean $i$f$warn = false;
                if (!this_$iv.isWarnEnabled()) break block2;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)("Unable to write registry key: \\" + subKey + " valueName '" + valueName + "': " + t.getMessage()));
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ProtocolHandlers.class));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.Type.values().length];
            try {
                nArray[Os.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

