/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter.indenter;

import boringFormatter.FormatterUtilsKt;
import boringFormatter.indenter.ActiveIndentRegion;
import boringFormatter.indenter.IndentingLogger;
import boringFormatter.indenter.IndentingRule;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0016J0\u0010 \u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010!\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J \u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J \u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J \u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J \u0010(\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J(\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0016J\u0018\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000f\u00101\u001a\u0004\u0018\u00010\f*\u00020\fH\u0082\u0010J(\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J(\u00105\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\tH\u0016\u00a8\u00067"}, d2={"LboringFormatter/indenter/ConsoleIndentingLogger;", "LboringFormatter/indenter/IndentingLogger;", "<init>", "()V", "start", "", "finish", "println", "message", "", "baseInfo", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "lineFrom", "", "lineTo", "openRegion", "currIndent", "region", "LboringFormatter/indenter/ActiveIndentRegion;", "activeRegionsCount", "", "closeRegion", "currLine", "collapseRegion", "rule", "LboringFormatter/indenter/IndentingRule;", "lastRegion", "skipRuleBeforeRange", "activeRulesCount", "currentNode", "newCurrentNode", "skipRule", "changeNode", "relativeIndent", "multilineIndent", "currentline", "fillUndone", "indent", "lastIndentedLine", "blockIndent", "adjustIndent", "activeRule", "currentIndent", "currentLine", "delta", "getPosition", "after", "", "getFirstCsharpToken", "getPrefix", "currCalculatedIndent", "actualIndent", "log", "text", "fleet.boringFormatter"})
class ConsoleIndentingLogger
implements IndentingLogger {
    @Override
    public void start() {
        this.println("==== Start indent ====");
    }

    @Override
    public void finish() {
        this.println("==== Finish indent ====");
    }

    public void println(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        System.out.println((Object)message);
    }

    @Override
    public void baseInfo(@NotNull SyntaxNode node, long lineFrom, long lineTo) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.println("base node: " + node.getType() + " '" + CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)node.getText())) + "...' Lines [" + lineFrom + ":" + lineTo + "]");
    }

    @Override
    public void openRegion(long currIndent, @NotNull ActiveIndentRegion region, @NotNull SyntaxNode node, int activeRegionsCount) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.println(this.getPrefix(currIndent, region.getOriginIndent().getIndent(), region.getStartLineNumber(), activeRegionsCount) + "OPEN " + region + " " + this.getPosition(!region.getRule().getStartsInclusive(), node));
    }

    @Override
    public void closeRegion(long currIndent, long currLine, @NotNull ActiveIndentRegion region, @NotNull SyntaxNode node, int activeRegionsCount) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.println(this.getPrefix(currIndent, region.getOriginIndent().getIndent(), currLine, activeRegionsCount) + "CLOSE " + region + " " + this.getPosition(region.getRule().getEndsInclusive(), node) + " " + (region.isGreedy() ? "[GREEDY]" : ""));
    }

    @Override
    public void collapseRegion(long currIndent, long currLine, @NotNull IndentingRule rule, @NotNull ActiveIndentRegion lastRegion, @NotNull SyntaxNode node, int activeRegionsCount) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)lastRegion, (String)"lastRegion");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.println(this.getPrefix(currIndent, currIndent, currLine, activeRegionsCount) + "COLLAPSED BY '" + rule.getName() + "' to `" + lastRegion.getRule().getName() + ":" + lastRegion.getStartLineNumber() + "` at " + node.getType());
    }

    @Override
    public void skipRuleBeforeRange(long currIndent, long currLine, int activeRulesCount, @NotNull IndentingRule rule, @NotNull SyntaxNode currentNode, @NotNull SyntaxNode newCurrentNode) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)currentNode, (String)"currentNode");
        Intrinsics.checkNotNullParameter((Object)newCurrentNode, (String)"newCurrentNode");
        this.println(this.getPrefix(currIndent, currIndent, currLine, activeRulesCount) + "SKIPBEFORERANGE '" + rule.getName() + ":" + currLine + "' jump from " + currentNode.getType() + ":" + currentNode.getStartOffset() + " to " + newCurrentNode.getType() + ":" + newCurrentNode.getStartOffset());
    }

    @Override
    public void skipRule(long currIndent, long currLine, int activeRulesCount, @NotNull SyntaxNode node, @NotNull IndentingRule rule) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this.println(this.getPrefix(currIndent, currIndent, currLine, activeRulesCount) + "SKIP '" + rule.getName() + ":" + currLine + "' at " + node.getType());
    }

    @Override
    public void changeNode(@NotNull SyntaxNode currentNode, long currIndent, long currLine, int activeRulesCount) {
        Intrinsics.checkNotNullParameter((Object)currentNode, (String)"currentNode");
        this.println(this.getPrefix(currIndent, currIndent, currLine, activeRulesCount) + currentNode.getType());
    }

    @Override
    public void relativeIndent(long currIndent, long currLine, int activeRulesCount) {
        this.println(this.getPrefix(currIndent, currIndent, currLine, activeRulesCount) + "[Relative indent]");
    }

    @Override
    public void multilineIndent(long currentline, long currIndent, int activeRulesCount) {
        this.println(this.getPrefix(currIndent, currIndent, currentline, activeRulesCount) + "[Multiline indent]");
    }

    @Override
    public void fillUndone(long indent, long lastIndentedLine, int activeRulesCount) {
        this.println(this.getPrefix(indent, indent, lastIndentedLine, activeRulesCount) + "[Undone]");
    }

    @Override
    public void blockIndent(@NotNull IndentingRule rule, long currLine, int currIndent) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this.println(this.getPrefix(currIndent, currIndent, currLine, 1) + " | '" + rule.getName() + "' " + rule.getIndentType());
    }

    @Override
    public void adjustIndent(@NotNull ActiveIndentRegion activeRule, long currentIndent, long currentLine, long delta) {
        Intrinsics.checkNotNullParameter((Object)activeRule, (String)"activeRule");
        this.println(this.getPrefix(currentIndent, currentIndent, currentLine, 0) + "Correct +" + delta + " at " + activeRule.getRule().getName() + " -> " + activeRule.getAdjustedIndent().getDelta());
    }

    private final String getPosition(boolean after, SyntaxNode node) {
        String string;
        if (after) {
            SyntaxNode syntaxNode = this.getFirstCsharpToken(node);
            string = "after " + (syntaxNode != null ? syntaxNode.getType() : null);
        } else {
            SyntaxNode syntaxNode = this.getFirstCsharpToken(node);
            string = "before " + (syntaxNode != null ? syntaxNode.getType() : null);
        }
        return string;
    }

    private final SyntaxNode getFirstCsharpToken(SyntaxNode $this$getFirstCsharpToken) {
        SyntaxNode syntaxNode;
        block2: {
            ConsoleIndentingLogger consoleIndentingLogger = this;
            while (true) {
                if (FormatterUtilsKt.isToken($this$getFirstCsharpToken)) {
                    syntaxNode = $this$getFirstCsharpToken;
                    break block2;
                }
                SyntaxNode syntaxNode2 = $this$getFirstCsharpToken.firstChild();
                if (syntaxNode2 == null) break;
                $this$getFirstCsharpToken = syntaxNode2;
            }
            syntaxNode = null;
        }
        return syntaxNode;
    }

    private final String getPrefix(long currCalculatedIndent, long actualIndent, long currLine, int activeRulesCount) {
        String prefix = actualIndent == currCalculatedIndent ? "[" + currLine + ": " + currCalculatedIndent + "]" : "[" + currLine + ": " + currCalculatedIndent + "->" + actualIndent + "]";
        int align = 8 - prefix.length();
        int indent = activeRulesCount * 4 + (align > 0 ? align : 0);
        return prefix + " " + StringsKt.repeat((CharSequence)" ", (int)indent);
    }

    @Override
    public void log(long currIndent, long currLine, @NotNull IndentingRule rule, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.println("Line " + currLine + "; Indent before rule ends " + currIndent + "; Rule " + rule.getName() + " " + text);
    }
}

