/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter;

import boringFormatter.TextContent;
import boringFormatter.indenter.IndentingSessionUtilsKt;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010J\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0010J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"LboringFormatter/FormatterUtils;", "", "<init>", "()V", "originIndents", "", "", "text", "LboringFormatter/TextContent;", "lineRange", "Lkotlin/ranges/LongRange;", "firstApplyingLineOfRegion", "", "startBeforeNode", "", "openNode", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "lastApplyingLineOfRegion", "endsInclusive", "exitNode", "originIndent", "", "fleet.boringFormatter"})
public final class FormatterUtils {
    @NotNull
    public static final FormatterUtils INSTANCE = new FormatterUtils();

    private FormatterUtils() {
    }

    @NotNull
    public final List<String> originIndents(@NotNull TextContent text, @NotNull LongRange lineRange) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lineRange, (String)"lineRange");
        List result = new ArrayList();
        long line = lineRange.getFirst();
        long l = lineRange.getLast();
        if (line <= l) {
            while (true) {
                CharSequence lineContent = TextContent.line$default(text, line, false, 2, null).getContent();
                result.add(((Object)this.originIndent(lineContent)).toString());
                if (line == l) break;
                ++line;
            }
        }
        return result;
    }

    public final long firstApplyingLineOfRegion(boolean startBeforeNode, @NotNull TextContent text, @NotNull SyntaxNode openNode) {
        long l;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)openNode, (String)"openNode");
        if (startBeforeNode) {
            long lineNumber = text.lineNumber(openNode.getStartOffset());
            l = IndentingSessionUtilsKt.isFirstNonWsNodeOnLine(openNode) ? lineNumber : lineNumber + 1L;
        } else {
            l = text.lineNumber(openNode.getStartOffset()) + 1L;
        }
        return l;
    }

    public final long lastApplyingLineOfRegion(boolean endsInclusive, @NotNull TextContent text, @NotNull SyntaxNode openNode, @Nullable SyntaxNode exitNode) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)openNode, (String)"openNode");
        return exitNode == null ? text.lineNumber(IndentingSessionUtilsKt.root(openNode).getEndOffset()) : this.lastApplyingLineOfRegion(endsInclusive, text, exitNode);
    }

    public final long lastApplyingLineOfRegion(boolean endsInclusive, @NotNull TextContent text, @NotNull SyntaxNode exitNode) {
        long l;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)exitNode, (String)"exitNode");
        if (!endsInclusive) {
            long lineNumber = text.lineNumber(exitNode.getStartOffset());
            l = IndentingSessionUtilsKt.isFirstNonWsNodeOnLine(exitNode) ? lineNumber - 1L : lineNumber;
        } else {
            l = text.lineNumber(exitNode.getEndOffset());
        }
        return l;
    }

    private final CharSequence originIndent(CharSequence $this$originIndent) {
        int i = 0;
        for (int j = 0; j < $this$originIndent.length(); ++j) {
            char c = $this$originIndent.charAt(j);
            if (!CharsKt.isWhitespace((char)c)) {
                return $this$originIndent.subSequence(0, i);
            }
            ++i;
        }
        return $this$originIndent;
    }
}

