/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.view;

import androidx.compose.foundation.FocusableKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.LinkAnnotation;
import fleet.ai.frontend.api.internal.AiChatSource;
import fleet.ai.frontend.api.internal.AiReports;
import fleet.ai.frontend.api.internal.ChatMessageChunk;
import fleet.ai.frontend.markdown.InlineLinkInfo;
import fleet.ai.frontend.markdown.SimpleMarkdownKt;
import fleet.common.FusEntityKt;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.components.ThemedAnnotatedStringBuilder;
import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.text.FontFeatureTag;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.compose.theme.text.TextSpec;
import fleet.frontend.KernelExtKt;
import fleet.kernel.plugins.PluginScope;
import fleet.util.UID;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import noria.NoriaContext;
import noria.impl.Runtime;
import noria.model.Theme;
import noria.model.ThemeKey;
import noria.ui.core.BoundaryKt;
import noria.ui.events.HandlerScope;
import org.intellij.markdown.ast.ASTNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\nH\u0003\u001a$\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\"\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"renderTextChunk", "", "Lnoria/NoriaContext;", "chunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text;", "session", "Lfleet/util/UID;", "chatSource", "Lfleet/ai/frontend/api/internal/AiChatSource;", "renderPlainTextChunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text$Plain;", "renderMarkdownTextChunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text$Markdown;", "DOCUMENTATION_LINK_PREFIX", "", "fleet.plugins.ai.frontend"})
public final class AiChatMessageTextKt {
    @NotNull
    private static final String DOCUMENTATION_LINK_PREFIX = "https://www.jetbrains.com/help/fleet";

    @Composable
    public static final void renderTextChunk(@NotNull NoriaContext $this$renderTextChunk, @NotNull ChatMessageChunk.Text chunk, @NotNull UID session, @NotNull AiChatSource chatSource) {
        Intrinsics.checkNotNullParameter((Object)$this$renderTextChunk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)chatSource), (String)"chatSource");
        Runtime.enterScope((NoriaContext)$this$renderTextChunk, (int)561);
        Object[] objectArray = new Object[]{chunk, session, chatSource};
        BoundaryKt.boundary((NoriaContext)$this$renderTextChunk, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(chunk, session, chatSource){
            final /* synthetic */ ChatMessageChunk.Text $chunk;
            final /* synthetic */ UID $session;
            final /* synthetic */ AiChatSource $chatSource;
            {
                this.$chunk = $chunk;
                this.$session = $session;
                this.$chatSource = $chatSource;
                super(1);
            }

            public final void invoke(NoriaContext $this$boundary) {
                Intrinsics.checkNotNullParameter((Object)$this$boundary, (String)"$this$boundary");
                ChatMessageChunk.Text text2 = this.$chunk;
                if (text2 instanceof ChatMessageChunk.Text.Plain) {
                    Runtime.enterScope((NoriaContext)$this$boundary, (int)559);
                    AiChatMessageTextKt.access$renderPlainTextChunk($this$boundary, (ChatMessageChunk.Text.Plain)this.$chunk);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$boundary);
                } else if (text2 instanceof ChatMessageChunk.Text.Markdown) {
                    Runtime.enterScope((NoriaContext)$this$boundary, (int)560);
                    AiChatMessageTextKt.access$renderMarkdownTextChunk($this$boundary, (ChatMessageChunk.Text.Markdown)this.$chunk, this.$session, this.$chatSource);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$boundary);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderTextChunk);
    }

    @Composable
    private static final void renderPlainTextChunk(NoriaContext $this$renderPlainTextChunk, ChatMessageChunk.Text.Plain chunk) {
        Runtime.enterScope((NoriaContext)$this$renderPlainTextChunk, (int)562);
        TextKt.UiText-1ODQ_eA$default((NoriaContext)$this$renderPlainTextChunk, (String)((Object)StringsKt.trim((CharSequence)chunk.getContent())).toString(), (long)0L, null, null, (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, (Modifier)FocusableKt.focusable$default((Modifier)((Modifier)Modifier.Companion), (boolean)false, null, (int)3, null), (int)494, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderPlainTextChunk);
    }

    @Composable
    private static final void renderMarkdownTextChunk(NoriaContext $this$renderMarkdownTextChunk, ChatMessageChunk.Text.Markdown chunk, UID session, AiChatSource chatSource) {
        String content2 = ((Object)StringsKt.trim((CharSequence)chunk.getContent())).toString();
        Theme theme = (Theme)$this$renderMarkdownTextChunk.getCurrent((CompositionLocal)CompositionLocalsKt.getLocalTheme());
        PluginScope pluginScope = (PluginScope)$this$renderMarkdownTextChunk.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope());
        Runtime.enterScope((NoriaContext)$this$renderMarkdownTextChunk, (int)563);
        AnnotatedString annotatedString = SimpleMarkdownKt.markdownToAnnotatedString($this$renderMarkdownTextChunk, content2, (Function2<? super ThemedAnnotatedStringBuilder, ? super ASTNode, Boolean>)((Function2)new Function2<ThemedAnnotatedStringBuilder, ASTNode, Boolean>(content2, theme){
            final /* synthetic */ String $content;
            final /* synthetic */ Theme $theme;
            {
                this.$content = $content;
                this.$theme = $theme;
                super(2);
            }

            public final Boolean invoke(ThemedAnnotatedStringBuilder $this$markdownToAnnotatedString, ASTNode node) {
                TextSpec textSpec;
                Intrinsics.checkNotNullParameter((Object)$this$markdownToAnnotatedString, (String)"$this$markdownToAnnotatedString");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                InlineLinkInfo linkInfo = SimpleMarkdownKt.inlineLink(node, this.$content);
                if (linkInfo == null) {
                    return false;
                }
                TextSpec defaultSpec = this.$theme.textSpec(TextStyleKeys.INSTANCE.getDefault());
                TextSpec textSpec2 = textSpec = TextSpec.copy-76MNOIk$default((TextSpec)defaultSpec, null, null, (long)0L, (long)0L, (float)0.0f, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)FontFeatureTag.box-impl((String)FontFeatureTag.Companion.getSups-yd_S18Q()), (Object)1)), (int)0, (int)95, null);
                ThemeKey themeKey = null;
                String string = linkInfo.getLinkText();
                ThemedAnnotatedStringBuilder themedAnnotatedStringBuilder = $this$markdownToAnnotatedString;
                boolean bl = false;
                boolean bl2 = StringsKt.startsWith$default((String)linkInfo.getLinkDest(), (String)"https://www.jetbrains.com/help/fleet", (boolean)false, (int)2, null);
                ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)themedAnnotatedStringBuilder, (String)string, themeKey, (TextSpec)(bl2 ? textSpec : null), null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Clickable(linkInfo.getLinkDest())), (int)122, null);
                return true;
            }
        }));
        Runtime.exitScope((NoriaContext)$this$renderMarkdownTextChunk);
        AnnotatedString text2 = annotatedString;
        annotatedString = NoriaParagraphStyle.Companion.getMultiline();
        ThemeKey themeKey = TextStyleKeys.INSTANCE.getDefaultMultiline();
        Modifier modifier = FocusableKt.focusable$default((Modifier)((Modifier)Modifier.Companion), (boolean)false, null, (int)3, null);
        Runtime.enterScope((NoriaContext)$this$renderMarkdownTextChunk, (int)564);
        Object[] objectArray = new Object[]{session, chatSource, pluginScope};
        TextKt.UiText-uuipMMg$default((NoriaContext)$this$renderMarkdownTextChunk, (AnnotatedString)text2, (long)0L, (ThemeKey)themeKey, (NoriaParagraphStyle)annotatedString, null, null, null, null, (Modifier)modifier, null, (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<HandlerScope, LinkAnnotation, Unit>(session, chatSource, pluginScope){
            final /* synthetic */ UID $session;
            final /* synthetic */ AiChatSource $chatSource;
            final /* synthetic */ PluginScope $pluginScope;
            {
                this.$session = $session;
                this.$chatSource = $chatSource;
                this.$pluginScope = $pluginScope;
                super(2);
            }

            public final void invoke(HandlerScope $this$UiText, LinkAnnotation linkAnnotation) {
                Intrinsics.checkNotNullParameter((Object)$this$UiText, (String)"$this$UiText");
                Intrinsics.checkNotNullParameter((Object)linkAnnotation, (String)"linkAnnotation");
                if (linkAnnotation instanceof LinkAnnotation.Clickable) {
                    boolean isDocumentationLink = StringsKt.startsWith$default((String)((LinkAnnotation.Clickable)linkAnnotation).getTag(), (String)"https://www.jetbrains.com/help/fleet", (boolean)false, (int)2, null);
                    FusEntityKt.log(AiReports.INSTANCE.getNavigateToLink$fleet_plugins_ai_frontend(), (Object)this.$session.getId(), (Object)((Object)this.$chatSource), (Object)isDocumentationLink);
                    InlineLinkInfo.Companion.navigate(((LinkAnnotation.Clickable)linkAnnotation).getTag(), this.$pluginScope, $this$UiText.getActionContext());
                }
            }
        })), (int)754, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderMarkdownTextChunk);
    }

    public static final /* synthetic */ void access$renderPlainTextChunk(NoriaContext $receiver, ChatMessageChunk.Text.Plain chunk) {
        AiChatMessageTextKt.renderPlainTextChunk($receiver, chunk);
    }

    public static final /* synthetic */ void access$renderMarkdownTextChunk(NoriaContext $receiver, ChatMessageChunk.Text.Markdown chunk, UID session, AiChatSource chatSource) {
        AiChatMessageTextKt.renderMarkdownTextChunk($receiver, chunk, session, chatSource);
    }
}

