/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.auth.enterprise;

import fleet.ai.frontend.auth.enterprise.TbaToken;
import fleet.ai.frontend.auth.enterprise.TbaTokenKt;
import fleet.ai.frontend.auth.enterprise.TbaTokenResult;
import java.time.Duration;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0011\u0010\u000b\u001a\u00020\u0001*\u00020\fH\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0011\u0010\u000e\u001a\u00020\u0001*\u00020\fH\u0000\u00a2\u0006\u0002\u0010\r\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\fH\u0000\u001a\f\u0010\u0011\u001a\u00020\u0010*\u00020\u0012H\u0000\"\u0016\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0005\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0006\u0010\u0003\"\u0016\u0010\u0007\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\b\u0010\u0003\"\u0016\u0010\t\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\n\u0010\u0003\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"tokenSupplyTimeout", "Lkotlin/time/Duration;", "getTokenSupplyTimeout", "()J", "J", "tokenRefreshRetryOnErrorDelay", "getTokenRefreshRetryOnErrorDelay", "tokenRefreshOnExpirationMinimumDelay", "getTokenRefreshOnExpirationMinimumDelay", "minimumTokenLifetime", "getMinimumTokenLifetime", "nowValidFor", "Lfleet/ai/frontend/auth/enterprise/TbaToken;", "(Lfleet/ai/frontend/auth/enterprise/TbaToken;)J", "nowValidAndFreshEnoughFor", "isNowValidAndFreshEnough", "", "isNowUpToDate", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult;", "BEARER_SCHEMA", "", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "json$delegate", "Lkotlin/Lazy;", "fleet.plugins.ai.frontend"})
public final class TbaTokenKt {
    private static final long tokenSupplyTimeout = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    private static final long tokenRefreshRetryOnErrorDelay = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
    private static final long tokenRefreshOnExpirationMinimumDelay = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
    private static final long minimumTokenLifetime = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    private static final String BEARER_SCHEMA = "Bearer";
    @NotNull
    private static final Lazy json$delegate = LazyKt.lazy((Function0)json.2.INSTANCE);

    public static final long getTokenSupplyTimeout() {
        return tokenSupplyTimeout;
    }

    public static final long getTokenRefreshRetryOnErrorDelay() {
        return tokenRefreshRetryOnErrorDelay;
    }

    public static final long getTokenRefreshOnExpirationMinimumDelay() {
        return tokenRefreshOnExpirationMinimumDelay;
    }

    public static final long getMinimumTokenLifetime() {
        return minimumTokenLifetime;
    }

    public static final long nowValidFor(@NotNull TbaToken $this$nowValidFor) {
        Intrinsics.checkNotNullParameter((Object)$this$nowValidFor, (String)"<this>");
        Duration duration = Duration.between(Instant.now(), $this$nowValidFor.getExpiresAt());
        Intrinsics.checkNotNull((Object)duration);
        Duration duration2 = duration;
        return kotlin.time.Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
    }

    public static final long nowValidAndFreshEnoughFor(@NotNull TbaToken $this$nowValidAndFreshEnoughFor) {
        Intrinsics.checkNotNullParameter((Object)$this$nowValidAndFreshEnoughFor, (String)"<this>");
        return kotlin.time.Duration.minus-LRDsOJo((long)TbaTokenKt.nowValidFor($this$nowValidAndFreshEnoughFor), (long)minimumTokenLifetime);
    }

    public static final boolean isNowValidAndFreshEnough(@NotNull TbaToken $this$isNowValidAndFreshEnough) {
        Intrinsics.checkNotNullParameter((Object)$this$isNowValidAndFreshEnough, (String)"<this>");
        return kotlin.time.Duration.isPositive-impl((long)TbaTokenKt.nowValidAndFreshEnoughFor($this$isNowValidAndFreshEnough));
    }

    public static final boolean isNowUpToDate(@NotNull TbaTokenResult $this$isNowUpToDate) {
        Intrinsics.checkNotNullParameter((Object)$this$isNowUpToDate, (String)"<this>");
        return !($this$isNowUpToDate instanceof TbaTokenResult.Success) || kotlin.time.Duration.isPositive-impl((long)TbaTokenKt.nowValidFor(((TbaTokenResult.Success)$this$isNowUpToDate).getToken()));
    }

    private static final Json getJson() {
        Lazy lazy = json$delegate;
        return (Json)lazy.getValue();
    }

    public static final /* synthetic */ Json access$getJson() {
        return TbaTokenKt.getJson();
    }
}

