/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend;

import andel.lines.Inlay;
import androidx.compose.ui.graphics.Color;
import fleet.ai.common.ext.StringExtKt;
import fleet.ai.frontend.AiAttachment;
import fleet.ai.frontend.markdown.InlineLinkInfo;
import fleet.ai.frontend.vcs.providers.FleetGitDiffProvider;
import fleet.api.FileAddress;
import fleet.frontend.icons.IconKeys;
import fleet.git.protocol.Oid;
import fleet.git.protocol.VcsCommit;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\nH\u0016J\u000e\u0010\u0018\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lfleet/ai/frontend/CommitAiAttachment;", "Lfleet/ai/frontend/AiAttachment;", "worktree", "Lfleet/api/FileAddress;", "commit", "Lfleet/git/protocol/VcsCommit;", "<init>", "(Lfleet/api/FileAddress;Lfleet/git/protocol/VcsCommit;)V", "popupIconKey", "Lnoria/model/ThemeKey;", "", "Lnoria/model/IconKey;", "getPopupIconKey", "()Lnoria/model/ThemeKey;", "popupText", "getPopupText", "()Ljava/lang/String;", "inlayText", "getInlayText", "grayText", "getGrayText", "markdownLink", "getMarkdownLink", "name", "content", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "key", "Lfleet/git/protocol/Oid;", "getKey", "()Lfleet/git/protocol/Oid;", "fleet.plugins.ai.frontend"})
public final class CommitAiAttachment
implements AiAttachment {
    @NotNull
    private final FileAddress worktree;
    @NotNull
    private final VcsCommit commit;
    @NotNull
    private final ThemeKey<String> popupIconKey;
    @NotNull
    private final String popupText;
    @NotNull
    private final String inlayText;
    @NotNull
    private final String grayText;
    @NotNull
    private final String markdownLink;
    @NotNull
    private final Oid key;

    public CommitAiAttachment(@NotNull FileAddress worktree, @NotNull VcsCommit commit) {
        Intrinsics.checkNotNullParameter((Object)worktree, (String)"worktree");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        this.worktree = worktree;
        this.commit = commit;
        this.popupIconKey = IconKeys.Vcs.INSTANCE.getCommit();
        this.popupText = StringExtKt.ellipsise(StringsKt.replace$default((String)this.commit.getMeta().getSubject(), (String)"\n", (String)"; ", (boolean)false, (int)4, null), 40);
        this.inlayText = StringsKt.take((String)this.commit.getShort(), (int)7);
        this.grayText = StringsKt.substringBefore((String)this.commit.getMeta().getAuthor().getEmail(), (String)"@", (String)StringsKt.take((String)this.commit.getShort(), (int)7));
        this.markdownLink = InlineLinkInfo.Companion.encodeToMarkdown(this.worktree, this.commit.getOid());
        this.key = this.commit.getOid();
    }

    @Override
    @NotNull
    public ThemeKey<String> getPopupIconKey() {
        return this.popupIconKey;
    }

    @Override
    @NotNull
    public String getPopupText() {
        return this.popupText;
    }

    @Override
    @NotNull
    public String getInlayText() {
        return this.inlayText;
    }

    @Override
    @NotNull
    public String getGrayText() {
        return this.grayText;
    }

    @Override
    @NotNull
    public String getMarkdownLink() {
        return this.markdownLink;
    }

    @Override
    @NotNull
    public String name() {
        return this.getInlayText();
    }

    @Override
    @Nullable
    public Object content(@NotNull Continuation<? super String> $completion) {
        return FleetGitDiffProvider.INSTANCE.commitDiff(this.commit, $completion);
    }

    @NotNull
    public Oid getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public Inlay.Binding getBinding() {
        return AiAttachment.DefaultImpls.getBinding(this);
    }

    @Override
    @Nullable
    public ThemeKey<String> getInlayIconKey() {
        return AiAttachment.DefaultImpls.getInlayIconKey(this);
    }

    @Override
    @NotNull
    public ThemeKey<Color> getTextColor() {
        return AiAttachment.DefaultImpls.getTextColor(this);
    }

    @Override
    @NotNull
    public ThemeKey<Color> getBgColor() {
        return AiAttachment.DefaultImpls.getBgColor(this);
    }
}

