/*
 * Decompiled with CFR 0.152.
 */
package fleet.workspace.lsp.api;

import fleet.api.HostId;
import fleet.api.ProtocolPath;
import fleet.common.FleetCommonSettingsKeys;
import fleet.common.settings.SettingsEntityKt;
import fleet.common.settings.SettingsKey;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"LSP_SERVER_DOWNLOADS", "", "LSP_SERVER_ARTIFACTS", "lspExtractionTargetDirectory", "Lfleet/api/ProtocolPath;", "archiveFilepath", "cachesPath", "hashMD5", "s", "lspArtifactsExpiry", "Lkotlin/time/Duration;", "hostId", "Lfleet/api/HostId;", "(Lfleet/api/HostId;)J", "fleet.lsp"})
@SourceDebugExtension(value={"SMAP\nLspDownloadLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDownloadLauncher.kt\nfleet/workspace/lsp/api/LspDownloadLauncherKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n12834#2,3:110\n*S KotlinDebug\n*F\n+ 1 LspDownloadLauncher.kt\nfleet/workspace/lsp/api/LspDownloadLauncherKt\n*L\n102#1:110,3\n*E\n"})
public final class LspDownloadLauncherKt {
    @NotNull
    private static final String LSP_SERVER_DOWNLOADS = "lsp-server-downloads";
    @NotNull
    private static final String LSP_SERVER_ARTIFACTS = "lsp-server-artifacts";

    private static final ProtocolPath lspExtractionTargetDirectory(ProtocolPath archiveFilepath, ProtocolPath cachesPath) {
        String filepathHash = LspDownloadLauncherKt.hashMD5(archiveFilepath.joinToString());
        String string = (String)CollectionsKt.lastOrNull((List)archiveFilepath.getComponents());
        if (string == null) {
            throw new IllegalStateException(("Failed to resolve LSP server archive filename for '" + archiveFilepath.joinToString() + "'").toString());
        }
        String archiveName = string;
        String[] stringArray = new String[]{"language_server", archiveName + "_" + filepathHash};
        return cachesPath.child(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final String hashMD5(String s) {
        void $this$fold$iv;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        byte[] byArray3 = byArray2;
        String initial$iv = "";
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var8_8 = element$iv = $this$fold$iv[i];
            String str = accumulator$iv;
            boolean bl = false;
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            accumulator$iv = str + string3;
        }
        return accumulator$iv;
    }

    private static final long lspArtifactsExpiry(HostId hostId) {
        return ((Boolean)SettingsEntityKt.querySettingsKey$default((SettingsKey)FleetCommonSettingsKeys.INSTANCE.getInternalMode(), (HostId)hostId, null, (int)4, null)).booleanValue() ? DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS) : DurationKt.toDuration((int)14, (DurationUnit)DurationUnit.DAYS);
    }

    public static final /* synthetic */ ProtocolPath access$lspExtractionTargetDirectory(ProtocolPath archiveFilepath, ProtocolPath cachesPath) {
        return LspDownloadLauncherKt.lspExtractionTargetDirectory(archiveFilepath, cachesPath);
    }

    public static final /* synthetic */ long access$lspArtifactsExpiry(HostId hostId) {
        return LspDownloadLauncherKt.lspArtifactsExpiry(hostId);
    }
}

