/*
 * Decompiled with CFR 0.152.
 */
package fleet.org.jetbrains.plugins.groovy.lang.parser.parsing.util;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.org.jetbrains.plugins.groovy.lang.parser.GrCodeBlockElementType;
import fleet.org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;

public abstract class ParserUtils {
    public static void getToken(PsiBuilder builder, IElementType elem, @NlsContexts.ParsingError String errorMsg) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
        } else if (errorMsg != null) {
            builder.error(errorMsg);
        }
    }

    public static boolean getToken(PsiBuilder builder, IElementType elem) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType element1, IElementType element2) {
        if (element1 != builder.getTokenType()) {
            return false;
        }
        PsiBuilder.Marker rb = builder.mark();
        builder.advanceLexer();
        boolean res = !builder.eof() && element2 == builder.getTokenType();
        rb.rollbackTo();
        return res;
    }

    public static GrCodeBlockElementType getSwitchAwareBlockElementType(String debugName) {
        return GroovyElementTypes.CLOSABLE_BLOCK_SWITCH_AWARE;
    }

    public static GrCodeBlockElementType getSwitchAwareLambdaBlockElementType(String debugName) {
        return fleet.org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes.BLOCK_LAMBDA_BODY_SWITCH_AWARE;
    }

    public static GrCodeBlockElementType getSwitchAwareClosureBlockElementType(String debugName) {
        return fleet.org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes.CLOSURE_SWITCH_AWARE;
    }
}

