/*
 * Decompiled with CFR 0.152.
 */
package fleet.schema.frontend.editor;

import fleet.api.FileAddress;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.frontend.editor.FontFeaturesSetting;
import fleet.schema.common.IndependentSchemaDataAnalyzer;
import fleet.schema.common.Schema;
import fleet.schema.common.SchemaAnalysisHighlight;
import fleet.schema.common.SchemaAnalysisResult;
import fleet.schema.common.ValueSchema;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lfleet/schema/frontend/editor/FontFeaturesSettingSchemaAnalyzers;", "", "<init>", "()V", "Tag", "MapValueOnOffAlias", "ShorthandOrExplicitListEntry", "fleet.schema.frontend"})
final class FontFeaturesSettingSchemaAnalyzers {
    @NotNull
    public static final FontFeaturesSettingSchemaAnalyzers INSTANCE = new FontFeaturesSettingSchemaAnalyzers();

    private FontFeaturesSettingSchemaAnalyzers() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lfleet/schema/frontend/editor/FontFeaturesSettingSchemaAnalyzers$MapValueOnOffAlias;", "Lfleet/schema/common/IndependentSchemaDataAnalyzer;", "", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "Lfleet/schema/frontend/IndependentSyntaxNodeDataAnalyzer;", "<init>", "()V", "analyze", "Lfleet/schema/common/SchemaAnalysisResult;", "value", "node", "fileAddress", "Lfleet/api/FileAddress;", "(Ljava/lang/String;Lfleet/com/jetbrains/lang/syntax/SyntaxNode;Lfleet/api/FileAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.schema.frontend"})
    public static final class MapValueOnOffAlias
    implements IndependentSchemaDataAnalyzer<String, SyntaxNode> {
        @NotNull
        public static final MapValueOnOffAlias INSTANCE = new MapValueOnOffAlias();

        private MapValueOnOffAlias() {
        }

        @Nullable
        public Object analyze(@NotNull String value, @NotNull SyntaxNode node, @Nullable FileAddress fileAddress, @NotNull Continuation<? super SchemaAnalysisResult> $completion) {
            String string = value;
            return Intrinsics.areEqual((Object)string, (Object)"on") || Intrinsics.areEqual((Object)string, (Object)"off") ? SchemaAnalysisResult.Companion.getNO_HIGHLIGHTS() : SchemaAnalysisResult.Companion.singleHighlight(node.getStartOffset() + 1L, node.getEndOffset() - 1L, (Schema.AnalysisHighlight)new ValueSchema.UnexpectedValue("Font feature value must be \"on\", \"off\", true, false, or an integer"));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lfleet/schema/frontend/editor/FontFeaturesSettingSchemaAnalyzers$ShorthandOrExplicitListEntry;", "Lfleet/schema/common/IndependentSchemaDataAnalyzer;", "", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "Lfleet/schema/frontend/IndependentSyntaxNodeDataAnalyzer;", "<init>", "()V", "analyze", "Lfleet/schema/common/SchemaAnalysisResult;", "value", "node", "fileAddress", "Lfleet/api/FileAddress;", "(Ljava/lang/String;Lfleet/com/jetbrains/lang/syntax/SyntaxNode;Lfleet/api/FileAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.schema.frontend"})
    public static final class ShorthandOrExplicitListEntry
    implements IndependentSchemaDataAnalyzer<String, SyntaxNode> {
        @NotNull
        public static final ShorthandOrExplicitListEntry INSTANCE = new ShorthandOrExplicitListEntry();

        private ShorthandOrExplicitListEntry() {
        }

        @Nullable
        public Object analyze(@NotNull String value, @NotNull SyntaxNode node, @Nullable FileAddress fileAddress, @NotNull Continuation<? super SchemaAnalysisResult> $completion) {
            SchemaAnalysisResult schemaAnalysisResult;
            CharSequence charSequence = value;
            if (new Regex("\\s+").containsMatchIn(charSequence)) {
                Object splitResult = FontFeaturesSetting.List.Entry.Companion.ShorthandOrExplicit.INSTANCE.splitTagAndValue-IoAF18A(value);
                if (Result.isSuccess-impl((Object)splitResult)) {
                    SchemaAnalysisHighlight schemaAnalysisHighlight;
                    SchemaAnalysisHighlight schemaAnalysisHighlight2;
                    SchemaAnalysisHighlight schemaAnalysisHighlight3;
                    Throwable it;
                    Object[] objectArray;
                    int n;
                    Object[] objectArray2;
                    Object object = Result.isFailure-impl((Object)splitResult) ? null : splitResult;
                    Intrinsics.checkNotNull((Object)object);
                    Pair pair = (Pair)object;
                    String tagRepresentation = (String)pair.component1();
                    String valueRepresentation = (String)pair.component2();
                    Throwable tagException = Result.exceptionOrNull-impl((Object)FontFeaturesSetting.Companion.deserializeTag-IoAF18A(tagRepresentation));
                    Throwable valueException = Result.exceptionOrNull-impl((Object)FontFeaturesSetting.List.Entry.Companion.ShorthandOrExplicit.INSTANCE.deserializeValue-IoAF18A(valueRepresentation));
                    Object[] objectArray3 = objectArray2 = new SchemaAnalysisHighlight[2];
                    int n2 = 0;
                    Throwable throwable = tagException;
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        n = n2;
                        objectArray = objectArray3;
                        boolean bl = false;
                        long l = node.getStartOffset() + 1L;
                        long l2 = node.getStartOffset() + (long)tagRepresentation.length() + 1L;
                        String string = it.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        schemaAnalysisHighlight3 = new SchemaAnalysisHighlight(l, l2, (Schema.AnalysisHighlight)new ValueSchema.UnexpectedValue(string));
                        objectArray3 = objectArray;
                        n2 = n;
                        schemaAnalysisHighlight2 = schemaAnalysisHighlight3;
                    } else {
                        schemaAnalysisHighlight2 = null;
                    }
                    objectArray3[n2] = schemaAnalysisHighlight2;
                    Object[] objectArray4 = objectArray2;
                    int n3 = 1;
                    Throwable throwable3 = valueException;
                    if (throwable3 != null) {
                        it = throwable3;
                        n = n3;
                        objectArray = objectArray4;
                        boolean bl = false;
                        long l = node.getEndOffset() - (long)valueRepresentation.length() - 1L;
                        long l3 = node.getEndOffset() - 1L;
                        String string = it.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        schemaAnalysisHighlight3 = new SchemaAnalysisHighlight(l, l3, (Schema.AnalysisHighlight)new ValueSchema.UnexpectedValue(string));
                        objectArray4 = objectArray;
                        n3 = n;
                        schemaAnalysisHighlight = schemaAnalysisHighlight3;
                    } else {
                        schemaAnalysisHighlight = null;
                    }
                    objectArray4[n3] = schemaAnalysisHighlight;
                    List list = CollectionsKt.listOfNotNull((Object[])objectArray2);
                    schemaAnalysisResult = new SchemaAnalysisResult(list);
                } else {
                    long l = node.getStartOffset() + 1L;
                    long l4 = node.getEndOffset() - 1L;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)splitResult);
                    Intrinsics.checkNotNull((Object)throwable);
                    String string = throwable.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    schemaAnalysisResult = SchemaAnalysisResult.Companion.singleHighlight(l, l4, (Schema.AnalysisHighlight)new ValueSchema.UnexpectedValue(string));
                }
            } else {
                return Tag.INSTANCE.analyze(value, node, fileAddress, $completion);
            }
            return schemaAnalysisResult;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lfleet/schema/frontend/editor/FontFeaturesSettingSchemaAnalyzers$Tag;", "Lfleet/schema/common/IndependentSchemaDataAnalyzer;", "", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "Lfleet/schema/frontend/IndependentSyntaxNodeDataAnalyzer;", "<init>", "()V", "analyze", "Lfleet/schema/common/SchemaAnalysisResult;", "value", "node", "fileAddress", "Lfleet/api/FileAddress;", "(Ljava/lang/String;Lfleet/com/jetbrains/lang/syntax/SyntaxNode;Lfleet/api/FileAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.schema.frontend"})
    public static final class Tag
    implements IndependentSchemaDataAnalyzer<String, SyntaxNode> {
        @NotNull
        public static final Tag INSTANCE = new Tag();

        private Tag() {
        }

        @Nullable
        public Object analyze(@NotNull String value, @NotNull SyntaxNode node, @Nullable FileAddress fileAddress, @NotNull Continuation<? super SchemaAnalysisResult> $completion) {
            Throwable throwable;
            block3: {
                block2: {
                    throwable = Result.exceptionOrNull-impl((Object)FontFeaturesSetting.Companion.deserializeTag-IoAF18A(value));
                    if (throwable == null) break block2;
                    Throwable it = throwable;
                    boolean bl = false;
                    long l = node.getStartOffset() + 1L;
                    long l2 = node.getEndOffset() - 1L;
                    String string = it.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    SchemaAnalysisResult schemaAnalysisResult = SchemaAnalysisResult.Companion.singleHighlight(l, l2, (Schema.AnalysisHighlight)new ValueSchema.UnexpectedValue(string));
                    throwable = schemaAnalysisResult;
                    if (schemaAnalysisResult != null) break block3;
                }
                throwable = SchemaAnalysisResult.Companion.getNO_HIGHLIGHTS();
            }
            return throwable;
        }
    }
}

