/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.frontend;

import andel.editor.CaretPosition;
import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.intervals.IntervalsFactory;
import andel.lines.Interline;
import andel.lines.Line;
import andel.lines.LineBasedHeight;
import andel.lines.LinesCache;
import andel.text.TextRange;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import fleet.common.document.DocumentEntity;
import fleet.common.document.EditorEntity;
import fleet.common.document.UnsharedHackKt;
import fleet.diff.common.DiffChange;
import fleet.diff.common.DiffFragmentReader;
import fleet.diff.common.DiffFragmentType;
import fleet.diff.common.DiffType;
import fleet.diff.common.SideBySideDiff;
import fleet.diff.frontend.DiffInterline;
import fleet.diff.frontend.DiffMarkup;
import fleet.diff.frontend.DiffModalEntity;
import fleet.diff.frontend.InlineDiffKt;
import fleet.diff.frontend.RevertGutterWidget;
import fleet.diff.frontend.RevertWidgetKt;
import fleet.frontend.editor.EditorEntityExtKt;
import fleet.frontend.editor.EditorLayoutEntity;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.plugins.PluginScope;
import fleet.kernel.plugins.WorkerKt;
import fleet.util.AtomicExtensionsKt;
import fleet.util.AtomicRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineScope;
import noria.model.EditorSchemeKt;
import noria.model.components.editor.TextAttributesKey;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u001aD\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0012H\u0002\u00a8\u0006\u0019"}, d2={"createDiffInterline", "Lfleet/diff/frontend/DiffModalEntity;", "Lcom/jetbrains/rhizomedb/ChangeScope;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "diff", "Lfleet/diff/common/SideBySideDiff;", "fragmentIndex", "", "leftDocument", "Lfleet/common/document/DocumentEntity;", "rightEditor", "Lfleet/common/document/EditorEntity;", "closeable", "", "revertible", "toTextAttributeKey", "Lnoria/model/components/editor/TextAttributesKey;", "Lfleet/diff/common/DiffType;", "range", "Landel/text/TextRange;", "toInterval", "Landel/intervals/Interval;", "", "type", "fleet.diff.frontend"})
@SourceDebugExtension(value={"SMAP\nDiffInterline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffInterline.kt\nfleet/diff/frontend/DiffInterlineKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1557#2:182\n1628#2,3:183\n1557#2:186\n1628#2,3:187\n*S KotlinDebug\n*F\n+ 1 DiffInterline.kt\nfleet/diff/frontend/DiffInterlineKt\n*L\n70#1:182\n70#1:183,3\n80#1:186\n80#1:187,3\n*E\n"})
public final class DiffInterlineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DiffModalEntity createDiffInterline(@NotNull ChangeScope $this$createDiffInterline, @NotNull PluginScope pluginScope, @NotNull SideBySideDiff diff, int fragmentIndex, @NotNull DocumentEntity leftDocument, @NotNull EditorEntity rightEditor2, boolean closeable, boolean revertible) {
        Intervals intervals;
        Object[] $this$map$iv;
        TextAttributesKey rightColor;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$createDiffInterline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)leftDocument, (String)"leftDocument");
        Intrinsics.checkNotNullParameter((Object)rightEditor2, (String)"rightEditor");
        Pair pair = diff.readers(leftDocument.getText(), rightEditor2.getDocument().getText());
        DiffFragmentReader leftReader = (DiffFragmentReader)pair.component1();
        DiffFragmentReader rightReader = (DiffFragmentReader)pair.component2();
        List diffChanges = diff.getChanges(fragmentIndex);
        TextRange leftPaintRange = leftReader.paintRange(fragmentIndex);
        long leftId = AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId());
        Iterable iterable = diffChanges;
        IntervalsFactory intervalsFactory = Intervals.Companion.keepingCollapsed();
        boolean $i$f$map = false;
        void var18_19 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DiffChange diffChange = (DiffChange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DiffInterlineKt.toInterval(it.getLeftRange(), it.getType()));
        }
        Intervals leftIntervals = intervalsFactory.fromIntervals((Iterable)((List)destination$iv$iv)).addIntervals((Iterable)CollectionsKt.listOf((Object)new Interval((Object)leftId, leftReader.editRange(fragmentIndex), false, false, (Object)EditorSchemeKt.getEditorScheme().getTransparent())));
        boolean isDeletion = diff.fragmentType(fragmentIndex) == DiffFragmentType.DELETED;
        TextRange rightPaintRange = rightReader.paintRange(fragmentIndex);
        long rightId = AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId());
        TextAttributesKey textAttributesKey = rightColor = isDeletion ? EditorSchemeKt.getEditorScheme().getText() : EditorSchemeKt.getEditorScheme().getDiffModifiedWithBorder();
        if (!isDeletion) {
            void $this$mapTo$iv$iv2;
            Object item$iv$iv;
            item$iv$iv = diffChanges;
            intervalsFactory = Intervals.Companion.keepingCollapsed();
            boolean $i$f$map2 = false;
            Object[] bl = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                DiffChange diffChange = (DiffChange)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(DiffInterlineKt.toInterval(it.getRightRange(), it.getType()));
            }
            intervals = intervalsFactory.fromIntervals((Iterable)((List)destination$iv$iv2));
        } else {
            intervals = Intervals.Companion.keepingCollapsed().empty();
        }
        $this$map$iv = new Interval[]{new Interval((Object)rightId, rightReader.editRange(fragmentIndex), false, false, (Object)EditorSchemeKt.getEditorScheme().getTransparent()), new Interval((Object)AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId()), rightPaintRange, false, false, (Object)rightColor)};
        Intervals rightIntervals = intervals.addIntervals((Iterable)CollectionsKt.listOf((Object[])$this$map$iv));
        long interlineId = AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId());
        EditorEntity leftEditor2 = EditorEntityExtKt.createEditor((ChangeScope)$this$createDiffInterline, (DocumentEntity)leftDocument, (List)CollectionsKt.listOf((Object)new CaretPosition(leftReader.startOffset(fragmentIndex))), (Intervals)Intervals.Companion.empty());
        DiffModalEntity diffModal = InlineDiffKt.diffModal($this$createDiffInterline, rightEditor2, rightId, closeable, revertible, interlineId);
        WorkerKt.onDispose((Entity)diffModal, (CoroutineScope)((CoroutineScope)pluginScope), (Function0)((Function0)new Function0<Unit>(pluginScope, leftEditor2){
            final /* synthetic */ PluginScope $pluginScope;
            final /* synthetic */ EditorEntity $leftEditor;
            {
                this.$pluginScope = $pluginScope;
                this.$leftEditor = $leftEditor;
                super(0);
            }

            public final void invoke() {
                this.$pluginScope.changeAsync((Function1)new Function1<ChangeScope, Unit>(this.$leftEditor){
                    final /* synthetic */ EditorEntity $leftEditor;
                    {
                        this.$leftEditor = $leftEditor;
                        super(1);
                    }

                    public final void invoke(ChangeScope $this$changeAsync) {
                        Intrinsics.checkNotNullParameter((Object)$this$changeAsync, (String)"$this$changeAsync");
                        if (EntitiesKt.exists((Entity)((Entity)this.$leftEditor))) {
                            UnsharedHackKt.maybeShared((ChangeScope)$this$changeAsync, (Entity)((Entity)this.$leftEditor.getDocument()), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this.$leftEditor){
                                final /* synthetic */ EditorEntity $leftEditor;
                                {
                                    this.$leftEditor = $leftEditor;
                                    super(1);
                                }

                                public final void invoke(SharedChangeScope $this$maybeShared) {
                                    Intrinsics.checkNotNullParameter((Object)$this$maybeShared, (String)"$this$maybeShared");
                                    $this$maybeShared.delete((Entity)this.$leftEditor);
                                }
                            }));
                        }
                    }
                });
            }
        }));
        RevertGutterWidget widget2 = revertible ? RevertWidgetKt.inlineRevertWidget(leftIntervals, leftId, leftEditor2.getDocument(), rightIntervals, rightId, rightEditor2, (Function1<? super ChangeScope, Unit>)((Function1)new Function1<ChangeScope, Unit>(diffModal){
            final /* synthetic */ DiffModalEntity $diffModal;
            {
                this.$diffModal = $diffModal;
                super(1);
            }

            public final void invoke(ChangeScope $this$inlineRevertWidget) {
                Intrinsics.checkNotNullParameter((Object)$this$inlineRevertWidget, (String)"$this$inlineRevertWidget");
                $this$inlineRevertWidget.delete((Entity)this.$diffModal);
            }
        })) : null;
        ChangeScope.DefaultImpls.new$default((ChangeScope)$this$createDiffInterline, (KClass)Reflection.getOrCreateKotlinClass(DiffMarkup.class), (int)0, (Function1)((Function1)new Function1<DiffMarkup, Unit>(leftEditor2, diffModal, (Intervals<Long, TextAttributesKey>)leftIntervals, closeable, isDeletion, widget2, leftId, leftPaintRange){
            final /* synthetic */ EditorEntity $leftEditor;
            final /* synthetic */ DiffModalEntity $diffModal;
            final /* synthetic */ Intervals<Long, TextAttributesKey> $leftIntervals;
            final /* synthetic */ boolean $closeable;
            final /* synthetic */ boolean $isDeletion;
            final /* synthetic */ RevertGutterWidget $widget;
            final /* synthetic */ long $leftId;
            final /* synthetic */ TextRange $leftPaintRange;
            {
                this.$leftEditor = $leftEditor;
                this.$diffModal = $diffModal;
                this.$leftIntervals = $leftIntervals;
                this.$closeable = $closeable;
                this.$isDeletion = $isDeletion;
                this.$widget = $widget;
                this.$leftId = $leftId;
                this.$leftPaintRange = $leftPaintRange;
                super(1);
            }

            public final void invoke(DiffMarkup $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setEditor(this.$leftEditor);
                $this$new.setDiffModalEntity(this.$diffModal);
                $this$new.setDocument(this.$leftEditor.getDocument());
                $this$new.setIntervals(this.$leftIntervals);
                $this$new.setGutterWidgets(this.$closeable && this.$isDeletion && this.$widget != null ? Intervals.Companion.fromSingle((Object)this.$leftId, this.$leftPaintRange, true, true, (Object)this.$widget) : Intervals.Companion.empty());
                $this$new.setLayer(300);
                $this$new.setDebugName("Diff line status");
            }
        }), (int)2, null);
        $this$createDiffInterline.set((Entity)diffModal, DiffModalEntity.Companion.getMarkupAttr(), (Object)ChangeScope.DefaultImpls.new$default((ChangeScope)$this$createDiffInterline, (KClass)Reflection.getOrCreateKotlinClass(DiffMarkup.class), (int)0, (Function1)((Function1)new Function1<DiffMarkup, Unit>(rightEditor2, diffModal, (Intervals<Long, TextAttributesKey>)rightIntervals, closeable, isDeletion, widget2, leftId, rightPaintRange){
            final /* synthetic */ EditorEntity $rightEditor;
            final /* synthetic */ DiffModalEntity $diffModal;
            final /* synthetic */ Intervals<Long, TextAttributesKey> $rightIntervals;
            final /* synthetic */ boolean $closeable;
            final /* synthetic */ boolean $isDeletion;
            final /* synthetic */ RevertGutterWidget $widget;
            final /* synthetic */ long $leftId;
            final /* synthetic */ TextRange $rightPaintRange;
            {
                this.$rightEditor = $rightEditor;
                this.$diffModal = $diffModal;
                this.$rightIntervals = $rightIntervals;
                this.$closeable = $closeable;
                this.$isDeletion = $isDeletion;
                this.$widget = $widget;
                this.$leftId = $leftId;
                this.$rightPaintRange = $rightPaintRange;
                super(1);
            }

            public final void invoke(DiffMarkup $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setEditor(this.$rightEditor);
                $this$new.setDiffModalEntity(this.$diffModal);
                $this$new.setDocument(this.$rightEditor.getDocument());
                $this$new.setIntervals(this.$rightIntervals);
                $this$new.setGutterWidgets(this.$closeable && !this.$isDeletion && this.$widget != null ? Intervals.Companion.fromSingle((Object)this.$leftId, this.$rightPaintRange, true, true, (Object)this.$widget) : Intervals.Companion.empty());
                $this$new.setLayer(300);
                $this$new.setDebugName("Diff line status");
            }
        }), (int)2, null));
        EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout((EditorEntity)leftEditor2);
        Intrinsics.checkNotNull((Object)editorLayoutEntity);
        LinesCache linesCache = editorLayoutEntity.getLinesCache();
        Line lastLine = linesCache.line(leftPaintRange.getEnd());
        Interline.Binding binding = isDeletion && rightReader.startOffset(fragmentIndex) == 0L ? Interline.Binding.AboveLine : Interline.Binding.BelowLine;
        long l = LineBasedHeight.minus-RJHVaDk((long)LineBasedHeight.plus-RJHVaDk((long)lastLine.getLineTop-x8klknc(), (long)lastLine.getTotalHeight-x8klknc()), (long)linesCache.line(leftPaintRange.getStart()).getLineTop-x8klknc());
        DiffInterline interline = new DiffInterline(binding, l, interlineId, diffModal, leftEditor2, rightEditor2, leftPaintRange, closeable, isDeletion, null);
        long pos = rightReader.startOffset(fragmentIndex);
        EditorLayoutEntity editorLayoutEntity2 = EditorEntityExtKt.getLayout((EditorEntity)rightEditor2);
        Intrinsics.checkNotNull((Object)editorLayoutEntity2);
        editorLayoutEntity2.addInterlines(CollectionsKt.listOf((Object)new Interval((Object)interline.getId(), pos, pos, false, false, (Object)interline)));
        return diffModal;
    }

    @NotNull
    public static final TextAttributesKey toTextAttributeKey(@NotNull DiffType $this$toTextAttributeKey, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextAttributeKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toTextAttributeKey.ordinal()]) {
            case 1 -> {
                if (range.isEmpty()) {
                    yield EditorSchemeKt.getEditorScheme().getDiffAddedEmpty();
                }
                yield EditorSchemeKt.getEditorScheme().getDiffAddedWord();
            }
            case 2 -> {
                if (range.isEmpty()) {
                    yield EditorSchemeKt.getEditorScheme().getDiffDeletedEmpty();
                }
                yield EditorSchemeKt.getEditorScheme().getDiffDeletedWord();
            }
            case 3 -> {
                if (range.isEmpty()) {
                    yield EditorSchemeKt.getEditorScheme().getTransparent();
                }
                yield EditorSchemeKt.getEditorScheme().getDiffModifiedWord();
            }
            default -> throw new IllegalStateException("Unreachable".toString());
        };
    }

    private static final Interval<Long, TextAttributesKey> toInterval(TextRange range, DiffType type) {
        return new Interval((Object)AtomicExtensionsKt.incrementAndGet((AtomicRef)EditorLayoutEntity.Companion.getNextId()), range.getStart(), range.getEnd(), true, true, (Object)DiffInterlineKt.toTextAttributeKey(type, range));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiffType.values().length];
            try {
                nArray[DiffType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffType.DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffType.MODIFIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

