/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization;

import com.jetbrains.fus.reporting.anonymization.AnonymizerUtil;
import com.jetbrains.fus.reporting.anonymization.LogAnonymizer$WhenMappings;
import com.jetbrains.fus.reporting.model.exceptions.FusReportingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ$\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/LogAnonymizer;", "", "salt", "", "mode", "Lcom/jetbrains/fus/reporting/anonymization/LogAnonymizer$Mode;", "([BLcom/jetbrains/fus/reporting/anonymization/LogAnonymizer$Mode;)V", "anonymize", "", "value", "anonymizeValue", "key", "hashedValues", "", "Mode", "anonymization"})
public final class LogAnonymizer {
    private final byte[] salt;
    private final Mode mode;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object anonymizeValue(@NotNull String key, @NotNull Object value, @NotNull Set<String> hashedValues) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(hashedValues, (String)"hashedValues");
        Object object2 = value;
        if (object2 instanceof String) {
            object = hashedValues.contains(key) ? this.anonymize((String)value) : (String)value;
        } else if (object2 instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var21_24 = it != null ? this.anonymizeValue(key, it, hashedValues) : it;
                collection.add(var21_24);
            }
            object = (List)destination$iv$iv;
        } else if (object2 instanceof Map) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((Map)value).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                void entryKey;
                Map map = destination$iv$iv2;
                Map.Entry $dstr$entryKey$entryValue = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Map.Entry entry = $dstr$entryKey$entryValue;
                boolean bl2 = false;
                Object k = entry.getKey();
                entry = $dstr$entryKey$entryValue;
                bl2 = false;
                Object entryValue = entry.getValue();
                Object newValue = entryValue != null ? this.anonymizeValue(key + '.' + entryKey, entryValue, hashedValues) : entryValue;
                Pair pair = TuplesKt.to((Object)entryKey, newValue);
                boolean bl3 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            object = destination$iv$iv2;
        } else {
            object = this.anonymizeValue(key, value.toString(), hashedValues);
        }
        return object;
    }

    @NotNull
    public final String anonymize(@NotNull String value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.isBlank((CharSequence)value)) {
            return value;
        }
        switch (LogAnonymizer$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                string = AnonymizerUtil.INSTANCE.anonymize(this.salt, value) + this.mode.getMarker();
                break;
            }
            case 2: {
                if (StringsKt.endsWith$default((String)value, (String)Mode.CLIENT.getMarker(), (boolean)false, (int)2, null)) {
                    String oldId = StringsKt.substringBefore$default((String)value, (String)Mode.CLIENT.getMarker(), null, (int)2, null);
                    return AnonymizerUtil.INSTANCE.anonymize(this.salt, oldId) + Mode.CLIENT.getMarker() + this.mode.getMarker();
                }
                string = AnonymizerUtil.INSTANCE.anonymize(this.salt, value) + this.mode.getMarker();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public LogAnonymizer(@NotNull byte[] salt, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.salt = salt;
        this.mode = mode;
        byte[] byArray = this.salt;
        boolean bl = false;
        if (byArray.length == 0) {
            throw (Throwable)new FusReportingException("Salt should be not empty", null, 2, null);
        }
    }

    public /* synthetic */ LogAnonymizer(byte[] byArray, Mode mode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mode = Mode.CLIENT;
        }
        this(byArray, mode);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/LogAnonymizer$Mode;", "", "marker", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getMarker", "()Ljava/lang/String;", "CLIENT", "SERVER", "anonymization"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode CLIENT;
        public static final /* enum */ Mode SERVER;
        private static final /* synthetic */ Mode[] $VALUES;
        @NotNull
        private final String marker;

        static {
            Mode[] modeArray = new Mode[2];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = CLIENT = new Mode("#C");
            modeArray[1] = SERVER = new Mode("#S");
            $VALUES = modeArray;
        }

        @NotNull
        public final String getMarker() {
            return this.marker;
        }

        private Mode(String marker) {
            this.marker = marker;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }
}

