/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization;

import com.jetbrains.fus.reporting.anonymization.FieldsToAnonymizeStorage;
import com.jetbrains.fus.reporting.anonymization.LogAnonymizer;
import com.jetbrains.fus.reporting.model.lion4.FusReport;
import com.jetbrains.fus.reporting.model.lion4.LogEvent;
import com.jetbrains.fus.reporting.model.lion4.LogEventAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/EventLogAnonymizer;", "", "fieldsToAnonymizeStorage", "Lcom/jetbrains/fus/reporting/anonymization/FieldsToAnonymizeStorage;", "salt", "", "(Lcom/jetbrains/fus/reporting/anonymization/FieldsToAnonymizeStorage;[B)V", "anonymizer", "Lcom/jetbrains/fus/reporting/anonymization/LogAnonymizer;", "anonymize", "Lcom/jetbrains/fus/reporting/model/lion4/FusReport;", "report", "anonymizeEventAction", "Lcom/jetbrains/fus/reporting/model/lion4/LogEventAction;", "eventAction", "groupId", "", "anonymizeIds", "", "event", "Lcom/jetbrains/fus/reporting/model/lion4/LogEvent;", "anonymization"})
public final class EventLogAnonymizer {
    private final LogAnonymizer anonymizer;
    private final FieldsToAnonymizeStorage fieldsToAnonymizeStorage;

    @NotNull
    public final FusReport anonymize(@NotNull FusReport report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        boolean bl = false;
        List events = new ArrayList();
        for (LogEvent event : report.getEvents()) {
            String session = event.getSession();
            String anonymizedSession = session == null ? null : this.anonymizer.anonymize(session);
            LogEventAction anonymizedEvent = this.anonymizeEventAction(event.getEvent(), event.getGroup().getId());
            events.add(new LogEvent(event.getRecorder(), event.getProduct(), this.anonymizeIds(event), event.getInternal(), event.getTime(), event.getBuild(), anonymizedSession, event.getGroup(), event.getBucket(), anonymizedEvent, event.getSystem_data(), event.getClient_data()));
        }
        return new FusReport(events);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> anonymizeIds(LogEvent event) {
        void $this$mapValuesTo$iv$iv;
        Set<String> skipAnonymizationIds = this.fieldsToAnonymizeStorage.getSkipAnonymizationIds();
        Map $this$mapValues$iv = event.getIds();
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void key;
            void $dstr$key$value;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            void var18_18 = $dstr$key$value;
            boolean bl3 = false;
            String string = (String)var18_18.getKey();
            var18_18 = $dstr$key$value;
            bl3 = false;
            String value = (String)var18_18.getValue();
            String string2 = skipAnonymizationIds.contains(key) ? value : this.anonymizer.anonymize(value);
            map3.put(k2, string2);
        }
        return destination$iv$iv;
    }

    private final LogEventAction anonymizeEventAction(LogEventAction eventAction, String groupId) {
        Set<String> fieldsToAnonymize = this.fieldsToAnonymizeStorage.getFieldsToAnonymize(groupId, eventAction.getId());
        if (fieldsToAnonymize.isEmpty()) {
            return eventAction;
        }
        HashMap anonymizedData = new HashMap();
        Map map = eventAction.getData();
        boolean bl = false;
        for (Map.Entry eventData : map.entrySet()) {
            ((Map)anonymizedData).put(eventData.getKey(), this.anonymizer.anonymizeValue((String)eventData.getKey(), eventData.getValue(), fieldsToAnonymize));
        }
        return new LogEventAction(eventAction.getId(), (Map)anonymizedData, eventAction.getCount());
    }

    public EventLogAnonymizer(@NotNull FieldsToAnonymizeStorage fieldsToAnonymizeStorage, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)fieldsToAnonymizeStorage, (String)"fieldsToAnonymizeStorage");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        this.fieldsToAnonymizeStorage = fieldsToAnonymizeStorage;
        this.anonymizer = new LogAnonymizer(salt, LogAnonymizer.Mode.CLIENT);
    }
}

