/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.css.impl.util.scheme;

import fleet.com.intellij.openapi.application.ApplicationManager;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.css.CssBundle;
import fleet.com.intellij.psi.css.CssMediaFeatureDescriptor;
import fleet.com.intellij.psi.css.CssPropertyDescriptor;
import fleet.com.intellij.psi.css.descriptor.BrowserVersion;
import fleet.com.intellij.psi.css.descriptor.CssContextType;
import fleet.com.intellij.psi.css.descriptor.CssElementDescriptor;
import fleet.com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import fleet.com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import fleet.com.intellij.psi.css.descriptor.value.CssAnyValue;
import fleet.com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import fleet.com.intellij.psi.css.impl.CssTermTypes;
import fleet.com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import fleet.com.intellij.psi.css.impl.descriptor.CssFunctionDescriptorImpl;
import fleet.com.intellij.psi.css.impl.descriptor.value.CssAnyValueImpl;
import fleet.com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import fleet.com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import fleet.com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import fleet.com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import fleet.com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import fleet.com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import fleet.com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import fleet.com.intellij.psi.css.impl.util.scheme.CssDescriptorsLoader;
import fleet.com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import fleet.com.intellij.reference.SoftReference;
import fleet.com.intellij.util.containers.ContainerUtil;
import fleet.com.intellij.util.containers.MultiMap;
import java.lang.ref.Reference;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementDescriptorFactory2 {
    private static final Logger LOG = Logger.getInstance(CssElementDescriptorFactory2.class);
    private static final CssCommonDescriptorData CSS_TOGGLE_FUNCTION_COMMON_DATA = new CssCommonDescriptorData("toggle", "toggle", new CssContextType[]{CssContextType.ANY}, BrowserVersion.EMPTY_ARRAY, (Object)CssElementDescriptor.CssVersion.CSS_3_0, "http://dev.w3.org/csswg/css-values/#funcdef-toggle", "The toggle() expression allows descendant elements to cycle over a list of values instead of inheriting the same value.");
    private static final CssCommonDescriptorData CSS_VAR_FUNCTION_COMMON_DATA = new CssCommonDescriptorData("var", "var", CssContextType.values(), new BrowserVersion[]{new BrowserVersion(BrowserVersion.Browser.CHROME, "49"), new BrowserVersion(BrowserVersion.Browser.SAFARI, "9.1"), new BrowserVersion(BrowserVersion.Browser.FIREFOX, "31"), new BrowserVersion(BrowserVersion.Browser.OPERA, "36"), new BrowserVersion(BrowserVersion.Browser.EDGE, "16")}, (Object)CssElementDescriptor.CssVersion.CSS_3_0, "https://www.w3.org/TR/css-variables/#funcdef-var", "The var() function returns the value of a custom property.");
    private static final String[] SCHEME_NAMES = new String[]{"css-cascade-4.xml", "css1.0.xml", "css3-gcpm.xml", "css2.0.xml", "css2.1.xml", "css3.0.xml", "css-values-4.xml", "css-overflow-3.xml", "css-box-3.xml", "css-page-floats.xml", "css3-page.xml", "custom-elements.xml", "css-images-4.xml", "css3-images.xml", "css3-line-grid.xml", "css3-mediaqueries.xml", "view-mode.xml", "css-device-adapt.xml", "css3-transitions.xml", "css3-animations.xml", "css-transforms-1.xml", "css-transforms-2.xml", "css-text-3.xml", "css-text-4.xml", "css-ruby-1.xml", "css3-speech.xml", "css-ui-4.xml", "css-counter-styles-3.xml", "css-lists-3.xml", "css3-filter-effects.xml", "css-scoping1.xml", "css-regions.xml", "css3-break.xml", "css3-flexbox.xml", "css3-grid.xml", "css-masking-1.xml", "css-shapes-1.xml", "css3-background.xml", "css-display-3.xml", "css3-fonts.xml", "css-fonts-4.xml", "fontface.xml", "css-text-decor-3.xml", "css-text-decor-4.xml", "css3-preslev.xml", "css-position-3.xml", "css-compositing-1.xml", "css3-align.xml", "ie.xml", "css3-writing-modes.xml", "jquery.xml", "mozilla.xml", "mso.xml", "opera.xml", "svg.xml", "webkit.xml", "css-scroll-snap.xml", "css-will-change.xml", "css-inline-3.xml", "appmanifest.xml", "css-color-4.xml", "css-selectors-4.xml", "css-pseudo-4.xml", "cssModules.xml", "css-contain-2.xml", "mediaqueries4.xml", "mediaqueries-5.xml", "css-logical-1.xml", "css-motion-1.xml", "css-overscroll-behavior.xml", "css-shadow-parts-1.xml", "css-size-adjust.xml", "css-sizing-3.xml", "css-sizing-4.xml", "css-scroll-anchoring-1.xml", "css-scrollbars-1.xml", "css-color-adjust-1.xml", "css-contain-3.xml", "css-color-5.xml", "css-content-3.xml", "css-properties-values-api-1.xml"};
    public static final Set<String> CUSTOM_VALUES = Set.of("rpx", "upx");
    private final String[] mySchemesToLoad;
    private Reference<CssDescriptorsHolder> myCssDescriptorsHolderRef;

    public static CssElementDescriptorFactory2 getInstance() {
        return (CssElementDescriptorFactory2)ApplicationManager.getApplication().getService(CssElementDescriptorFactory2.class);
    }

    private synchronized CssDescriptorsHolder getDescriptors() {
        CssDescriptorsHolder descriptors = (CssDescriptorsHolder)SoftReference.dereference(this.myCssDescriptorsHolderRef);
        return descriptors != null ? descriptors : this.reload();
    }

    @NotNull
    public Collection<CssPseudoSelectorDescriptor> findPseudoSelector(@NotNull String name) {
        return this.getDescriptors().pseudoSelectors.get((Object)StringUtil.toLowerCase((String)name));
    }

    @NotNull
    public Collection<CssPropertyDescriptor> findProperty(@NotNull String name) {
        return this.getProperties().get((Object)StringUtil.toLowerCase((String)name));
    }

    @NotNull
    public Collection<CssFunctionDescriptor> findFunction(@NotNull String name) {
        return this.getDescriptors().functions.get((Object)StringUtil.toLowerCase((String)name));
    }

    @NotNull
    public Collection<CssMediaFeatureDescriptor> findMediaFeature(@NotNull String name) {
        return this.getDescriptors().mediaFeatures.get((Object)StringUtil.toLowerCase((String)name));
    }

    public Set<String> getAllNamedValues() {
        return this.getDescriptors().namedValues.keySet();
    }

    @NotNull
    public Collection<CssValueDescriptor> findNamedValue(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (parent != null) {
            return ContainerUtil.map((Collection)this.getDescriptors().namedValues.get((Object)StringUtil.toLowerCase((String)name)), descriptor -> CssValueDescriptorModificator.withParent(descriptor, parent));
        }
        return this.getDescriptors().namedValues.get((Object)StringUtil.toLowerCase((String)name));
    }

    @NotNull
    public MultiMap<String, CssPseudoSelectorDescriptor> getPseudoSelectors() {
        return this.getDescriptors().pseudoSelectors;
    }

    @NotNull
    public MultiMap<String, CssFunctionDescriptor> getFunctions() {
        return this.getDescriptors().functions;
    }

    @NotNull
    public MultiMap<String, CssPropertyDescriptor> getProperties() {
        return this.getDescriptors().properties;
    }

    @NotNull
    public MultiMap<String, CssMediaFeatureDescriptor> getMediaFeatures() {
        return this.getDescriptors().mediaFeatures;
    }

    @NotNull
    public Set<String> getValueIdentifiers() {
        HashSet<String> result = new HashSet<String>(this.getDescriptors().valueIdentifiers);
        result.addAll(CUSTOM_VALUES);
        return result;
    }

    @NotNull
    public CssFunctionDescriptor createToggleFunctionDescriptorFromPropertyDescriptor(@NotNull CssPropertyDescriptor descriptor) {
        return new CssFunctionDescriptorImpl(CSS_TOGGLE_FUNCTION_COMMON_DATA, CssValueDescriptorModificator.withQuantifiers(descriptor.getValueDescriptor(), 1, -1, true), CssTermTypes.TOGGLE);
    }

    @NotNull
    public CssFunctionDescriptor createVarFunctionDescriptorFromPropertyDescriptors(@NotNull CssValueDescriptor valueDescriptor) {
        CssGroupValue value = this.createGroupValue(CssGroupValue.Type.ALL, 1, 1, null, null);
        value.addChild(this.createNameValueDescriptor(null, CssBundle.message("custom.property.name.value.presentable.name", new Object[0]), 1, 1, value));
        CssGroupValue defaultValue = this.createGroupValue(CssGroupValue.Type.ALL, 0, 1, value, null);
        defaultValue.addChild(this.createTextValueDescriptor(",", 1, 1, defaultValue));
        defaultValue.addChild(CssValueDescriptorModificator.withParent(valueDescriptor, defaultValue));
        value.addChild(defaultValue);
        return new CssFunctionDescriptorImpl(CSS_VAR_FUNCTION_COMMON_DATA, value, CssTermTypes.VAR);
    }

    public CssElementDescriptorFactory2() {
        this(SCHEME_NAMES);
    }

    public CssElementDescriptorFactory2(String ... schemesToLoad) {
        this.mySchemesToLoad = schemesToLoad;
    }

    public synchronized CssDescriptorsHolder reload() {
        CssDescriptorsLoader loader = new CssDescriptorsLoader();
        for (String scheme : this.mySchemesToLoad) {
            URL resource = this.getClass().getResource("xml/" + scheme);
            if (resource == null) {
                LOG.warn("Cannot find CSS scheme: " + scheme);
                continue;
            }
            loader.loadDescriptors(resource);
        }
        CssDescriptorsHolder descriptors = loader.getDescriptors();
        this.myCssDescriptorsHolderRef = new java.lang.ref.SoftReference<CssDescriptorsHolder>(descriptors);
        return descriptors;
    }

    public CssGroupValue createGroupValue(@NotNull CssGroupValue.Type type, int minOccur, int maxOccur, @Nullable CssValueDescriptor parent, @Nullable CssValueDescriptor separator) {
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData("", "", CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, (Object)CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(false, minOccur, maxOccur, null, null, parent, null, false);
        return CssGroupValue.create(commonDescriptorData, valueDescriptorData, true, separator, type);
    }

    public CssTextValue createTextValueDescriptor(@NotNull String text, int minOccur, int maxOccur, CssValueDescriptor parent) {
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(text, text, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, (Object)CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssTextValue(text, commonDescriptorData, valueDescriptorData);
    }

    public CssNameValue createNameValueDescriptor(@Nullable String id, @Nullable String presentableName, int minOccur, int maxOccur, CssValueDescriptor parent) {
        presentableName = StringUtil.notNullize((String)presentableName, (String)CssBundle.message("name.value.presentable.name", new Object[0]));
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(presentableName, presentableName, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, (Object)CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssNameValue(id, true, commonDescriptorData, valueDescriptorData);
    }

    public CssAnyValue createAnyValueDescriptor(int minOccur, int maxOccur, CssValueDescriptor parent) {
        String id = CssBundle.message("any.value.presentable.name", new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, (Object)CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssAnyValueImpl(commonDescriptorData, valueDescriptorData);
    }

    public CssStringValue createStringValueDescriptor(@Nullable String stringValue, int minOccur, int maxOccur, CssValueDescriptor parent) {
        String id = stringValue != null ? StringUtil.wrapWithDoubleQuote((String)stringValue) : CssBundle.message("string.value.presentable.name", new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, (Object)CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssStringValue(stringValue, commonDescriptorData, valueDescriptorData);
    }

    public CssFunctionInvocationValue createFunctionInvocationValueDescriptor(@NotNull String name, int minOccur, int maxOccur, CssValueDescriptor parent) {
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(name, name, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, (Object)CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssFunctionInvocationValue(name, commonDescriptorData, valueDescriptorData);
    }
}

