/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.html.embedding;

import fleet.com.intellij.html.embedding.BaseHtmlEmbeddedContentProvider;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.lexer.LexerPosition;
import fleet.com.intellij.lexer.html.BaseHtmlLexer;
import fleet.com.intellij.lexer.html.HtmlEmbeddedContentSupportHelperKt;
import fleet.com.intellij.openapi.util.TextRange;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H$J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u0014H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006#"}, d2={"Lfleet/com/intellij/html/embedding/HtmlAttributeEmbeddedContentProvider;", "Lfleet/com/intellij/html/embedding/BaseHtmlEmbeddedContentProvider;", "lexer", "Lfleet/com/intellij/lexer/html/BaseHtmlLexer;", "(Lfleet/com/intellij/lexer/html/BaseHtmlLexer;)V", "attributeName", "", "getAttributeName", "()Ljava/lang/CharSequence;", "myAttributeName", "myTagName", "myTagNameRead", "", "myWithinTag", "tagName", "getTagName", "findTheEndOfEmbedment", "Lkotlin/Pair;", "", "getState", "", "handleToken", "", "tokenType", "Lfleet/com/intellij/psi/tree/IElementType;", "range", "Lfleet/com/intellij/openapi/util/TextRange;", "hasState", "isAttributeEmbedmentToken", "isInterestedInAttribute", "isInterestedInTag", "isStartOfEmbedment", "restoreState", "state", "AttributeState", "xml-parser"})
public abstract class HtmlAttributeEmbeddedContentProvider
extends BaseHtmlEmbeddedContentProvider {
    private boolean myTagNameRead;
    private boolean myWithinTag;
    @Nullable
    private CharSequence myTagName;
    @Nullable
    private CharSequence myAttributeName;

    public HtmlAttributeEmbeddedContentProvider(@NotNull BaseHtmlLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)((Object)lexer), (String)"lexer");
        super(lexer);
    }

    @Nullable
    protected final CharSequence getAttributeName() {
        return this.myAttributeName;
    }

    @Nullable
    protected final CharSequence getTagName() {
        return this.myTagName;
    }

    protected abstract boolean isInterestedInTag(@NotNull CharSequence var1);

    protected abstract boolean isInterestedInAttribute(@NotNull CharSequence var1);

    @Override
    public void handleToken(@NotNull IElementType tokenType, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_START_TAG_START)) {
            this.myTagNameRead = false;
            this.embedment = false;
            this.myWithinTag = false;
            this.myTagName = null;
            this.myAttributeName = null;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_NAME)) {
            Lexer baseLexer = this.getLexer().getDelegate();
            if (!this.myTagNameRead) {
                CharSequence charSequence = range.subSequence(baseLexer.getBufferSequence());
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
                CharSequence tagName = charSequence;
                this.myWithinTag = this.isInterestedInTag(tagName);
                if (this.myWithinTag) {
                    this.myTagName = tagName;
                }
                this.myTagNameRead = true;
            } else if (this.myWithinTag) {
                CharSequence charSequence = range.subSequence(baseLexer.getBufferSequence());
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
                CharSequence attributeName = charSequence;
                this.embedment = this.isInterestedInAttribute(attributeName);
                this.myAttributeName = this.embedment ? attributeName : null;
            }
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_TAG_END) ? true : Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_END_TAG_START)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_EMPTY_ELEMENT_END)) {
            this.myTagNameRead = tokenType == XmlTokenType.XML_END_TAG_START;
            this.myWithinTag = false;
            this.myTagName = null;
            this.myAttributeName = null;
            this.embedment = false;
        }
    }

    @Override
    protected boolean isStartOfEmbedment(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return this.myAttributeName != null && this.isAttributeEmbedmentToken(tokenType);
    }

    protected boolean isAttributeEmbedmentToken(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        CharSequence charSequence = this.myAttributeName;
        Intrinsics.checkNotNull((Object)charSequence);
        return HtmlEmbeddedContentSupportHelperKt.isAttributeEmbedmentToken(baseHtmlLexer, tokenType, charSequence);
    }

    @Override
    @NotNull
    protected Pair<Integer, Integer> findTheEndOfEmbedment() {
        Lexer baseLexer = this.getLexer().getDelegate();
        LexerPosition lexerPosition = baseLexer.getCurrentPosition();
        Intrinsics.checkNotNullExpressionValue((Object)lexerPosition, (String)"getCurrentPosition(...)");
        LexerPosition position = lexerPosition;
        while (true) {
            IElementType iElementType = baseLexer.getTokenType();
            if (iElementType == null || !this.isAttributeEmbedmentToken(iElementType)) break;
            baseLexer.advance();
        }
        Pair result = new Pair((Object)baseLexer.getTokenStart(), (Object)baseLexer.getState());
        baseLexer.restore(position);
        return result;
    }

    @Override
    public void restoreState(@Nullable Object state) {
        if (state == null) {
            this.myTagNameRead = false;
            this.myWithinTag = false;
            this.myTagName = null;
            this.myAttributeName = null;
            this.embedment = false;
            return;
        }
        if (!(state instanceof AttributeState)) {
            return;
        }
        this.myTagNameRead = ((AttributeState)state).getTagNameRead();
        this.myWithinTag = ((AttributeState)state).getWithinTag();
        this.myTagName = ((AttributeState)state).getTagName();
        this.myAttributeName = ((AttributeState)state).getAttributeName();
        this.embedment = ((AttributeState)state).getEmbedment();
    }

    @Override
    public boolean hasState() {
        return this.myTagNameRead || this.myWithinTag || this.myTagName != null || this.myAttributeName != null || this.embedment;
    }

    @Override
    @Nullable
    public Object getState() {
        return this.hasState() ? new AttributeState(this.myTagNameRead, this.myWithinTag, this.myTagName, this.myAttributeName, this.embedment) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lfleet/com/intellij/html/embedding/HtmlAttributeEmbeddedContentProvider$AttributeState;", "Lfleet/com/intellij/html/embedding/BaseHtmlEmbeddedContentProvider$BaseState;", "tagNameRead", "", "withinTag", "tagName", "", "attributeName", "embedment", "(ZZLjava/lang/CharSequence;Ljava/lang/CharSequence;Z)V", "getAttributeName", "()Ljava/lang/CharSequence;", "getTagName", "getTagNameRead", "()Z", "getWithinTag", "xml-parser"})
    public static class AttributeState
    extends BaseHtmlEmbeddedContentProvider.BaseState {
        private final boolean tagNameRead;
        private final boolean withinTag;
        @Nullable
        private final CharSequence tagName;
        @Nullable
        private final CharSequence attributeName;

        public AttributeState(boolean tagNameRead, boolean withinTag, @Nullable CharSequence tagName, @Nullable CharSequence attributeName, boolean embedment) {
            super(embedment);
            this.tagNameRead = tagNameRead;
            this.withinTag = withinTag;
            this.tagName = tagName;
            this.attributeName = attributeName;
        }

        public final boolean getTagNameRead() {
            return this.tagNameRead;
        }

        public final boolean getWithinTag() {
            return this.withinTag;
        }

        @Nullable
        public final CharSequence getTagName() {
            return this.tagName;
        }

        @Nullable
        public final CharSequence getAttributeName() {
            return this.attributeName;
        }
    }
}

