/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.lightweightIndexer.workspace;

import ai.grazie.code.files.model.FileSystemProvider;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.FileDescriptor;
import fleet.api.HostId;
import fleet.api.LocationInFile;
import fleet.api.Os;
import fleet.api.ProtocolPath;
import fleet.common.util.LocationUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lfleet/plugins/lightweightIndexer/workspace/FleetFileSystemSerialization;", "Lai/grazie/code/files/model/FileSystemProvider$Serialization;", "Lfleet/api/FileDescriptor;", "host", "Lfleet/api/HostId;", "<init>", "(Lfleet/api/HostId;)V", "fromAbsoluteString", "path", "", "toPathString", "fromRelativeString", "base", "fleet.plugins.lightweightIndexer.workspace"})
final class FleetFileSystemSerialization
implements FileSystemProvider.Serialization<FileDescriptor> {
    @NotNull
    private final HostId host;

    public FleetFileSystemSerialization(@NotNull HostId host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
    }

    @NotNull
    public FileDescriptor fromAbsoluteString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ProtocolPath protocolPath = ProtocolPath.Companion.of(path, Os.Companion.local());
        FileAddress fileAddress = new FileAddress(this.host, protocolPath);
        return (FileDescriptor)new FileDescriptor.Address(fileAddress);
    }

    @NotNull
    public String toPathString(@NotNull FileDescriptor path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileAddress fileAddress = LocationUtilKt.getFileAddress((LocationInFile)((LocationInFile)path));
        if ((fileAddress != null && (fileAddress = fileAddress.getPath()) != null ? fileAddress.joinToString() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public FileDescriptor fromRelativeString(@NotNull FileDescriptor base, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileAddress fileAddress = LocationUtilKt.getFileAddress((LocationInFile)((LocationInFile)base));
        if (fileAddress == null || (fileAddress = FileAddressKt.resolveChild((FileAddress)fileAddress, (String)path)) == null) {
            fileAddress = FileAddress.Companion.getINVALID();
        }
        return (FileDescriptor)new FileDescriptor.Address(fileAddress);
    }
}

