/*
 * Decompiled with CFR 0.152.
 */
package fleet.org.jetbrains.plugins.groovy.lang.parser;

import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.LanguageUtil;
import fleet.com.intellij.lang.ParserDefinition;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.FileViewProvider;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.ArrayUtil;
import fleet.org.jetbrains.plugins.groovy.GroovyLanguage;
import fleet.org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import fleet.org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import fleet.org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import fleet.org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import fleet.org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import fleet.org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class GroovyParserDefinition
implements ParserDefinition {
    public static final IFileElementType GROOVY_FILE = new IFileElementType("groovy.FILE", GroovyLanguage.INSTANCE){

        public void parse(@NotNull PsiBuilder builder) {
            new GroovyParser().parseLight((IElementType)this, builder);
        }
    };

    @NotNull
    public Lexer createLexer(Project project) {
        return new GroovyLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new GroovyParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return GROOVY_FILE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSets.COMMENTS_TOKEN_SET;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSets.STRING_LITERALS;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        IElementType lType = left.getElementType();
        IElementType rType = right.getElementType();
        if (rType == GroovyTokenTypes.kIMPORT && lType != TokenType.WHITE_SPACE) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (lType == GroovyElementTypes.MODIFIER_LIST && rType == GroovyElementTypes.MODIFIER_LIST) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lType == GroovyTokenTypes.mSEMI) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (lType == GroovyTokenTypes.mSL_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (lType == GroovyTokenTypes.mNLS || lType == GroovyDocTokenTypes.mGDOC_COMMENT_START) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (lType == GroovyTokenTypes.mGT) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (rType == GroovyTokenTypes.mLT) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        ASTNode parent = GroovyParserDefinition.findCommonParent(left, right);
        if (parent == null || ArrayUtil.contains((Object)parent.getElementType(), (Object[])new IElementType[]{GroovyElementTypes.GSTRING, GroovyElementTypes.REGEX, GroovyElementTypes.GSTRING_INJECTION, GroovyTokenTypes.mREGEX_LITERAL, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL})) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)new GroovyLexer());
    }

    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents = new HashSet<ASTNode>(20);
        while (one != null) {
            parents.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }
}

