/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.psi;

import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.openapi.util.TextRange;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.lexer.PythonLexer;
import fleet.com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import org.jetbrains.annotations.NotNull;

public final class PyStringLiteralUtil
extends PyStringLiteralCoreUtil {
    private static final Logger LOG = Logger.getInstance(PyStringLiteralUtil.class);

    private PyStringLiteralUtil() {
    }

    @NotNull
    public static String getStringValue(@NotNull String s) {
        return PyStringLiteralUtil.getStringValueTextRange(s).substring(s);
    }

    public static TextRange getStringValueTextRange(@NotNull String s) {
        Pair<String, String> quotes = PyStringLiteralUtil.getQuotes(s);
        if (quotes != null) {
            return TextRange.create((int)((String)quotes.getFirst()).length(), (int)(s.length() - ((String)quotes.getSecond()).length()));
        }
        return TextRange.allOf((String)s);
    }

    public static boolean isStringLiteralToken(@NotNull String text) {
        PythonLexer lexer = new PythonLexer();
        lexer.start(text);
        return PyTokenTypes.STRING_NODES.contains(lexer.getTokenType()) && lexer.getTokenEnd() == lexer.getBufferEnd() || PyTokenTypes.FSTRING_START == lexer.getTokenType();
    }

    @NotNull
    public static TextRange getContentRange(@NotNull String text) {
        LOG.assertTrue(PyStringLiteralUtil.isStringLiteralToken(text), (Object)"Text of a single string literal node expected");
        int startOffset = PyStringLiteralUtil.getPrefixLength(text);
        int delimiterLength = 1;
        String afterPrefix = text.substring(startOffset);
        if (afterPrefix.startsWith("\"\"\"") || afterPrefix.startsWith("'''")) {
            delimiterLength = 3;
        }
        String delimiter = text.substring(startOffset, startOffset + delimiterLength);
        int endOffset = text.length();
        if (text.substring(startOffset += delimiterLength).endsWith(delimiter)) {
            endOffset -= delimiterLength;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getPrefixLength(@NotNull String text) {
        return PyStringLiteralUtil.getPrefixEndOffset(text, 0);
    }

    public static boolean isUnicodePrefix(@NotNull String prefix) {
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'u', (int)0) >= 0;
    }

    public static boolean isBytesPrefix(@NotNull String prefix) {
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'b', (int)0) >= 0;
    }

    public static boolean isRawPrefix(@NotNull String prefix) {
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'r', (int)0) >= 0;
    }

    public static boolean isFormattedPrefix(@NotNull String prefix) {
        return StringUtil.indexOfIgnoreCase((String)prefix, (char)'f', (int)0) >= 0;
    }

    public static char flipQuote(char quote) {
        return quote == '\"' ? (char)'\'' : '\"';
    }
}

