/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.parsing;

import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.jetbrains.python.parsing.ExpressionParsing;
import fleet.com.jetbrains.python.parsing.FunctionParsing;
import fleet.com.jetbrains.python.parsing.ParsingScope;
import fleet.com.jetbrains.python.parsing.PatternParsing;
import fleet.com.jetbrains.python.parsing.StatementParsing;
import fleet.com.jetbrains.python.psi.LanguageLevel;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;

public class ParsingContext {
    private final StatementParsing stmtParser;
    private final ExpressionParsing expressionParser;
    private final FunctionParsing functionParser;
    private final PatternParsing patternParser;
    private final SyntaxTreeBuilder myBuilder;
    private final LanguageLevel myLanguageLevel;
    private final Deque<ParsingScope> myScopes;

    public ParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel) {
        this.myBuilder = builder;
        this.myLanguageLevel = languageLevel;
        this.stmtParser = new StatementParsing(this);
        this.expressionParser = new ExpressionParsing(this);
        this.functionParser = new FunctionParsing(this);
        this.patternParser = new PatternParsing(this);
        this.myScopes = new ArrayDeque<ParsingScope>();
        this.myScopes.push(this.emptyParsingScope());
    }

    @NotNull
    public ParsingScope popScope() {
        ParsingScope prevScope = this.myScopes.pop();
        this.resetBuilderCache(prevScope);
        return prevScope;
    }

    public void pushScope(@NotNull ParsingScope scope) {
        ParsingScope prevScope = this.getScope();
        this.myScopes.push(scope);
        this.resetBuilderCache(prevScope);
    }

    @NotNull
    public ParsingScope getScope() {
        return this.myScopes.peek();
    }

    public StatementParsing getStatementParser() {
        return this.stmtParser;
    }

    public ExpressionParsing getExpressionParser() {
        return this.expressionParser;
    }

    public FunctionParsing getFunctionParser() {
        return this.functionParser;
    }

    @NotNull
    public PatternParsing getPatternParser() {
        return this.patternParser;
    }

    public SyntaxTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public ParsingScope emptyParsingScope() {
        return new ParsingScope();
    }

    private void resetBuilderCache(@NotNull ParsingScope prevScope) {
        if (!this.getScope().equals(prevScope)) {
            this.getBuilder().mark().rollbackTo();
        }
    }
}

