/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.lang.typingHandler;

import andel.text.Text;
import andel.text.TextFragmentCharSequence;
import andel.text.TextRange;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J3\u0010\u0014\u001a\u0004\u0018\u00010\u0007*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0018J3\u0010\u0019\u001a\u0004\u0018\u00010\u0007*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lfleet/frontend/lang/typingHandler/PlainTextTypingUtils;", "", "()V", "bracePairs", "", "", "maxSearchLength", "", "braceHighlighter", "", "Landel/text/TextRange;", "text", "Landel/text/Text;", "offset", "", "findMatchingBraceRange", "string", "Landel/text/TextFragmentCharSequence;", "checkLBrace", "", "findBalancedLBrace", "openBrace", "closeBrace", "closeBraceIndex", "(Landel/text/TextFragmentCharSequence;CCII)Ljava/lang/Integer;", "findBalancedRBrace", "startIndex", "fleet.frontend.lang"})
public final class PlainTextTypingUtils {
    @NotNull
    public static final PlainTextTypingUtils INSTANCE = new PlainTextTypingUtils();
    private static final int maxSearchLength = 4000;
    @NotNull
    private static final Map<Character, Character> bracePairs;

    private PlainTextTypingUtils() {
    }

    @Nullable
    public final List<TextRange> braceHighlighter(@NotNull Text text, long offset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextFragmentCharSequence string = text.charSequence();
        List<TextRange> list = this.findMatchingBraceRange(string, offset - 1L, false);
        if (list == null && (list = this.findMatchingBraceRange(string, offset, true)) == null && (list = this.findMatchingBraceRange(string, offset - 1L, true)) == null) {
            list = this.findMatchingBraceRange(string, offset, false);
        }
        return list;
    }

    private final List<TextRange> findMatchingBraceRange(TextFragmentCharSequence string, long offset, boolean checkLBrace) {
        List list;
        if (offset < 0L || offset >= (long)string.length()) {
            return null;
        }
        char character = string.get(offset);
        if (!checkLBrace && StringsKt.contains$default((CharSequence)"])}", (char)character, (boolean)false, (int)2, null)) {
            Character c = bracePairs.get(Character.valueOf(character));
            Intrinsics.checkNotNull((Object)c);
            char lChar = c.charValue();
            Integer n = this.findBalancedLBrace(string, lChar, character, (int)offset, maxSearchLength);
            if (n == null) {
                return null;
            }
            int lIndex = n;
            Object[] objectArray = new TextRange[]{new TextRange(lIndex, lIndex + 1), new TextRange(offset, offset + 1L)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (checkLBrace && StringsKt.contains$default((CharSequence)"{([", (char)character, (boolean)false, (int)2, null)) {
            Character c = bracePairs.get(Character.valueOf(character));
            Intrinsics.checkNotNull((Object)c);
            char rChar = c.charValue();
            Integer n = this.findBalancedRBrace(string, character, rChar, (int)offset + 1, maxSearchLength);
            if (n == null) {
                return null;
            }
            int rIndex = n;
            Object[] objectArray = new TextRange[]{new TextRange(offset, offset + 1L), new TextRange(rIndex, rIndex + 1)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = null;
        }
        return list;
    }

    private final Integer findBalancedRBrace(TextFragmentCharSequence $this$findBalancedRBrace, char openBrace, char closeBrace, int startIndex, int maxSearchLength) {
        int balance = 1;
        int i = 0;
        CharSequence charSequence = (CharSequence)$this$findBalancedRBrace;
        int n = charSequence.length();
        String string = ((Object)charSequence.subSequence(startIndex, n)).toString();
        n = string.length();
        for (int j = 0; j < n; ++j) {
            char c = string.charAt(j);
            ++i;
            char c2 = c;
            if (c2 == closeBrace) {
                --balance;
            } else if (c2 == openBrace) {
                ++balance;
            }
            if (balance == 0) {
                return i + startIndex - 1;
            }
            if (i <= maxSearchLength) continue;
            return null;
        }
        return null;
    }

    private final Integer findBalancedLBrace(TextFragmentCharSequence $this$findBalancedLBrace, char openBrace, char closeBrace, int closeBraceIndex, int maxSearchLength) {
        int balance = -1;
        int i = 0;
        String string = ((Object)StringsKt.reversed((CharSequence)((Object)((CharSequence)$this$findBalancedLBrace).subSequence(0, closeBraceIndex)).toString())).toString();
        int n = string.length();
        for (int j = 0; j < n; ++j) {
            char c = string.charAt(j);
            ++i;
            char c2 = c;
            if (c2 == closeBrace) {
                --balance;
            } else if (c2 == openBrace) {
                ++balance;
            }
            if (balance == 0) {
                return closeBraceIndex - i;
            }
            if (i <= maxSearchLength) continue;
            return null;
        }
        return null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('{'), (Object)Character.valueOf('}')), TuplesKt.to((Object)Character.valueOf('}'), (Object)Character.valueOf('{')), TuplesKt.to((Object)Character.valueOf('('), (Object)Character.valueOf(')')), TuplesKt.to((Object)Character.valueOf(')'), (Object)Character.valueOf('(')), TuplesKt.to((Object)Character.valueOf('['), (Object)Character.valueOf(']')), TuplesKt.to((Object)Character.valueOf(']'), (Object)Character.valueOf('['))};
        bracePairs = MapsKt.mapOf((Pair[])pairArray);
    }
}

