/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.fs;

import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.ProtocolPath;
import fleet.api.Root;
import fleet.common.FsService;
import fleet.common.fs.FsdKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0010\u0010\u0014\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u0010J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lfleet/common/fs/RelativePath;", "", "root", "Lfleet/api/FileAddress;", "components", "", "", "(Lfleet/api/FileAddress;Ljava/util/List;)V", "getComponents", "()Ljava/util/List;", "getRoot", "()Lfleet/api/FileAddress;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "joinToString", "collapseUserHome", "toString", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nFsd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fsd.kt\nfleet/common/fs/RelativePath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class RelativePath {
    @NotNull
    private final FileAddress root;
    @NotNull
    private final List<String> components;

    public RelativePath(@NotNull FileAddress root, @NotNull List<String> components2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(components2, (String)"components");
        this.root = root;
        this.components = components2;
    }

    @NotNull
    public final FileAddress getRoot() {
        return this.root;
    }

    @NotNull
    public final List<String> getComponents() {
        return this.components;
    }

    @NotNull
    public final String joinToString(boolean collapseUserHome) {
        String separator = FsdKt.getSeparator(this.root);
        if (collapseUserHome && !((Collection)this.components).isEmpty() && !(this.root.getPath().getRoot() instanceof Root.Windows)) {
            FileAddress userHome2;
            FileAddress fileAddress;
            FsService fsService2 = FsdKt.fsService(this.root);
            if (fsService2 != null && (fsService2 = fsService2.getUserHome()) != null) {
                FsService it = fsService2;
                boolean bl = false;
                fileAddress = new FileAddress(this.root.getHostId(), (ProtocolPath)it);
            } else {
                fileAddress = null;
            }
            FileAddress fileAddress2 = userHome2 = fileAddress;
            if (Intrinsics.areEqual((Object)this.root, (Object)(fileAddress2 != null ? FileAddressKt.parent((FileAddress)fileAddress2) : null)) && Intrinsics.areEqual((Object)CollectionsKt.first(this.components), (Object)FileAddressKt.getName((FileAddress)userHome2))) {
                return "~" + separator + CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)this.components, (int)1), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
            }
        }
        return CollectionsKt.joinToString$default((Iterable)this.components, (CharSequence)FsdKt.getSeparator(this.root), null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String joinToString$default(RelativePath relativePath, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return relativePath.joinToString(bl);
    }

    @NotNull
    public final FileAddress component1() {
        return this.root;
    }

    @NotNull
    public final List<String> component2() {
        return this.components;
    }

    @NotNull
    public final RelativePath copy(@NotNull FileAddress root, @NotNull List<String> components2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(components2, (String)"components");
        return new RelativePath(root, components2);
    }

    public static /* synthetic */ RelativePath copy$default(RelativePath relativePath, FileAddress fileAddress, List list, int n, Object object) {
        if ((n & 1) != 0) {
            fileAddress = relativePath.root;
        }
        if ((n & 2) != 0) {
            list = relativePath.components;
        }
        return relativePath.copy(fileAddress, list);
    }

    @NotNull
    public String toString() {
        return "RelativePath(root=" + this.root + ", components=" + this.components + ")";
    }

    public int hashCode() {
        int result2 = this.root.hashCode();
        result2 = result2 * 31 + ((Object)this.components).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelativePath)) {
            return false;
        }
        RelativePath relativePath = (RelativePath)other;
        if (!Intrinsics.areEqual((Object)this.root, (Object)relativePath.root)) {
            return false;
        }
        return Intrinsics.areEqual(this.components, relativePath.components);
    }
}

