/*
 * Decompiled with CFR 0.152.
 */
package andel.editor;

import andel.editor.Caret;
import andel.editor.Caret$;
import andel.editor.CaretId;
import andel.editor.CaretPosition;
import andel.editor.MultiCaretData$Serializer$MultiCaretDataData$;
import andel.operation.IntervalPoint;
import andel.operation.NewOffsetProvider;
import andel.operation.Operation;
import andel.operation.OperationKt;
import andel.operation.Sticky;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.util.serialization.DataSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087\b\u0018\u0000 12\u00020\u0001:\u000212BC\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010 \u001a\u00020\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0014\u0010\"\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0013J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003J\u0015\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003JE\u0010*\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00062\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010+\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\u00a8\u00063"}, d2={"Landel/editor/MultiCaretData;", "", "sortedCarets", "", "Landel/editor/Caret;", "caretsById", "", "Landel/editor/CaretId;", "mergedAnchors", "<init>", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "getSortedCarets", "()Ljava/util/List;", "getCaretsById", "()Ljava/util/Map;", "getMergedAnchors", "carets", "getCarets", "resolveAnchor", "", "caretId", "caret", "edit", "operation", "Landel/operation/Operation;", "preserveVcol", "", "newOffsetProvider", "Landel/operation/NewOffsetProvider;", "transformOnto", "direction", "Landel/operation/Sticky;", "addCarets", "caretsToAdd", "removeCarets", "idsToRemove", "", "ensureValidOffsets", "charsCount", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "Serializer", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nMultiCaretData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiCaretData.kt\nandel/editor/MultiCaretData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n+ 5 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,188:1\n1863#2,2:189\n1872#2,3:191\n1863#2,2:195\n1053#2:197\n1557#2:198\n1628#2,2:199\n1630#2:203\n1#3:194\n42#4,2:201\n25#5:204\n*S KotlinDebug\n*F\n+ 1 MultiCaretData.kt\nandel/editor/MultiCaretData\n*L\n61#1:189,2\n81#1:191,3\n109#1:195,2\n112#1:197\n149#1:198\n149#1:199,2\n149#1:203\n157#1:201,2\n13#1:204\n*E\n"})
public final class MultiCaretData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Caret> sortedCarets;
    @NotNull
    private final Map<CaretId, Caret> caretsById;
    @NotNull
    private final Map<CaretId, CaretId> mergedAnchors;
    @NotNull
    private static final KLogger logger;

    public MultiCaretData(@NotNull List<Caret> sortedCarets, @NotNull Map<CaretId, Caret> caretsById, @NotNull Map<CaretId, CaretId> mergedAnchors) {
        Intrinsics.checkNotNullParameter(sortedCarets, (String)"sortedCarets");
        Intrinsics.checkNotNullParameter(caretsById, (String)"caretsById");
        Intrinsics.checkNotNullParameter(mergedAnchors, (String)"mergedAnchors");
        this.sortedCarets = sortedCarets;
        this.caretsById = caretsById;
        this.mergedAnchors = mergedAnchors;
    }

    public /* synthetic */ MultiCaretData(List list, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(list, map, map2);
    }

    @NotNull
    public final List<Caret> getSortedCarets() {
        return this.sortedCarets;
    }

    @NotNull
    public final Map<CaretId, Caret> getCaretsById() {
        return this.caretsById;
    }

    @NotNull
    public final Map<CaretId, CaretId> getMergedAnchors() {
        return this.mergedAnchors;
    }

    @NotNull
    public final List<Caret> getCarets() {
        return CollectionsKt.toList((Iterable)this.sortedCarets);
    }

    public final long resolveAnchor(@NotNull CaretId caretId) {
        Intrinsics.checkNotNullParameter((Object)caretId, (String)"caretId");
        Caret caret = this.caret(caretId);
        if (caret == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return caret.getOffset();
    }

    @Nullable
    public final Caret caret(@NotNull CaretId caretId) {
        Intrinsics.checkNotNullParameter((Object)caretId, (String)"caretId");
        CaretId caretId2 = this.mergedAnchors.get(caretId);
        if (caretId2 == null) {
            caretId2 = caretId;
        }
        return this.caretsById.get(caretId2);
    }

    @NotNull
    public final MultiCaretData edit(@NotNull Operation operation, boolean preserveVcol) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return this.transformOnto(operation, Sticky.LEFT, preserveVcol);
    }

    public static /* synthetic */ MultiCaretData edit$default(MultiCaretData multiCaretData, Operation operation, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return multiCaretData.edit(operation, bl);
    }

    @NotNull
    public final MultiCaretData edit(@NotNull NewOffsetProvider newOffsetProvider) {
        Intrinsics.checkNotNullParameter((Object)newOffsetProvider, (String)"newOffsetProvider");
        ArrayList<Caret> updatingCarets = new ArrayList<Caret>();
        HashMap updatingMap = new HashMap();
        Ref.LongRef lastOffset = new Ref.LongRef();
        lastOffset.element = -1L;
        Ref.LongRef lastShifted = new Ref.LongRef();
        Iterable $this$forEach$iv = this.sortedCarets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Caret caret = (Caret)element$iv;
            boolean bl = false;
            long newSelectionStart = MultiCaretData.edit$mapOffset(lastOffset, lastShifted, newOffsetProvider, caret.getPosition().getSelectionStart());
            Caret newCaret = Caret.move$default(caret, new CaretPosition(MultiCaretData.edit$mapOffset(lastOffset, lastShifted, newOffsetProvider, caret.getOffset()), newSelectionStart, MultiCaretData.edit$mapOffset(lastOffset, lastShifted, newOffsetProvider, caret.getPosition().getSelectionEnd())), null, 2, null);
            updatingCarets.add(newCaret);
            ((Map)updatingMap).put(newCaret.getCaretId(), newCaret);
        }
        return new MultiCaretData((List<Caret>)updatingCarets, updatingMap, this.mergedAnchors);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiCaretData transformOnto(@NotNull Operation operation, @NotNull Sticky direction, boolean preserveVcol) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        ArrayList<Caret> updatingCarets = new ArrayList<Caret>();
        Map updatingMap = new LinkedHashMap();
        ArrayList points = new ArrayList(this.sortedCarets.size() * 3);
        ArrayList<Boolean> caretsAtStart = new ArrayList<Boolean>(this.sortedCarets.size());
        Iterable $this$forEachIndexed$iv = this.sortedCarets;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void caret;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Caret caret2 = (Caret)item$iv;
            int index = n;
            boolean bl = false;
            Pair<List<IntervalPoint<Integer, Unit>>, Boolean> pair = OperationKt.caretToPoints(caret.getPosition(), index);
            List caretPoints = (List)pair.component1();
            boolean caretAtStart = (Boolean)pair.component2();
            points.addAll(caretPoints);
            caretsAtStart.add(caretAtStart);
        }
        List shiftedPoints = OperationKt.shiftPoints2(points, operation, direction);
        int cursor = 0;
        int i = 1;
        int n = shiftedPoints.size();
        if (i <= n) {
            while (true) {
                int cursorId = ((Number)shiftedPoints.get(cursor).getId()).intValue();
                if (i == shiftedPoints.size() || ((Number)shiftedPoints.get(i).getId()).intValue() != cursorId) {
                    Float f;
                    List list = shiftedPoints.subList(cursor, i);
                    Object e = caretsAtStart.get(cursorId);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    CaretPosition updatedPosition = OperationKt.positionByPoints(list, (Boolean)e);
                    Caret it = this.sortedCarets.get(cursorId);
                    boolean bl = false;
                    Float caretAtStart = f = it.getVCol();
                    CaretPosition caretPosition = updatedPosition;
                    Caret caret = it;
                    boolean bl2 = false;
                    boolean bl3 = preserveVcol;
                    Caret updatedCaret = caret.move(caretPosition, bl3 ? f : null);
                    updatingCarets.add(updatedCaret);
                    updatingMap.put(updatedCaret.getCaretId(), updatedCaret);
                    cursor = i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return new MultiCaretData((List<Caret>)updatingCarets, updatingMap, this.mergedAnchors);
    }

    public static /* synthetic */ MultiCaretData transformOnto$default(MultiCaretData multiCaretData, Operation operation, Sticky sticky, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return multiCaretData.transformOnto(operation, sticky, bl);
    }

    @NotNull
    public final MultiCaretData addCarets(@NotNull List<Caret> caretsToAdd) {
        Intrinsics.checkNotNullParameter(caretsToAdd, (String)"caretsToAdd");
        HashMap<CaretId, Caret> updatingMap = new HashMap<CaretId, Caret>(this.caretsById);
        Iterable $this$forEach$iv = caretsToAdd;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Caret c = (Caret)element$iv;
            boolean bl = false;
            ((Map)updatingMap).put(c.getCaretId(), c);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)this.sortedCarets, (Iterable)caretsToAdd);
        boolean $i$f$sortedBy = false;
        List updatedCarets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Caret p0 = (Caret)a;
                boolean $i$f$addCarets$stub_for_inlining = false;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getOffset());
                p0 = (Caret)b;
                Comparable comparable2 = comparable;
                $i$f$addCarets$stub_for_inlining = false;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getOffset()));
            }
        });
        return new MultiCaretData(updatedCarets, (Map<CaretId, Caret>)updatingMap, this.mergedAnchors);
    }

    @NotNull
    public final MultiCaretData removeCarets(@NotNull Collection<CaretId> idsToRemove) {
        HashMap<CaretId, CaretId> hashMap;
        Intrinsics.checkNotNullParameter(idsToRemove, (String)"idsToRemove");
        ArrayList sortedCaretsPrime = new ArrayList(this.sortedCarets);
        HashMap<CaretId, Caret> caretsByIdPrime = new HashMap<CaretId, Caret>(this.caretsById);
        Set idsToRemoveSet = CollectionsKt.toSet((Iterable)idsToRemove);
        for (CaretId caretId : idsToRemove) {
            Caret caret;
            if (caretsByIdPrime.get(caretId) == null) continue;
            boolean bl = false;
            sortedCaretsPrime.remove(caret);
            caretsByIdPrime.remove(caretId);
        }
        HashMap<CaretId, CaretId> $this$removeCarets_u24lambda_u247 = hashMap = new HashMap<CaretId, CaretId>(this.mergedAnchors);
        boolean bl = false;
        for (Map.Entry<CaretId, CaretId> entry : this.mergedAnchors.entrySet()) {
            CaretId key = entry.getKey();
            CaretId value = entry.getValue();
            boolean toRemove = idsToRemoveSet.contains(key) || idsToRemoveSet.contains(value);
            if (!(toRemove || ((Map)caretsByIdPrime).containsKey(value))) {
                boolean bl2 = false;
                String string2 = "caret " + key + " was merged into " + value + " which is now gone";
                throw new IllegalStateException(string2.toString());
            }
            if (!toRemove) continue;
            $this$removeCarets_u24lambda_u247.remove(key);
        }
        HashMap<CaretId, CaretId> mergedAnchorsPrime = hashMap;
        return new MultiCaretData(sortedCaretsPrime, (Map<CaretId, Caret>)caretsByIdPrime, (Map<CaretId, CaretId>)mergedAnchorsPrime);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiCaretData ensureValidOffsets(long charsCount) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getCarets();
        MultiCaretData multiCaretData = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void caret;
            Caret caret2 = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CaretPosition position = caret.getPosition();
            Caret validCaret = Caret.copy$default((Caret)caret, position.copy(RangesKt.coerceIn((long)position.getOffset(), (long)0L, (long)charsCount), RangesKt.coerceIn((long)position.getSelectionStart(), (long)0L, (long)charsCount), RangesKt.coerceIn((long)position.getSelectionEnd(), (long)0L, (long)charsCount)), null, null, 6, null);
            if (!Intrinsics.areEqual((Object)validCaret, (Object)caret)) {
                void this_$iv;
                KLogger kLogger = logger;
                Throwable t$iv = new Throwable();
                boolean $i$f$error = false;
                if (this_$iv.isErrorEnabled()) {
                    Throwable throwable = t$iv;
                    void var18_18 = this_$iv;
                    boolean bl2 = false;
                    String string2 = "Attempted to set caret beyond text range (0, " + charsCount + "): " + (Caret)caret;
                    var18_18.error(throwable, (Object)string2);
                }
            }
            collection.add(validCaret);
        }
        return MultiCaretData.copy$default(multiCaretData, (List)destination$iv$iv, null, null, 6, null);
    }

    @NotNull
    public final List<Caret> component1() {
        return this.sortedCarets;
    }

    @NotNull
    public final Map<CaretId, Caret> component2() {
        return this.caretsById;
    }

    @NotNull
    public final Map<CaretId, CaretId> component3() {
        return this.mergedAnchors;
    }

    @NotNull
    public final MultiCaretData copy(@NotNull List<Caret> sortedCarets, @NotNull Map<CaretId, Caret> caretsById, @NotNull Map<CaretId, CaretId> mergedAnchors) {
        Intrinsics.checkNotNullParameter(sortedCarets, (String)"sortedCarets");
        Intrinsics.checkNotNullParameter(caretsById, (String)"caretsById");
        Intrinsics.checkNotNullParameter(mergedAnchors, (String)"mergedAnchors");
        return new MultiCaretData(sortedCarets, caretsById, mergedAnchors);
    }

    public static /* synthetic */ MultiCaretData copy$default(MultiCaretData multiCaretData, List list, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            list = multiCaretData.sortedCarets;
        }
        if ((n & 2) != 0) {
            map = multiCaretData.caretsById;
        }
        if ((n & 4) != 0) {
            map2 = multiCaretData.mergedAnchors;
        }
        return multiCaretData.copy(list, map, map2);
    }

    @NotNull
    public String toString() {
        return "MultiCaretData(sortedCarets=" + this.sortedCarets + ", caretsById=" + this.caretsById + ", mergedAnchors=" + this.mergedAnchors + ")";
    }

    public int hashCode() {
        int result = ((Object)this.sortedCarets).hashCode();
        result = result * 31 + ((Object)this.caretsById).hashCode();
        result = result * 31 + ((Object)this.mergedAnchors).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultiCaretData)) {
            return false;
        }
        MultiCaretData multiCaretData = (MultiCaretData)other;
        if (!Intrinsics.areEqual(this.sortedCarets, multiCaretData.sortedCarets)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.caretsById, multiCaretData.caretsById)) {
            return false;
        }
        return Intrinsics.areEqual(this.mergedAnchors, multiCaretData.mergedAnchors);
    }

    private static final long edit$mapOffset(Ref.LongRef lastOffset, Ref.LongRef lastShifted, NewOffsetProvider $newOffsetProvider, long offset) {
        if (offset != lastOffset.element) {
            lastOffset.element = offset;
            lastShifted.element = $newOffsetProvider.getNewOffset(offset);
        }
        return lastShifted.element;
    }

    public MultiCaretData() {
        this(null, null, null, 7, null);
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(MultiCaretData.class));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Landel/editor/MultiCaretData$Companion;", "", "<init>", "()V", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "serializer", "Lkotlinx/serialization/KSerializer;", "Landel/editor/MultiCaretData;", "fleet.andel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        @NotNull
        public final KSerializer<MultiCaretData> serializer() {
            return (KSerializer)new Serializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Landel/editor/MultiCaretData$Serializer;", "Lfleet/util/serialization/DataSerializer;", "Landel/editor/MultiCaretData;", "Landel/editor/MultiCaretData$Serializer$MultiCaretDataData;", "<init>", "()V", "fromData", "data", "toData", "value", "MultiCaretDataData", "fleet.andel"})
    @SourceDebugExtension(value={"SMAP\nMultiCaretData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiCaretData.kt\nandel/editor/MultiCaretData$Serializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1202#2,2:189\n1230#2,4:191\n*S KotlinDebug\n*F\n+ 1 MultiCaretData.kt\nandel/editor/MultiCaretData$Serializer\n*L\n22#1:189,2\n22#1:191,4\n*E\n"})
    public static final class Serializer
    extends DataSerializer<MultiCaretData, MultiCaretDataData> {
        public Serializer() {
            super(MultiCaretDataData.Companion.serializer());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public MultiCaretData fromData(@NotNull MultiCaretDataData data) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Iterable $this$associateBy$iv = data.getSortedCarets();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void c;
                Caret caret = (Caret)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(c.getCaretId(), element$iv$iv);
            }
            Map caretsById = destination$iv$iv;
            List<Caret> sortedCarets = data.getSortedCarets();
            Map<CaretId, CaretId> mergedAnchors = data.getMergedCarets();
            return new MultiCaretData(sortedCarets, caretsById, mergedAnchors);
        }

        @NotNull
        public MultiCaretDataData toData(@NotNull MultiCaretData value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new MultiCaretDataData(CollectionsKt.toList((Iterable)value.getSortedCarets()), value.getMergedAnchors());
        }

        @Serializable
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 %2\u00020\u0001:\u0002$%B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tBA\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J/\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Landel/editor/MultiCaretData$Serializer$MultiCaretDataData;", "", "sortedCarets", "", "Landel/editor/Caret;", "mergedCarets", "", "Landel/editor/CaretId;", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Ljava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSortedCarets", "()Ljava/util/List;", "getMergedCarets", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$fleet_andel", "$serializer", "Companion", "fleet.andel"})
        public static final class MultiCaretDataData {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final List<Caret> sortedCarets;
            @NotNull
            private final Map<CaretId, CaretId> mergedCarets;
            @JvmField
            @NotNull
            private static final KSerializer<Object>[] $childSerializers;

            public MultiCaretDataData(@NotNull List<Caret> sortedCarets, @NotNull Map<CaretId, CaretId> mergedCarets) {
                Intrinsics.checkNotNullParameter(sortedCarets, (String)"sortedCarets");
                Intrinsics.checkNotNullParameter(mergedCarets, (String)"mergedCarets");
                this.sortedCarets = sortedCarets;
                this.mergedCarets = mergedCarets;
            }

            @NotNull
            public final List<Caret> getSortedCarets() {
                return this.sortedCarets;
            }

            @NotNull
            public final Map<CaretId, CaretId> getMergedCarets() {
                return this.mergedCarets;
            }

            @NotNull
            public final List<Caret> component1() {
                return this.sortedCarets;
            }

            @NotNull
            public final Map<CaretId, CaretId> component2() {
                return this.mergedCarets;
            }

            @NotNull
            public final MultiCaretDataData copy(@NotNull List<Caret> sortedCarets, @NotNull Map<CaretId, CaretId> mergedCarets) {
                Intrinsics.checkNotNullParameter(sortedCarets, (String)"sortedCarets");
                Intrinsics.checkNotNullParameter(mergedCarets, (String)"mergedCarets");
                return new MultiCaretDataData(sortedCarets, mergedCarets);
            }

            public static /* synthetic */ MultiCaretDataData copy$default(MultiCaretDataData multiCaretDataData, List list, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    list = multiCaretDataData.sortedCarets;
                }
                if ((n & 2) != 0) {
                    map = multiCaretDataData.mergedCarets;
                }
                return multiCaretDataData.copy(list, map);
            }

            @NotNull
            public String toString() {
                return "MultiCaretDataData(sortedCarets=" + this.sortedCarets + ", mergedCarets=" + this.mergedCarets + ")";
            }

            public int hashCode() {
                int result = ((Object)this.sortedCarets).hashCode();
                result = result * 31 + ((Object)this.mergedCarets).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MultiCaretDataData)) {
                    return false;
                }
                MultiCaretDataData multiCaretDataData = (MultiCaretDataData)other;
                if (!Intrinsics.areEqual(this.sortedCarets, multiCaretDataData.sortedCarets)) {
                    return false;
                }
                return Intrinsics.areEqual(this.mergedCarets, multiCaretDataData.mergedCarets);
            }

            @JvmStatic
            public static final /* synthetic */ void write$Self$fleet_andel(MultiCaretDataData self, CompositeEncoder output, SerialDescriptor serialDesc) {
                KSerializer<Object>[] kSerializerArray = $childSerializers;
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.sortedCarets);
                output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.mergedCarets);
            }

            public /* synthetic */ MultiCaretDataData(int seen0, List sortedCarets, Map mergedCarets, SerializationConstructorMarker serializationConstructorMarker) {
                if (3 != (3 & seen0)) {
                    PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Serializer$MultiCaretDataData$$serializer.INSTANCE.getDescriptor());
                }
                this.sortedCarets = sortedCarets;
                this.mergedCarets = mergedCarets;
            }

            public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
                return $childSerializers;
            }

            static {
                KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer((KSerializer)Caret$.serializer.INSTANCE), new LinkedHashMapSerializer(CaretId.Companion.serializer(), CaretId.Companion.serializer())};
                $childSerializers = kSerializerArray;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Landel/editor/MultiCaretData$Serializer$MultiCaretDataData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Landel/editor/MultiCaretData$Serializer$MultiCaretDataData;", "fleet.andel"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final KSerializer<MultiCaretDataData> serializer() {
                    return (KSerializer)Serializer$MultiCaretDataData$$serializer.INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

