/*
 * Decompiled with CFR 0.152.
 */
package andel.editor;

import andel.text.TextRange;
import fleet.util.serialization.DataSerializer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006!"}, d2={"Landel/editor/CaretPosition;", "", "offset", "", "selectionStart", "selectionEnd", "<init>", "(JJJ)V", "(J)V", "getOffset", "()J", "getSelectionStart", "getSelectionEnd", "withoutSelection", "hasSelection", "", "selectionOrNull", "Landel/text/TextRange;", "move", "targetOffset", "expandSelection", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Serializer", "Companion", "fleet.andel"})
public final class CaretPosition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long offset;
    private final long selectionStart;
    private final long selectionEnd;

    public CaretPosition(long offset, long selectionStart, long selectionEnd) {
        this.offset = offset;
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        long l = this.selectionStart;
        long l2 = this.selectionEnd;
        long l3 = this.offset;
        if (!(l <= l3 ? l3 <= l2 : false)) {
            boolean bl = false;
            String string2 = "offset outside of selection: offset=" + this.offset + ", selection=" + this.selectionStart + ".." + this.selectionEnd;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final long getOffset() {
        return this.offset;
    }

    public final long getSelectionStart() {
        return this.selectionStart;
    }

    public final long getSelectionEnd() {
        return this.selectionEnd;
    }

    public CaretPosition(long offset) {
        this(offset, offset, offset);
    }

    @NotNull
    public final CaretPosition withoutSelection() {
        return new CaretPosition(this.offset, this.offset, this.offset);
    }

    public final boolean hasSelection() {
        return this.selectionStart != this.selectionEnd;
    }

    @Nullable
    public final TextRange selectionOrNull() {
        return this.selectionStart < this.selectionEnd ? new TextRange(this.selectionStart, this.selectionEnd) : null;
    }

    @NotNull
    public final CaretPosition move(long targetOffset, boolean expandSelection) {
        return !expandSelection ? new CaretPosition(targetOffset, targetOffset, targetOffset) : (this.offset == this.selectionStart ? new CaretPosition(targetOffset, Math.min(targetOffset, this.selectionEnd), Math.max(targetOffset, this.selectionEnd)) : (this.offset == this.selectionEnd ? new CaretPosition(targetOffset, Math.min(this.selectionStart, targetOffset), Math.max(this.selectionStart, targetOffset)) : new CaretPosition(targetOffset, Math.min(this.offset, targetOffset), Math.max(this.offset, targetOffset))));
    }

    public final long component1() {
        return this.offset;
    }

    public final long component2() {
        return this.selectionStart;
    }

    public final long component3() {
        return this.selectionEnd;
    }

    @NotNull
    public final CaretPosition copy(long offset, long selectionStart, long selectionEnd) {
        return new CaretPosition(offset, selectionStart, selectionEnd);
    }

    public static /* synthetic */ CaretPosition copy$default(CaretPosition caretPosition, long l, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            l = caretPosition.offset;
        }
        if ((n & 2) != 0) {
            l2 = caretPosition.selectionStart;
        }
        if ((n & 4) != 0) {
            l3 = caretPosition.selectionEnd;
        }
        return caretPosition.copy(l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "CaretPosition(offset=" + this.offset + ", selectionStart=" + this.selectionStart + ", selectionEnd=" + this.selectionEnd + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.offset);
        result = result * 31 + Long.hashCode(this.selectionStart);
        result = result * 31 + Long.hashCode(this.selectionEnd);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CaretPosition)) {
            return false;
        }
        CaretPosition caretPosition = (CaretPosition)other;
        if (this.offset != caretPosition.offset) {
            return false;
        }
        if (this.selectionStart != caretPosition.selectionStart) {
            return false;
        }
        return this.selectionEnd == caretPosition.selectionEnd;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Landel/editor/CaretPosition$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Landel/editor/CaretPosition;", "fleet.andel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<CaretPosition> serializer() {
            return (KSerializer)new Serializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Landel/editor/CaretPosition$Serializer;", "Lfleet/util/serialization/DataSerializer;", "Landel/editor/CaretPosition;", "", "", "<init>", "()V", "fromData", "data", "toData", "value", "fleet.andel"})
    public static final class Serializer
    extends DataSerializer<CaretPosition, List<? extends Long>> {
        public Serializer() {
            super(BuiltinSerializersKt.ListSerializer((KSerializer)BuiltinSerializersKt.serializer((LongCompanionObject)LongCompanionObject.INSTANCE)));
        }

        @NotNull
        public CaretPosition fromData(@NotNull List<Long> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            long offset = ((Number)data.get(0)).longValue();
            long selectionStart = ((Number)data.get(1)).longValue();
            long selectionEnd = ((Number)data.get(2)).longValue();
            return new CaretPosition(offset, selectionStart, selectionEnd);
        }

        @NotNull
        public List<Long> toData(@NotNull CaretPosition value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object[] objectArray = new Long[]{value.getOffset(), value.getSelectionStart(), value.getSelectionEnd()};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

