/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.swift.parser;

import fleet.com.intellij.lang.LighterASTNode;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lang.parser.GeneratedParserUtilBase;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.IncorrectOperationException;
import fleet.com.jetbrains.swift.SwiftCompilerSettings;
import fleet.com.jetbrains.swift.SwiftLanguageBundle;
import fleet.com.jetbrains.swift.SwiftParserTypes;
import fleet.com.jetbrains.swift.codeinsight.attributes.SwiftAttributeArgumentDescription;
import fleet.com.jetbrains.swift.codeinsight.attributes.SwiftAttributeDescription;
import fleet.com.jetbrains.swift.codeinsight.attributes.SwiftBuiltInAttributes;
import fleet.com.jetbrains.swift.lexer.SwiftTokenTypes;
import fleet.com.jetbrains.swift.parser.SwiftParser;
import fleet.com.jetbrains.swift.parser.SwiftParserDefinition;
import fleet.com.jetbrains.swift.parser.SwiftRegexParsingUtilKt;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class SwiftParserUtil
extends GeneratedParserUtilBase {
    private static final Key<ArrayDeque<Boolean>> CLOSURE_CHECKER = Key.create((String)"Closure tail checker");
    private static final Key<Boolean> MULTILINE_PARAMETERS_TAG_CHECKER = Key.create((String)"Multiline parameters tag checker");
    private static final Key<ArrayDeque<Integer>> PATTERN_CHECKER = Key.create((String)"pattern count checker");
    private static final Key<Deque<Boolean>> COND_COMPILATION_CHECKER = Key.create((String)"Conditional compilation checker");
    public static final Key<PsiFile> CONTAINING_FILE_KEY = Key.create((String)"CONTAINING_FILE_KEY");
    private static final Pattern LANG_VERSION = Pattern.compile("(swift|compiler)\\((>=|<)(\\d+)(\\.\\d+)?(\\.\\d+)?(\\.\\d+)*\\)");
    private static final Map<IElementType, IElementType> GENERIC_ARGUMENT_PARENTH_BALANCE = Map.of(SwiftParserTypes.R_PAREN, SwiftParserTypes.L_PAREN, SwiftParserTypes.R_CURLY, SwiftParserTypes.L_CURLY, SwiftParserTypes.R_BRACKET, SwiftParserTypes.L_BRACKET, SwiftParserTypes.MORE, SwiftParserTypes.LESS);
    private static final Map<IElementType, IElementType> CLOSURE_PARENTH_BALANCE = Map.of(SwiftParserTypes.R_PAREN, SwiftParserTypes.L_PAREN, SwiftParserTypes.R_CURLY, SwiftParserTypes.L_CURLY, SwiftParserTypes.R_BRACKET, SwiftParserTypes.L_BRACKET);
    private static final TokenSet TOKENS_AFTER_TRAILING_CLOSURE = TokenSet.create((IElementType[])new IElementType[]{SwiftParserTypes.COMMA, SwiftParserTypes.L_CURLY, SwiftParserTypes.DOT, SwiftParserTypes.EXCL, SwiftParserTypes.QUESTION_MARK, SwiftParserTypes.OPERATOR_HEAD, SwiftParserTypes.AS, SwiftParserTypes.IS, SwiftParserTypes.L_PAREN, SwiftParserTypes.COND_IF, SwiftParserTypes.L_BRACKET});
    public static final WhitespacesAndCommentsBinder TRAILING_COMMENTS_BINDER = WhitespacesBinders.trailingCommentsBinder((TokenSet)SwiftTokenTypes.COMMENTS);

    public static boolean parseDelimiterSeparatedList(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser end, @NotNull GeneratedParserUtilBase.Parser item) {
        if (!SwiftParserUtil.notRule(builder, level, end)) {
            return false;
        }
        while (true) {
            if (SwiftParserUtil.peekRule(builder, level, end)) {
                return true;
            }
            if (!SwiftParserUtil.report_error_((PsiBuilder)builder, (boolean)item.parse(builder, level)) && SwiftParserUtil.recoverDelimiterSeparatedList(builder, level, end, item)) continue;
            if (builder.eof() || SwiftParserUtil.peekRule(builder, level, end)) {
                return true;
            }
            if (!SwiftParserUtil.parseDelimiter(builder, level)) break;
        }
        return true;
    }

    private static boolean recoverDelimiterSeparatedList(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser end, @NotNull GeneratedParserUtilBase.Parser item) {
        do {
            builder.advanceLexer();
            if (builder.eof() || builder.getTokenType() == SwiftParserTypes.SEMICOLON || SwiftParserUtil.isLineFeed(builder, level)) {
                return false;
            }
            if (SwiftParserUtil.notRule(builder, level, end)) continue;
            return false;
        } while (SwiftParserUtil.notRule(builder, level, item));
        return true;
    }

    private static boolean notRule(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser end) {
        PsiBuilder.Marker m = SwiftParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)16);
        boolean r = !end.parse(builder, level + 1);
        SwiftParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)m, (boolean)r, (boolean)false, null);
        return r;
    }

    private static boolean peekRule(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser end) {
        PsiBuilder.Marker m = SwiftParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)8);
        boolean r = end.parse(builder, level);
        SwiftParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)m, (boolean)r, (boolean)false, null);
        return r;
    }

    public static boolean parseDelimiter(@NotNull PsiBuilder builder, int i) {
        if (builder.getTokenType() == SwiftParserTypes.SEMICOLON) {
            builder.advanceLexer();
            return true;
        }
        if (builder.eof()) {
            return false;
        }
        if (!SwiftParserUtil.isLineFeed(builder, i)) {
            builder.error(SwiftLanguageBundle.message("delimiter.expected", new Object[0]));
        }
        return true;
    }

    public static boolean dummyIdentifier(@NotNull PsiBuilder builder, int level) {
        String tokenText = builder.getTokenText();
        if (tokenText != null && (tokenText.endsWith("IntellijIdeaRulezzz") || tokenText.startsWith("IntellijIdeaRulezzz"))) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean isLineFeed(@NotNull PsiBuilder builder, int level) {
        if (builder.eof()) {
            return true;
        }
        int steps = 0;
        while (builder.rawLookup(steps - 1) == TokenType.WHITE_SPACE || builder.rawLookup(steps - 1) == SwiftParserTypes.BLOCK_COMMENT || builder.rawLookup(steps - 1) == SwiftParserTypes.EOL_COMMENT_BEGIN) {
            --steps;
        }
        if (builder.rawLookup(steps - 1) == null) {
            return true;
        }
        int start = builder.rawTokenTypeStart(steps);
        int end = builder.getCurrentOffset();
        CharSequence originalText = builder.getOriginalText();
        return StringUtil.contains((CharSequence)originalText, (int)start, (int)end, (char)'\n');
    }

    public static boolean isNotLineFeedWithError(@NotNull PsiBuilder builder, int i) {
        if (SwiftParserUtil.isLineFeed(builder, i)) {
            builder.error(SwiftLanguageBundle.message("line.feed.not.allowed", new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean isLineFeedWithError(@NotNull PsiBuilder builder, int i) {
        if (SwiftParserUtil.eof((PsiBuilder)builder, (int)i)) {
            return true;
        }
        if (!SwiftParserUtil.isLineFeed(builder, i)) {
            builder.error(SwiftLanguageBundle.message("line.feed.expected", new Object[0]));
        }
        return true;
    }

    public static boolean isWhiteSpace(@NotNull PsiBuilder builder, int level) {
        return builder.eof() || builder.rawLookup(-1) == TokenType.WHITE_SPACE || builder.rawLookup(-1) == SwiftParserTypes.BLOCK_COMMENT;
    }

    public static boolean isNotWhiteSpace(@NotNull PsiBuilder builder, int i) {
        if (builder.eof()) {
            return true;
        }
        return !SwiftParserUtil.isWhiteSpace(builder, i);
    }

    public static boolean isWhiteSpaceLeft(@NotNull PsiBuilder builder, int level) {
        if (builder.eof()) {
            return true;
        }
        IElementType prev = builder.rawLookup(-1);
        return prev == null || prev == TokenType.WHITE_SPACE || prev == SwiftParserTypes.BLOCK_COMMENT || prev == SwiftParserTypes.L_PAREN || prev == SwiftParserTypes.L_BRACKET || prev == SwiftParserTypes.L_CURLY || prev == SwiftParserTypes.COMMA || prev == SwiftParserTypes.SEMICOLON || prev == SwiftParserTypes.COLON;
    }

    public static boolean isWhiteSpaceRight(@NotNull PsiBuilder builder, int level) {
        if (builder.eof()) {
            return true;
        }
        IElementType prev = builder.rawLookup(-1);
        if (prev == TokenType.WHITE_SPACE || prev == SwiftParserTypes.BLOCK_COMMENT) {
            return true;
        }
        IElementType next = builder.getTokenType();
        return next == SwiftParserTypes.R_PAREN || next == SwiftParserTypes.R_BRACKET || next == SwiftParserTypes.R_CURLY || next == SwiftParserTypes.COMMA || next == SwiftParserTypes.SEMICOLON || next == SwiftParserTypes.COLON || next == SwiftParserTypes.DOT;
    }

    public static boolean isNotWhiteSpaceLeft(@NotNull PsiBuilder builder, int i) {
        if (builder.eof()) {
            return true;
        }
        return !SwiftParserUtil.isWhiteSpaceLeft(builder, i);
    }

    public static boolean isNotWhiteSpaceRight(@NotNull PsiBuilder builder, int i) {
        return !SwiftParserUtil.isWhiteSpaceRight(builder, i);
    }

    public static boolean isSwift56(@NotNull PsiBuilder builder, int level) {
        return SwiftCompilerSettings.isCompilerVersion(5, 6);
    }

    public static boolean isSwift57(@NotNull PsiBuilder builder, int level) {
        return SwiftCompilerSettings.isCompilerVersion(5, 7);
    }

    public static boolean isSwift6(@NotNull PsiBuilder builder, int level) {
        return SwiftCompilerSettings.isCompilerVersion(6, 0);
    }

    public static boolean printError(@NotNull PsiBuilder builder, int level, @PropertyKey(resourceBundle="messages.SwiftLanguageBundle") @PropertyKey(resourceBundle="messages.SwiftLanguageBundle") String messageKey) {
        builder.error(SwiftLanguageBundle.message(messageKey, new Object[0]));
        return true;
    }

    public static boolean parseOrError(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser rule, @PropertyKey(resourceBundle="messages.SwiftLanguageBundle") @PropertyKey(resourceBundle="messages.SwiftLanguageBundle") String messageKey) {
        if (!rule.parse(builder, level)) {
            builder.error(SwiftLanguageBundle.message(messageKey, new Object[0]));
        }
        return true;
    }

    public static boolean parseUnclosedRegex(@NotNull PsiBuilder builder, int level) {
        return SwiftRegexParsingUtilKt.parseUnclosedRegex(builder);
    }

    public static boolean parseAsError(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser rule, @PropertyKey(resourceBundle="messages.SwiftLanguageBundle") @PropertyKey(resourceBundle="messages.SwiftLanguageBundle") String messageKey) {
        PsiBuilder.Marker marker = builder.mark();
        boolean result = rule.parse(builder, level);
        if (result) {
            marker.error(SwiftLanguageBundle.message(messageKey, new Object[0]));
        } else {
            marker.rollbackTo();
        }
        return result;
    }

    @NotNull
    private static ArrayDeque<Boolean> getClosureChecker(@NotNull PsiBuilder builder) {
        ArrayDeque<Boolean> data = (ArrayDeque<Boolean>)builder.getUserData(CLOSURE_CHECKER);
        if (data == null) {
            data = new ArrayDeque<Boolean>();
            data.push(Boolean.TRUE);
            builder.putUserData(CLOSURE_CHECKER, data);
        }
        return data;
    }

    public static boolean isMultilineParametersTagPresent(@NotNull PsiBuilder builder, int i) {
        Boolean data = (Boolean)builder.getUserData(MULTILINE_PARAMETERS_TAG_CHECKER);
        if (data == null) {
            data = Boolean.FALSE;
            builder.putUserData(MULTILINE_PARAMETERS_TAG_CHECKER, (Object)Boolean.FALSE);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doWithClosureDeprioritized(@NotNull PsiBuilder builder, int i, @NotNull GeneratedParserUtilBase.Parser p) {
        try {
            SwiftParserUtil.getClosureChecker(builder).push(Boolean.FALSE);
            boolean bl = p.parse(builder, i);
            return bl;
        }
        finally {
            SwiftParserUtil.finishBlock(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doWithClosureAllowed(@NotNull PsiBuilder builder, int i, @NotNull GeneratedParserUtilBase.Parser p) {
        try {
            SwiftParserUtil.getClosureChecker(builder).push(Boolean.TRUE);
            boolean bl = p.parse(builder, i);
            return bl;
        }
        finally {
            SwiftParserUtil.finishBlock(builder);
        }
    }

    public static boolean setMultilineParametersTagPresent(@NotNull PsiBuilder builder, int i) {
        builder.putUserData(MULTILINE_PARAMETERS_TAG_CHECKER, (Object)Boolean.TRUE);
        return true;
    }

    public static boolean resetMultilineParametersTagPresent(@NotNull PsiBuilder builder, int i) {
        builder.putUserData(MULTILINE_PARAMETERS_TAG_CHECKER, (Object)Boolean.FALSE);
        return true;
    }

    private static void finishBlock(@NotNull PsiBuilder builder) {
        SwiftParserUtil.getClosureChecker(builder).pop();
    }

    public static boolean isClosureAllowed(@NotNull PsiBuilder builder, int i) {
        Boolean value = Objects.requireNonNull(SwiftParserUtil.getClosureChecker(builder).peek());
        if (value.booleanValue()) {
            return true;
        }
        if (builder.getTokenType() != SwiftParserTypes.L_CURLY) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        boolean isLineFeed = SwiftParserUtil.isLineFeed(builder, i);
        marker.rollbackTo();
        if (isLineFeed) {
            return false;
        }
        return SwiftParserUtil.checkCommaOrCallChainOrCodeBlockExistsAfterClosure(builder);
    }

    private static boolean checkCommaOrCallChainOrCodeBlockExistsAfterClosure(@NotNull PsiBuilder builder) {
        return SwiftParserUtil.checkParenthBalance(builder, SwiftParserTypes.L_CURLY, CLOSURE_PARENTH_BALANCE, null, b -> TOKENS_AFTER_TRAILING_CLOSURE.contains(b.getTokenType()));
    }

    public static boolean no_closure_tail_after_literal(@NotNull PsiBuilder builder, int level) {
        LighterASTNode lastMarker = builder.getLatestDoneMarker();
        return lastMarker == null || lastMarker.getTokenType() != SwiftParserTypes.LITERAL_EXPRESSION;
    }

    public static boolean checkParenthBalanceAndTailForGenericArgs(@NotNull PsiBuilder builder, int i) {
        return SwiftParserUtil.checkParenthBalance(builder, SwiftParserTypes.LESS, GENERIC_ARGUMENT_PARENTH_BALANCE, (b, token) -> {
            if (token == SwiftParserTypes.MINUS && b.getTokenType() == SwiftParserTypes.MORE) {
                b.advanceLexer();
            }
        }, b -> {
            if (b.eof()) {
                return false;
            }
            if (SwiftParser.ws(b, i + 1) && SwiftParser.op_char(b, i + 1)) {
                return false;
            }
            IElementType tokenType = b.getTokenType();
            return tokenType == SwiftParserTypes.L_PAREN || tokenType == SwiftParserTypes.R_PAREN || tokenType == SwiftParserTypes.L_BRACKET || tokenType == SwiftParserTypes.R_BRACKET || tokenType == SwiftParserTypes.L_CURLY || tokenType == SwiftParserTypes.R_CURLY || tokenType == SwiftParserTypes.QUESTION_MARK || tokenType == SwiftParserTypes.EXCL || tokenType == SwiftParserTypes.DOT;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkParenthBalance(@NotNull PsiBuilder builder, @NotNull IElementType firstParenth, @NotNull Map<IElementType, IElementType> parenthPairs, @Nullable BiConsumer<? super PsiBuilder, ? super IElementType> additionalActions, @NotNull Predicate<? super PsiBuilder> condition) {
        if (builder.getTokenType() != firstParenth) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        try {
            ArrayDeque<IElementType> stack = new ArrayDeque<IElementType>();
            stack.push(builder.getTokenType());
            builder.advanceLexer();
            while (!stack.isEmpty() && !builder.eof()) {
                IElementType token = builder.getTokenType();
                builder.advanceLexer();
                if (parenthPairs.containsValue(token)) {
                    stack.push(token);
                    continue;
                }
                if (parenthPairs.containsKey(token)) {
                    if (stack.pop() == parenthPairs.get(token)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (additionalActions == null) continue;
                additionalActions.accept((PsiBuilder)builder, (IElementType)token);
            }
            boolean bl = stack.isEmpty() && condition.test((PsiBuilder)builder);
            return bl;
        }
        finally {
            marker.rollbackTo();
        }
    }

    public static boolean isCorrectIdentifier(@NotNull String name) {
        Lexer lexer = SwiftParserDefinition.getLexer();
        lexer.start((CharSequence)name);
        if (lexer.getTokenType() != SwiftParserTypes.IDENTIFIER) {
            return false;
        }
        lexer.advance();
        if (lexer.getTokenType() != null) {
            return false;
        }
        if (name.startsWith("`") || name.endsWith("`")) {
            return name.startsWith("`") && name.endsWith("`") && name.length() > 2;
        }
        return true;
    }

    public static boolean consumeOneToken(@NotNull PsiBuilder builder, int level) {
        if (builder.eof()) {
            return false;
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        mark.error(SwiftLanguageBundle.message("statement.expected", new Object[0]));
        return true;
    }

    public static boolean consumeAttributes(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser attributesParser) {
        if (builder.eof()) {
            return false;
        }
        if (attributesParser.parse(builder, level)) {
            PsiBuilder.Marker mark = builder.mark();
            mark.error(SwiftLanguageBundle.message("declaration.expected", new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean isBuiltInAttribute(@NotNull PsiBuilder builder, int level) {
        if (builder.getTokenType() != SwiftParserTypes.IDENTIFIER) {
            return false;
        }
        String identifier = builder.getTokenText();
        return identifier != null && SwiftBuiltInAttributes.contains(identifier);
    }

    public static boolean checkNotInExpressionPattern(@NotNull PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        GeneratedParserUtilBase.Frame binaryFrame = SwiftParserUtil.findTopMostBinaryExpression(state.currentFrame);
        if (binaryFrame == null) {
            return true;
        }
        GeneratedParserUtilBase.Frame expression = binaryFrame.parentFrame;
        if (expression == null || !SwiftParserUtil.nameEquals(expression, "<expression>")) {
            return true;
        }
        return expression.parentFrame == null || !SwiftParserUtil.nameEquals(expression.parentFrame, "<expression pattern>");
    }

    private static boolean nameEquals(@Nullable GeneratedParserUtilBase.Frame frame, @NonNls @NotNull String name) {
        return frame != null && name.equals(frame.name);
    }

    public static boolean checkIsInsideValueBinding(@NotNull PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        return SwiftParserUtil.findParent(state.currentFrame, "<value binding pattern>") != null || SwiftParserUtil.findParent(state.currentFrame, "<try await for in pattern>") != null || SwiftParserUtil.findParent(state.currentFrame, "<plain for in pattern>") != null;
    }

    public static boolean isAsOperatorInPattern(@NotNull PsiBuilder builder, int level) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        GeneratedParserUtilBase.Frame frame = SwiftParserUtil.findTopMostBinaryExpression(state.currentFrame);
        assert (frame != null) : "'as' operator can appear only inside binary expression";
        GeneratedParserUtilBase.Frame patternFrame = SwiftParserUtil.getSuperParent(frame, "<expression>", "<expression pattern>", "<pattern>");
        if (patternFrame == null) {
            return false;
        }
        GeneratedParserUtilBase.Frame parentFrame = patternFrame.parentFrame;
        if (parentFrame == null) {
            return false;
        }
        if (SwiftParserUtil.nameEquals(parentFrame, "<case item>")) {
            return true;
        }
        if (SwiftParserUtil.nameEquals(parentFrame, "<catch item>")) {
            return true;
        }
        if (SwiftParserUtil.nameEquals(parentFrame, "<tuple pattern item>")) {
            return true;
        }
        if (SwiftParserUtil.getSuperParent(patternFrame, null, "<condition>", "<condition clause>") != null) {
            return true;
        }
        return SwiftParserUtil.getSuperParent(patternFrame, null, "<pattern>") != null;
    }

    @Nullable
    private static GeneratedParserUtilBase.Frame findParent(@NotNull GeneratedParserUtilBase.Frame frame, @NonNls @NotNull String frameName) {
        GeneratedParserUtilBase.Frame parent = frame.parentFrame;
        while (parent != null) {
            if (SwiftParserUtil.nameEquals(parent, frameName)) {
                return parent;
            }
            parent = parent.parentFrame;
        }
        return null;
    }

    @Nullable
    private static GeneratedParserUtilBase.Frame findTopMostBinaryExpression(@NotNull GeneratedParserUtilBase.Frame frame) {
        GeneratedParserUtilBase.Frame parent;
        while (true) {
            if ((parent = frame.parentFrame) == null) {
                throw new IncorrectOperationException("null parent");
            }
            if (parent.name != null && !SwiftParserUtil.nameEquals(parent, "<as operator>") && !SwiftParserUtil.nameEquals(parent, "<as expression>") && !SwiftParserUtil.nameEquals(parent, "<binary expression>") && !SwiftParserUtil.nameEquals(parent, "<is expression>")) break;
            frame = parent;
        }
        if (SwiftParserUtil.nameEquals(parent, "<expression>")) {
            return frame;
        }
        if (SwiftParserUtil.nameEquals(parent, "<try expression>") || SwiftParserUtil.nameEquals(parent, "<complex operator expression>")) {
            return parent;
        }
        if (SwiftParserUtil.nameEquals(parent, "<binary operator prefix>")) {
            return parent.parentFrame.parentFrame;
        }
        throw new IncorrectOperationException("Unknown parent: " + parent.name);
    }

    @Nullable
    private static GeneratedParserUtilBase.Frame getSuperParent(@NotNull GeneratedParserUtilBase.Frame frame, String ... parentSequence) {
        GeneratedParserUtilBase.Frame parentFrame = frame;
        for (String parent : parentSequence) {
            parentFrame = parentFrame.parentFrame;
            if (parentFrame == null) {
                return null;
            }
            if (Objects.equals(parentFrame.name, parent)) continue;
            return null;
        }
        return parentFrame;
    }

    public static boolean doCountingPatterns(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser parser) {
        SwiftParserUtil.getPatternChecker(builder).push(0);
        boolean parsed = parser.parse(builder, level + 1);
        Integer patternCount = SwiftParserUtil.getPatternChecker(builder).pop();
        return parsed && patternCount > 0;
    }

    public static boolean doWithoutCountingPatterns(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser parser) {
        SwiftParserUtil.getPatternChecker(builder).push(0);
        boolean parsed = parser.parse(builder, level + 1);
        SwiftParserUtil.getPatternChecker(builder).pop();
        return parsed;
    }

    public static boolean incPatternCount(@NotNull PsiBuilder builder, int level) {
        ArrayDeque<Integer> checker = SwiftParserUtil.getPatternChecker(builder);
        if (!checker.isEmpty()) {
            checker.push(checker.pop() + 1);
        }
        return true;
    }

    @NotNull
    private static ArrayDeque<Integer> getPatternChecker(@NotNull PsiBuilder builder) {
        ArrayDeque data = (ArrayDeque)builder.getUserData(PATTERN_CHECKER);
        if (data == null) {
            data = new ArrayDeque();
            builder.putUserData(PATTERN_CHECKER, data);
        }
        return data;
    }

    public static boolean shouldConditionallyParse(@NotNull PsiBuilder builder, int level) {
        Deque<Boolean> checker = SwiftParserUtil.getConditionalCompilationChecker(builder);
        return Boolean.FALSE != checker.getFirst();
    }

    public static boolean popConditionallyParse(@NotNull PsiBuilder builder, int level) {
        SwiftParserUtil.getConditionalCompilationChecker(builder).pop();
        return true;
    }

    public static boolean flipConditionallyParse(@NotNull PsiBuilder builder, int level) {
        Deque<Boolean> checker = SwiftParserUtil.getConditionalCompilationChecker(builder);
        Boolean current = checker.pop();
        if (current != null) {
            current = current == false;
        }
        checker.push(current);
        return true;
    }

    public static boolean checkDirectiveCondition(@NotNull PsiBuilder builder, int level) {
        Deque<Boolean> checker = SwiftParserUtil.getConditionalCompilationChecker(builder);
        LighterASTNode astNode = builder.getLatestDoneMarker();
        if (astNode != null) {
            Matcher matcher;
            String value = astNode.toString().replaceAll("\\s+", "");
            int start = 0;
            int finish = value.length();
            boolean invertResult = false;
            while (start < finish) {
                if (value.charAt(start) == '(' && value.charAt(finish - 1) == ')') {
                    ++start;
                    --finish;
                    continue;
                }
                if (value.charAt(start) != '!') break;
                ++start;
                invertResult = !invertResult;
            }
            if ((matcher = LANG_VERSION.matcher(value.substring(start, finish))).matches()) {
                PsiFile file = (PsiFile)builder.getUserData(CONTAINING_FILE_KEY);
                try {
                    String kind = matcher.group(1);
                    String comparison = matcher.group(2);
                    int major = Integer.parseInt(matcher.group(3));
                    int minor = SwiftParserUtil.parseMinorVersion(matcher.group(4));
                    int bugfix = SwiftParserUtil.parseMinorVersion(matcher.group(5));
                    Object version = "compiler".equals(kind) ? SwiftCompilerSettings.getCompilerVersion() : (file != null ? SwiftCompilerSettings.getCompilerVersion() : null);
                    if (version != null) {
                        if (!">=".equals(comparison)) {
                            invertResult = !invertResult;
                        }
                        boolean result = version.isOrGreaterThan(Integer.valueOf(major), Integer.valueOf(minor), Integer.valueOf(bugfix));
                        if (invertResult) {
                            result = !result;
                        }
                        checker.push(result);
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        checker.push(null);
        return true;
    }

    public static int parseMinorVersion(String minorString) {
        return minorString == null ? 0 : Integer.parseInt(minorString.substring(1));
    }

    @NotNull
    private static Deque<Boolean> getConditionalCompilationChecker(@NotNull PsiBuilder builder) {
        LinkedList deque = (LinkedList)builder.getUserData(COND_COMPILATION_CHECKER);
        if (deque == null) {
            deque = new LinkedList();
            builder.putUserData(COND_COMPILATION_CHECKER, deque);
        }
        return deque;
    }

    public static boolean anyToken(@NotNull PsiBuilder builder, int level) {
        if (builder.eof()) {
            return false;
        }
        builder.advanceLexer();
        return true;
    }

    public static boolean parseBlockLazy(@NotNull PsiBuilder builder, int level) {
        return PsiBuilderUtil.parseBlockLazy((PsiBuilder)builder, (IElementType)SwiftParserTypes.L_CURLY, (IElementType)SwiftParserTypes.R_CURLY, (IElementType)SwiftParserTypes.LAZY_CODE_BLOCK) != null;
    }

    public static boolean parseTypeElementWithAttributes(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser p) {
        if (!SwiftParserUtil.isTypeAttributeStart(builder)) {
            return p.parse(builder, level + 1);
        }
        PsiBuilder.Marker marker = builder.mark();
        SwiftParser.type_attributes(builder, level + 1);
        boolean parsed = p.parse(builder, level + 1);
        if (!parsed) {
            marker.rollbackTo();
            return false;
        }
        LighterASTNode latestDoneMarker = builder.getLatestDoneMarker();
        assert (latestDoneMarker != null);
        IElementType tokenType = latestDoneMarker.getTokenType();
        ((PsiBuilder.Marker)latestDoneMarker).drop();
        marker.done(tokenType);
        return true;
    }

    public static boolean attributeNeedsParentheses(@NotNull PsiBuilder builder, int level) {
        if (builder.getTokenType() != SwiftParserTypes.IDENTIFIER) {
            return false;
        }
        String identifier = builder.getTokenText();
        if (identifier == null) {
            return false;
        }
        SwiftAttributeDescription attribute = SwiftBuiltInAttributes.findAttribute(identifier);
        if (attribute == null) {
            return false;
        }
        SwiftAttributeArgumentDescription arguments = attribute.getArguments();
        if (arguments == null) {
            return false;
        }
        return !attribute.getArguments().isOptional();
    }

    public static boolean isTypeAttributeStart(@NotNull PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (SwiftParserTypes.IDENTIFIER.equals(tokenType)) {
            String identifier = builder.getTokenText();
            return "__owned".equals(identifier) || "__shared".equals(identifier);
        }
        return SwiftParserTypes.AT.equals(tokenType);
    }

    public static boolean checkInKeywordExistsFast(@NotNull PsiBuilder builder, int level) {
        PsiBuilder.Marker marker = builder.mark();
        try {
            ArrayDeque<IElementType> parenthStack = new ArrayDeque<IElementType>();
            while (true) {
                if (builder.eof()) {
                    boolean bl = false;
                    return bl;
                }
                IElementType token = builder.getTokenType();
                builder.advanceLexer();
                if (token == SwiftParserTypes.IN) {
                    boolean bl = parenthStack.isEmpty();
                    return bl;
                }
                if (token == SwiftParserTypes.L_PAREN || token == SwiftParserTypes.L_BRACKET || token == SwiftParserTypes.L_CURLY) {
                    parenthStack.push(token);
                    continue;
                }
                if (token == SwiftParserTypes.R_PAREN) {
                    if (!parenthStack.isEmpty() && parenthStack.pop() == SwiftParserTypes.L_PAREN) continue;
                    boolean bl = false;
                    return bl;
                }
                if (token == SwiftParserTypes.R_BRACKET) {
                    if (!parenthStack.isEmpty() && parenthStack.pop() == SwiftParserTypes.L_BRACKET) continue;
                    boolean bl = false;
                    return bl;
                }
                if (token != SwiftParserTypes.R_CURLY || !parenthStack.isEmpty() && parenthStack.pop() == SwiftParserTypes.R_CURLY) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            marker.rollbackTo();
        }
    }
}

