/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.lang.javascript.DialectOptionHolder;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.JavaScriptBundle;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParser;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.PropertyKey;

public class JavaScriptParserBase<T extends JavaScriptParser> {
    public static final Key<ForceContext> FORCE_CONTEXT_KEY = Key.create((String)"FORCE_CONTEXT");
    public static int MAX_TREE_DEPTH = 100;
    protected final PsiBuilder builder;
    protected final T myJavaScriptParser;
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT = new JSDocBinder(true);
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK = new JSDocBinder(false);

    protected JavaScriptParserBase(T parser) {
        this.builder = ((JavaScriptParser)parser).builder;
        this.myJavaScriptParser = parser;
    }

    public static boolean hasLineTerminatorBefore(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.OR_RBRACE) {
            return true;
        }
        return JavaScriptParserBase.hasLineTerminator(builder, -1);
    }

    public static boolean hasLineTerminatorAfter(PsiBuilder builder) {
        return JavaScriptParserBase.hasLineTerminator(builder, 1);
    }

    static boolean hasLineTerminator(PsiBuilder builder, int at) {
        IElementType boundElementType = builder.rawLookup(at);
        while (boundElementType == JSTokenTypes.WHITE_SPACE || boundElementType == JSTokenTypes.HEREDOC_BOUND || JSTokenTypes.COMMENTS.contains(boundElementType)) {
            int end = builder.rawTokenTypeStart(at + 1);
            CharSequence sequence = builder.getOriginalText();
            for (int start = builder.rawTokenTypeStart(at); start < end; ++start) {
                char ch = sequence.charAt(start);
                if (ch != '\n' && ch != '\u2028' && ch != '\u2029' && ch != '\r') continue;
                return true;
            }
            at = at < 0 ? --at : ++at;
            boundElementType = builder.rawLookup(at);
        }
        return false;
    }

    public static boolean checkMatches(PsiBuilder builder, IElementType token, @NonNls @PropertyKey(resourceBundle="messages.JavaScriptBundle") @NonNls @PropertyKey(resourceBundle="messages.JavaScriptBundle") String errorMessageKey) {
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
            return true;
        }
        builder.error(JavaScriptBundle.message(errorMessageKey, new Object[0]));
        return false;
    }

    protected boolean isECMAL4() {
        return ((JavaScriptParser)this.myJavaScriptParser).getDialect().isECMA4;
    }

    protected boolean isECMA6() {
        return ((JavaScriptParser)this.myJavaScriptParser).getDialect().isECMA6;
    }

    protected boolean isJavaScript() {
        return ((JavaScriptParser)this.myJavaScriptParser).getDialect().isJavaScript();
    }

    protected boolean isJSorTS() {
        DialectOptionHolder dialect = ((JavaScriptParser)this.myJavaScriptParser).getDialect();
        return dialect.isJavaScript() || dialect.isTypeScript;
    }

    protected boolean isIdentifierToken(IElementType tokenType) {
        if (tokenType == JSTokenTypes.IDENTIFIER || tokenType == JSTokenTypes.PRIVATE_IDENTIFIER) {
            return true;
        }
        return ((JavaScriptParser)this.myJavaScriptParser).isIdentifierToken(tokenType);
    }

    protected CharSequence getTokenCharSequence() {
        return this.builder.eof() ? null : PsiBuilderUtil.rawTokenText((PsiBuilder)this.builder, (int)0);
    }

    private static final class JSDocBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAllowExtraLineBreak;

        private JSDocBinder(boolean allowExtraLineBreak) {
            this.myAllowExtraLineBreak = allowExtraLineBreak;
        }

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            CharSequence tokenText;
            IElementType type;
            int i = tokens.size() - 1;
            IElementType iElementType = type = i >= 0 ? tokens.get(i) : null;
            while (!(type != JSTokenTypes.WHITE_SPACE && type != JSTokenTypes.END_OF_LINE_COMMENT || !this.myAllowExtraLineBreak && type == JSTokenTypes.WHITE_SPACE && (tokenText = getter.get(i)).chars().filter(c -> c == 10).count() > 1L)) {
                type = --i >= 0 ? tokens.get(i) : null;
            }
            if (type == JSTokenTypes.DOC_COMMENT) {
                return i;
            }
            return tokens.size();
        }
    }

    public static enum ForceContext {
        Type,
        TypeAllowEmpty,
        Parameter;

    }
}

