/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript;

import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.LanguageUtil;
import fleet.com.intellij.lang.ParserDefinition;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lang.javascript.DialectOptionHolder;
import fleet.com.intellij.lang.javascript.JSFileElementTypes;
import fleet.com.intellij.lang.javascript.JSFlexAdapter;
import fleet.com.intellij.lang.javascript.JSParser;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.FileViewProvider;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.PsiWhiteSpace;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JavascriptParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        return new JSFlexAdapter(DialectOptionHolder.JS_WITH_JSX);
    }

    public IFileElementType getFileNodeType() {
        return JSFileElementTypes.FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return JSTokenTypes.PARSER_WHITE_SPACE_TOKENS;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return JSTokenTypes.COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return JSTokenTypes.STRING_LITERALS;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new JSParser();
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        throw new IllegalStateException();
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (left instanceof PsiWhiteSpace) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (left.getElementType() == JSTokenTypes.BACKQUOTE) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        Lexer lexer = this.createLexer(null);
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        throw new IllegalStateException();
    }
}

