/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.ecmascript6.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lang.ecmascript6.ES6StubElementTypes;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6Parser;
import fleet.com.intellij.lang.javascript.JSKeywordSets;
import fleet.com.intellij.lang.javascript.JSStubElementTypes;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.JavaScriptBundle;
import fleet.com.intellij.lang.javascript.parsing.ExpressionParser;
import fleet.com.intellij.lang.javascript.parsing.FunctionParser;
import fleet.com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import fleet.com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import fleet.com.intellij.lang.javascript.parsing.StatementParser;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import fleet.com.intellij.lang.typescript.TypeScriptStubElementTypes;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6StatementParser<P extends ES6Parser<?, ?, ?, ?>>
extends StatementParser<P> {
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE = new JSOrderedModifiersStructure(new JSOneOfModifiersStructure(JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PUBLIC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.STATIC_KEYWORD, JSTokenTypes.ASYNC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.ASYNC_KEYWORD, JSTokenTypes.STATIC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.ACCESSOR_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.MULT));
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START = builder -> {
        IElementType token = builder.getTokenType();
        return JSKeywordSets.PROPERTY_NAMES.contains(token) || token == JSTokenTypes.MULT || token == JSTokenTypes.LBRACKET;
    };

    public ES6StatementParser(P parser) {
        super(parser);
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        if (this.builder.getTokenType() == JSTokenTypes.ENUM_KEYWORD) {
            this.parseEnumNoMarker(marker);
            return true;
        }
        return false;
    }

    @Deprecated
    public void parseSourceElement() {
        this.parseStatement();
    }

    @Override
    public void parseStatement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.ENUM_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseEnumNoMarker(marker);
            return;
        }
        if (tokenType == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.LPAR && this.builder.lookAhead(1) != JSTokenTypes.DOT) {
            this.parseES6ImportStatement();
            return;
        }
        if (tokenType == JSTokenTypes.EXPORT_KEYWORD && this.tryParseES6ExportStatement()) {
            return;
        }
        super.parseStatement();
    }

    protected void parseEnumNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.ENUM_KEYWORD);
        this.builder.advanceLexer();
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                marker.done((IElementType)JSStubElementTypes.TYPESCRIPT_ENUM);
                return;
            }
        }
        if (!ES6StatementParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            marker.done((IElementType)JSStubElementTypes.TYPESCRIPT_ENUM);
            return;
        }
        PsiBuilder.Marker varStatement = this.builder.mark();
        boolean isDeclarationEmpty = true;
        while (!this.builder.eof() && this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (ES6StatementParser.isPropertyNameStart(this.builder.getTokenType())) {
                PsiBuilder.Marker var = this.builder.mark();
                ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
                if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                    this.parseVariableInitializer(false);
                }
                var.done((IElementType)TypeScriptStubElementTypes.TYPESCRIPT_ENUM_FIELD);
                var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                isDeclarationEmpty = false;
                if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
                this.builder.advanceLexer();
                continue;
            }
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
            this.builder.advanceLexer();
            break;
        }
        if (isDeclarationEmpty) {
            varStatement.drop();
        } else {
            varStatement.done((IElementType)TypeScriptStubElementTypes.ENUM_FIELD_STATEMENT);
            varStatement.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.trailingCommentsBinder((TokenSet)JSTokenTypes.END_OF_LINE_COMMENTS));
        }
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
        }
        ES6StatementParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        marker.done((IElementType)JSStubElementTypes.TYPESCRIPT_ENUM);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseClassMember() {
        if (this.parseStaticBlock()) {
            return;
        }
        PsiBuilder.Marker classMember = this.builder.mark();
        int classMemberOffset = this.builder.getCurrentOffset();
        if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
            classMember.drop();
            this.parseEmptyStatement();
            return;
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults = this.parseClassMemberModifiers();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiersParseResults, this.builder);
        this.parseStandardClassMember(classMember, modifiersParseResults);
        JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        assert (this.builder.getCurrentOffset() > classMemberOffset);
    }

    protected void parseStandardClassMember(PsiBuilder.Marker classMember, @NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults) {
        if (((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).isPropertyNameStart(this.builder.getTokenType())) {
            this.parseNamedClassMember(classMember, modifiersParseResults);
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            if (!modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED)) {
                this.builder.advanceLexer();
            }
            classMember.drop();
        }
    }

    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseClassMemberModifiers() {
        return ((ES6Parser)this.myJavaScriptParser).parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
    }

    protected boolean parseStaticBlock() {
        if (this.builder.getTokenType() == JSTokenTypes.STATIC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker marker = this.builder.mark();
            PsiBuilder.Marker attributeList = this.builder.mark();
            this.builder.advanceLexer();
            attributeList.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
            this.parseBlock();
            marker.done((IElementType)ES6StubElementTypes.STATIC_BLOCK);
            return true;
        }
        return false;
    }

    protected void parseNamedClassMember(@NotNull PsiBuilder.Marker classMember, @NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiersParseResults) {
        boolean shouldBeFunc;
        IElementType lookahead = this.builder.lookAhead(1);
        PsiBuilder.Marker mark = this.builder.mark();
        boolean skipName = false;
        IElementType nextToken = this.builder.getTokenType();
        boolean bl = shouldBeFunc = !(nextToken != JSTokenTypes.LBRACKET && !this.isIdentifierToken(nextToken) && !JSKeywordSets.PROPERTY_NAMES.contains(nextToken) && !JSTokenTypes.LITERALS.contains(nextToken) || !modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND) && !modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND) && !modifiersParseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.GET_SET_FOUND));
        if (nextToken == JSTokenTypes.LBRACKET) {
            this.parseMemberPropertyWithBrackets();
            skipName = true;
            lookahead = this.builder.getTokenType();
        }
        if (this.isPossibleMemberFunctionStart(lookahead) || shouldBeFunc) {
            mark.drop();
            EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiersParseResults, this.builder);
            this.parseMemberFunction(classMember, skipName);
            JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        } else {
            this.parseMemberVariable(mark, classMember, skipName);
        }
    }

    protected IElementType getFieldStatementElementType() {
        return ES6StubElementTypes.FIELD_STATEMENT;
    }

    protected void parseMemberPropertyWithBrackets() {
        ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
    }

    protected boolean isPossibleMemberFunctionStart(IElementType lookahead) {
        return JSTokenTypes.LPAR == lookahead || JSTokenTypes.LT == lookahead;
    }

    protected void parseMemberFunction(PsiBuilder.Marker classMember, boolean skipName) {
        if (!skipName) {
            this.parserMemberFunctionName();
        }
        ES6FunctionParser functionParser = (ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser();
        functionParser.parseParameterList(false);
        ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            ((ES6StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).parseFunctionBody();
        } else {
            this.checkMemberFunctionSuffix();
        }
        this.checkForSemicolon();
        classMember.done(functionParser.getFunctionDeclarationElementType());
        classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected boolean parserMemberFunctionName() {
        boolean nameParsed = ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseFunctionName(true, FunctionParser.Context.PROPERTY);
        if (!nameParsed) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.function.name", new Object[0]));
            return false;
        }
        return true;
    }

    protected void checkMemberFunctionSuffix() {
        ES6StatementParser.checkMatches(this.builder, JSTokenTypes.SEMICOLON, "javascript.parser.message.expected.lbrace.or.semicolon");
    }

    protected void parseMemberVariable(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PsiBuilder.Marker var, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PsiBuilder.Marker classMember, boolean skipName) {
        if (!skipName) {
            this.parseMemberVariableName();
        }
        ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.parseVariableInitializer(true);
        }
        var.done(this.getFieldElementType());
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.forceCheckForSemicolon();
        classMember.done(this.getFieldStatementElementType());
        classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseMemberVariableName() {
        ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
    }

    @Override
    protected boolean parseReferenceListMember() {
        PsiBuilder.Marker refMember = this.builder.mark();
        ES6ExpressionParser expressionParser = (ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser();
        boolean result = expressionParser.parseLeftHandSideExpression(EnumSet.of(ExpressionParser.ParseLeftHandSideExpressionOptions.IS_IN_EXTENDS_OR_IMPLEMENTS_LIST));
        if (result) {
            ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseTypeArgumentList(false, true, true);
            refMember.done((IElementType)JSStubElementTypes.EXTENDS_LIST_MEMBER);
        } else {
            refMember.drop();
        }
        return result;
    }

    @Override
    public boolean parseForLoopHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.AWAIT_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            return this.parseForLoopHeaderCondition();
        }
        return super.parseForLoopHeader();
    }

    @Override
    protected void parseES6DecoratorDeclaration(@NotNull PsiBuilder.Marker decoratorMark) {
        LOG.assertTrue(JSTokenTypes.DECORATOR_KEYWORD == this.builder.getTokenType());
        this.builder.advanceLexer();
        if (this.builder.getTokenType() != JSTokenTypes.AT) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.at", new Object[0]));
            decoratorMark.drop();
            return;
        }
        @Nullable FunctionParser.MethodEmptiness methodsMustBeEmpty = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
        this.builder.advanceLexer();
        if (!((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseFunctionName(false, FunctionParser.Context.SOURCE_ELEMENT)) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.name", new Object[0]));
            IElementType type = this.builder.getTokenType();
            if (type != JSTokenTypes.LBRACE && type != JSTokenTypes.LPAR && (methodsMustBeEmpty == null || type != JSTokenTypes.SEMICOLON)) {
                decoratorMark.drop();
                return;
            }
        }
        ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseTypeParameterList();
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterList(false);
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            if (methodsMustBeEmpty != null) {
                if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                    this.builder.advanceLexer();
                }
                decoratorMark.done((IElementType)ES6StubElementTypes.ES6_DECORATOR_DECLARATION);
                return;
            }
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            decoratorMark.drop();
            return;
        }
        this.builder.advanceLexer();
        ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).tryParseES7Decorators();
        if (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.rbrace", new Object[0]));
        } else {
            this.builder.advanceLexer();
        }
        decoratorMark.done((IElementType)ES6StubElementTypes.ES6_DECORATOR_DECLARATION);
    }

    @Override
    protected boolean isPossibleStartStatementModifier(IElementType token) {
        if (token == JSTokenTypes.ASYNC_KEYWORD) {
            return this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
        }
        return super.isPossibleStartStatementModifier(token);
    }

    protected static boolean isPropertyNameStart(IElementType t) {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(t) || t == JSTokenTypes.STRING_LITERAL || t == JSTokenTypes.NUMERIC_LITERAL || t == JSTokenTypes.LBRACKET;
    }

    public IElementType getFieldElementType() {
        return ES6StubElementTypes.FIELD;
    }
}

