/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.space;

import circlet.rd.api.RdWorkspaceState;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.common.oauth.OAuthKt;
import fleet.common.oauth.OAuthResult;
import fleet.common.oauth.OAuthServer;
import fleet.kernel.ReteExtKt;
import fleet.kernel.plugins.ContributionScope;
import fleet.plugins.space.SpaceAccount;
import fleet.plugins.space.SpaceConnectorKt;
import fleet.plugins.space.SpaceHostSupervisor;
import fleet.supervisor.api.ShipHostSupervisor;
import fleet.supervisor.api.ShipHostSupervisorKt;
import fleet.supervisor.api.SupervisorKey;
import fleet.util.logging.KLogger;
import io.ktor.client.HttpClient;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0000\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\n*\u00020\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0014\u001a&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u001b\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e*\f\b\u0000\u0010\t\"\u00020\n2\u00020\n\u00a8\u0006\u001c"}, d2={"logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "registerConnector", "", "Lfleet/kernel/plugins/ContributionScope;", "SpaceInstance", "", "SpaceSupervisorKey", "Lfleet/supervisor/api/SupervisorKey;", "getSpaceSupervisorKey", "()Lfleet/supervisor/api/SupervisorKey;", "errorMessage", "Lcirclet/rd/api/RdWorkspaceState;", "awaitSpaceAccount", "Lfleet/plugins/space/SpaceAccount;", "spaceInstance", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "signIntoSpace", "Lfleet/common/oauth/OAuthResult;", "httpClient", "Lio/ktor/client/HttpClient;", "instance", "authCode", "(Lio/ktor/client/HttpClient;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.plugins.codecanvas.frontend"})
public final class SpaceConnectorKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    @NotNull
    private static final SupervisorKey SpaceSupervisorKey = new SupervisorKey("fleet.codecanvas.connector");

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    public static final void registerConnector(@NotNull ContributionScope $this$registerConnector) {
        Intrinsics.checkNotNullParameter((Object)$this$registerConnector, (String)"<this>");
        ShipHostSupervisorKt.shipHostSupervisor((ContributionScope)$this$registerConnector, (ShipHostSupervisor)new SpaceHostSupervisor());
    }

    @NotNull
    public static final SupervisorKey getSpaceSupervisorKey() {
        return SpaceSupervisorKey;
    }

    private static final String errorMessage(RdWorkspaceState $this$errorMessage) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$errorMessage.ordinal()]) {
            case 1, 2 -> "Workspace failed";
            case 3 -> "Workspace is stopping\u2026";
            case 4 -> "Workspace has been stopped";
            case 5 -> "Workspace is deleting\u2026";
            case 6 -> "Workspace has been deleted";
            default -> null;
        };
    }

    private static final Object awaitSpaceAccount(String spaceInstance, Continuation<? super SpaceAccount> $completion) {
        return ReteExtKt.waitForNotNull((Function0)((Function0)new Function0<SpaceAccount>(spaceInstance){
            final /* synthetic */ String $spaceInstance;
            {
                this.$spaceInstance = $spaceInstance;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final SpaceAccount invoke() {
                void $this$singleOrNullOrThrowWithMessage$iv;
                Iterable iterable = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)SpaceAccount.Companion.getServerUrlAttr()), (Object)this.$spaceInstance);
                String string = this.$spaceInstance;
                boolean $i$f$singleOrNullOrThrowWithMessage = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (T element$iv : $this$singleOrNullOrThrowWithMessage$iv) {
                    if (found$iv) {
                        T t = element$iv;
                        Object var9_9 = single$iv;
                        boolean bl = false;
                        String string2 = "More than on account for CodeCanvas instance " + string;
                        String string3 = "Collection contains more than one matching element: " + var9_9 + ", " + t + " " + string2;
                        throw new IllegalArgumentException(string3);
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                return single$iv;
            }
        }), $completion);
    }

    private static final Object signIntoSpace(HttpClient httpClient, String instance, String authCode, Continuation<? super OAuthResult> $completion) {
        String redirectUri = "fleet://codecanvas/oauth/auth";
        return OAuthKt.handleCodeFlowRedirect((HttpClient)httpClient, (OAuthServer)((OAuthServer)new OAuthServer.CodeCanvas(instance)), (String)(redirectUri + "?code=" + authCode), (String)redirectUri, (String)OAuthKt.generateRandomVerifier(), $completion);
    }

    public static final /* synthetic */ Object access$signIntoSpace(HttpClient httpClient, String instance, String authCode, Continuation $completion) {
        return SpaceConnectorKt.signIntoSpace(httpClient, instance, authCode, (Continuation<? super OAuthResult>)$completion);
    }

    public static final /* synthetic */ KLogger access$getLogger() {
        return SpaceConnectorKt.getLogger();
    }

    public static final /* synthetic */ String access$errorMessage(RdWorkspaceState $receiver) {
        return SpaceConnectorKt.errorMessage($receiver);
    }

    public static final /* synthetic */ Object access$awaitSpaceAccount(String spaceInstance, Continuation $completion) {
        return SpaceConnectorKt.awaitSpaceAccount(spaceInstance, (Continuation<? super SpaceAccount>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdWorkspaceState.values().length];
            try {
                nArray[RdWorkspaceState.Failed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdWorkspaceState.FailedToStart.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdWorkspaceState.Hibernating.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdWorkspaceState.Hibernated.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdWorkspaceState.Deleting.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdWorkspaceState.Deleted.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

