/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.parser;

import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.LanguageUtil;
import fleet.com.intellij.lang.ParserDefinition;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.FileViewProvider;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.lexer.RsLexer;
import org.rust.lang.core.parser.RustParser;
import org.rust.lang.core.parser.UtilKt;
import org.rust.lang.core.psi.RsDocTokenType;
import org.rust.lang.core.psi.RsTokenType;
import org.rust.lang.core.psi.RsTokenTypeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/parser/RustParserDefinition;", "Lfleet/com/intellij/lang/ParserDefinition;", "()V", "createElement", "Lfleet/com/intellij/psi/PsiElement;", "node", "Lfleet/com/intellij/lang/ASTNode;", "createFile", "Lfleet/com/intellij/psi/PsiFile;", "viewProvider", "Lfleet/com/intellij/psi/FileViewProvider;", "createLexer", "Lfleet/com/intellij/lexer/Lexer;", "project", "Lfleet/com/intellij/openapi/project/Project;", "createParser", "Lfleet/com/intellij/lang/PsiParser;", "getCommentTokens", "Lfleet/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getFileNodeType", "Lfleet/com/intellij/psi/tree/IFileElementType;", "getStringLiteralElements", "getWhitespaceTokens", "spaceExistenceTypeBetweenTokens", "Lfleet/com/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "Companion", "rust-parser"})
public final class RustParserDefinition
implements ParserDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final RsTokenType BLOCK_COMMENT = new RsTokenType("<BLOCK_COMMENT>");
    @JvmField
    @NotNull
    public static final RsTokenType EOL_COMMENT = new RsTokenType("<EOL_COMMENT>");
    @JvmField
    @NotNull
    public static final RsDocTokenType INNER_BLOCK_DOC_COMMENT = new RsDocTokenType("<INNER_BLOCK_DOC_COMMENT>");
    @JvmField
    @NotNull
    public static final RsDocTokenType OUTER_BLOCK_DOC_COMMENT = new RsDocTokenType("<OUTER_BLOCK_DOC_COMMENT>");
    @JvmField
    @NotNull
    public static final RsDocTokenType INNER_EOL_DOC_COMMENT = new RsDocTokenType("<INNER_EOL_DOC_COMMENT>");
    @JvmField
    @NotNull
    public static final RsDocTokenType OUTER_EOL_DOC_COMMENT = new RsDocTokenType("<OUTER_EOL_DOC_COMMENT>");
    @NotNull
    private static final IFileElementType FILE;
    public static final int LEXER_VERSION = 3;
    public static final int PARSER_VERSION = 29;

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        IElementType iElementType = left.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType leftElementType = iElementType;
        if (Intrinsics.areEqual((Object)leftElementType, (Object)((Object)EOL_COMMENT))) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (UtilKt.isDocCommentLeafToken(leftElementType)) {
            IElementType iElementType2 = right.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
            return UtilKt.isDocCommentLeafToken(iElementType2) ? ParserDefinition.SpaceRequirements.MAY : ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)((Lexer)new RsLexer()));
        Intrinsics.checkNotNullExpressionValue((Object)spaceRequirements, (String)"canStickTokensTogetherByLexer(...)");
        return spaceRequirements;
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return RsTokenTypeKt.getRS_ALL_STRING_LITERALS();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        IElementType[] iElementTypeArray = new IElementType[]{TokenType.WHITE_SPACE};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return RsTokenTypeKt.getRS_COMMENTS();
    }

    @NotNull
    public PsiElement createElement(@Nullable ASTNode node) {
        throw new IllegalStateException("unsupported".toString());
    }

    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new RsLexer();
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return new RustParser();
    }

    static {
        RsLanguage rsLanguage = RsLanguage.INSTANCE;
        FILE = new IFileElementType(rsLanguage){

            public void parse(@NotNull PsiBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                new RustParser().parseLight((IElementType)this, builder);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/lang/core/parser/RustParserDefinition$Companion;", "", "()V", "BLOCK_COMMENT", "Lorg/rust/lang/core/psi/RsTokenType;", "EOL_COMMENT", "FILE", "Lfleet/com/intellij/psi/tree/IFileElementType;", "INNER_BLOCK_DOC_COMMENT", "Lorg/rust/lang/core/psi/RsDocTokenType;", "INNER_EOL_DOC_COMMENT", "LEXER_VERSION", "", "OUTER_BLOCK_DOC_COMMENT", "OUTER_EOL_DOC_COMMENT", "PARSER_VERSION", "rust-parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

