/*
 * Decompiled with CFR 0.152.
 */
package org.cef.handler;

import java.util.Vector;
import org.cef.CefApp;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefNativeAdaperMulti;
import org.cef.handler.CefAppStateHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefPermissionHandler;
import org.cef.handler.CefPrintHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.misc.CefLog;

public abstract class CefClientHandler
extends CefNativeAdaperMulti
implements CefAppStateHandler {
    private Vector<CefMessageRouter> msgRouters = new Vector();
    protected boolean isNativeCtxInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateHasChanged(CefApp.CefAppState state2) {
        if (CefApp.isRemoteEnabled()) {
            return;
        }
        if (CefApp.CefAppState.INITIALIZED == state2) {
            CefClientHandler cefClientHandler = this;
            synchronized (cefClientHandler) {
                try {
                    this.N_CefClientHandler_CTOR();
                    this.isNativeCtxInitialized = true;
                    this.msgRouters.forEach(r -> this.N_addMessageRouter((CefMessageRouter)r));
                }
                catch (UnsatisfiedLinkError err) {
                    err.printStackTrace();
                }
            }
        }
    }

    protected void dispose() {
        if (CefApp.isRemoteEnabled()) {
            return;
        }
        try {
            for (int i = 0; i < this.msgRouters.size(); ++i) {
                this.msgRouters.get(i).dispose();
            }
            this.msgRouters.clear();
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_CefClientHandler_DTOR();
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    private void checkNativeCtxInitialized() {
        if (!this.isNativeCtxInitialized) {
            String m1 = new Throwable().getStackTrace()[1].getMethodName();
            CefLog.Error("CefClientHandler: can't invoke native method '%s' before native context initialized", m1);
        }
    }

    protected abstract CefBrowser getBrowser(int var1);

    protected abstract Object[] getAllBrowser();

    protected abstract CefContextMenuHandler getContextMenuHandler();

    protected abstract CefDialogHandler getDialogHandler();

    protected abstract CefDisplayHandler getDisplayHandler();

    protected abstract CefDownloadHandler getDownloadHandler();

    protected abstract CefDragHandler getDragHandler();

    protected abstract CefFocusHandler getFocusHandler();

    protected abstract CefPermissionHandler getPermissionHandler();

    protected abstract CefJSDialogHandler getJSDialogHandler();

    protected abstract CefKeyboardHandler getKeyboardHandler();

    protected abstract CefLifeSpanHandler getLifeSpanHandler();

    protected abstract CefLoadHandler getLoadHandler();

    protected abstract CefPrintHandler getPrintHandler();

    protected abstract CefRenderHandler getRenderHandler();

    protected abstract CefRequestHandler getRequestHandler();

    protected abstract CefWindowHandler getWindowHandler();

    protected synchronized void addMessageRouter(CefMessageRouter h) {
        try {
            this.msgRouters.add(h);
            if (this.isNativeCtxInitialized) {
                this.N_addMessageRouter(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeContextMenuHandler(CefContextMenuHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeContextMenuHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeDialogHandler(CefDialogHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeDialogHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeDisplayHandler(CefDisplayHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeDisplayHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeDownloadHandler(CefDisplayHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeDownloadHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeDragHandler(CefDragHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeDragHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeFocusHandler(CefFocusHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeFocusHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeJSDialogHandler(CefJSDialogHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeJSDialogHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeKeyboardHandler(CefKeyboardHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeKeyboardHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeLifeSpanHandler(CefLifeSpanHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeLifeSpanHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeLoadHandler(CefLoadHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeLoadHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removePrintHandler(CefPrintHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removePrintHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected synchronized void removeMessageRouter(CefMessageRouter h) {
        try {
            this.msgRouters.remove(h);
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeMessageRouter(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeRenderHandler(CefRenderHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeRenderHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeRequestHandler(CefRequestHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeRequestHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    protected void removeWindowHandler(CefWindowHandler h) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized) {
                this.N_removeWindowHandler(h);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
    }

    private final native void N_CefClientHandler_CTOR();

    private final native void N_addMessageRouter(CefMessageRouter var1);

    private final native void N_removeContextMenuHandler(CefContextMenuHandler var1);

    private final native void N_removeDialogHandler(CefDialogHandler var1);

    private final native void N_removeDisplayHandler(CefDisplayHandler var1);

    private final native void N_removeDownloadHandler(CefDisplayHandler var1);

    private final native void N_removeDragHandler(CefDragHandler var1);

    private final native void N_removeFocusHandler(CefFocusHandler var1);

    private final native void N_removeJSDialogHandler(CefJSDialogHandler var1);

    private final native void N_removeKeyboardHandler(CefKeyboardHandler var1);

    private final native void N_removeLifeSpanHandler(CefLifeSpanHandler var1);

    private final native void N_removeLoadHandler(CefLoadHandler var1);

    private final native void N_removePrintHandler(CefPrintHandler var1);

    private final native void N_removeMessageRouter(CefMessageRouter var1);

    private final native void N_removeRenderHandler(CefRenderHandler var1);

    private final native void N_removeRequestHandler(CefRequestHandler var1);

    private final native void N_removeWindowHandler(CefWindowHandler var1);

    private final native void N_CefClientHandler_DTOR();
}

