/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import org.cef.CefClient;
import org.cef.browser.CefDevToolsClient;
import org.cef.browser.CefFrame;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.input.CefCompositionUnderline;
import org.cef.input.CefTouchEvent;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.misc.CefRange;
import org.cef.network.CefRequest;

public interface CefBrowser {
    public void createImmediately();

    public Component getUIComponent();

    public CefClient getClient();

    public CefRequestContext getRequestContext();

    public CefRenderHandler getRenderHandler();

    public CefWindowHandler getWindowHandler();

    public boolean canGoBack();

    public void goBack();

    public boolean canGoForward();

    public void goForward();

    public boolean isLoading();

    public void reload();

    public void reloadIgnoreCache();

    public void stopLoad();

    public int getIdentifier();

    public CefFrame getMainFrame();

    public CefFrame getFocusedFrame();

    public CefFrame getFrameByIdentifier(String var1);

    public CefFrame getFrameByName(String var1);

    public Vector<String> getFrameIdentifiers();

    public Vector<String> getFrameNames();

    public int getFrameCount();

    public boolean isPopup();

    public boolean hasDocument();

    public void viewSource();

    public void getSource(CefStringVisitor var1);

    public void getText(CefStringVisitor var1);

    public void loadRequest(CefRequest var1);

    public void loadURL(String var1);

    public void executeJavaScript(String var1, String var2, int var3);

    public String getURL();

    public void close(boolean var1);

    public void setCloseAllowed();

    public boolean doClose();

    public void onBeforeClose();

    public boolean isClosing();

    public boolean isClosed();

    public void setFocus(boolean var1);

    public void setWindowVisibility(boolean var1);

    public double getZoomLevel();

    public void setZoomLevel(double var1);

    public void runFileDialog(CefDialogHandler.FileDialogMode var1, String var2, String var3, Vector<String> var4, CefRunFileDialogCallback var5);

    public void startDownload(String var1);

    public void print();

    public void printToPDF(String var1, CefPdfPrintSettings var2, CefPdfPrintCallback var3);

    public void find(String var1, boolean var2, boolean var3, boolean var4);

    public void stopFinding(boolean var1);

    public CefBrowser getDevTools();

    public CefBrowser getDevTools(Point var1);

    public CefDevToolsClient getDevToolsClient();

    public void replaceMisspelling(String var1);

    public void wasResized(int var1, int var2);

    public void notifyScreenInfoChanged();

    public void sendKeyEvent(KeyEvent var1);

    public void sendMouseEvent(MouseEvent var1);

    public void sendMouseWheelEvent(MouseWheelEvent var1);

    public void sendTouchEvent(CefTouchEvent var1);

    public CompletableFuture<BufferedImage> createScreenshot(boolean var1);

    public void ImeSetComposition(String var1, List<CefCompositionUnderline> var2, CefRange var3, CefRange var4);

    public void ImeCommitText(String var1, CefRange var2, int var3);

    public void ImeFinishComposingText(boolean var1);

    public void ImeCancelComposing();

    public void setWindowlessFrameRate(int var1);

    public CompletableFuture<Integer> getWindowlessFrameRate();
}

