/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.router;

import com.jetbrains.cef.remote.RemoteBrowser;
import com.jetbrains.cef.remote.RemoteServerObject;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.router.RemoteMessageRouterHandler;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.util.ArrayList;
import java.util.List;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.misc.CefLog;

public class RemoteMessageRouterImpl
extends RemoteServerObject {
    private final List<RemoteMessageRouterHandler> myHandlers = new ArrayList<RemoteMessageRouterHandler>();
    private String myQuery;
    private String myCancel;

    private RemoteMessageRouterImpl(RpcExecutor server, RObject robj, String query, String cancel) {
        super(server, robj);
        this.myQuery = query;
        this.myCancel = cancel;
    }

    public static RemoteMessageRouterImpl create(RpcExecutor server, CefMessageRouter.CefMessageRouterConfig config) {
        RObject robj = server.execObj(s -> s.MessageRouter_Create(config.jsQueryFunction, config.jsCancelFunction));
        if (robj.objId < 0) {
            CefLog.Error("MessageRouter_Create returns invalid objId %d.", robj.objId);
            return null;
        }
        return new RemoteMessageRouterImpl(server, robj, config.jsQueryFunction, config.jsCancelFunction);
    }

    public void addToBrowser(int bid) {
        this.myServer.exec(s -> s.MessageRouter_AddMessageRouterToBrowser(this.thriftId(), bid));
    }

    public void removeFromBrowser(int bid) {
        this.myServer.exec(s -> s.MessageRouter_RemoveMessageRouterFromBrowser(this.thriftId(), bid));
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeOnServerImpl() {
        List<RemoteMessageRouterHandler> list = this.myHandlers;
        synchronized (list) {
            for (RemoteMessageRouterHandler h : this.myHandlers) {
                RemoteMessageRouterHandler.FACTORY.dispose(h.getId());
            }
            this.myHandlers.clear();
        }
        this.myServer.exec(s -> s.MessageRouter_Dispose(this.thriftId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHandler(CefMessageRouterHandler handler, boolean first) {
        RemoteMessageRouterHandler rhandler = RemoteMessageRouterHandler.create(handler);
        List<RemoteMessageRouterHandler> list = this.myHandlers;
        synchronized (list) {
            this.myHandlers.add(rhandler);
        }
        this.myServer.exec(s -> s.MessageRouter_AddHandler(this.thriftId(), rhandler.thriftId(), first));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHandler(CefMessageRouterHandler handler) {
        CefLog.Debug("%s remove handler by delegate %s", this, handler);
        RemoteMessageRouterHandler rhandler = RemoteMessageRouterHandler.findByDelegate(handler);
        if (rhandler == null) {
            return false;
        }
        List<RemoteMessageRouterHandler> list = this.myHandlers;
        synchronized (list) {
            boolean removed = this.myHandlers.remove(rhandler);
            if (!removed) {
                CefLog.Error("RemoteMessageRouterHandler %s wasn't found in myHandlers list", new Object[0]);
            }
        }
        this.myServer.exec(s -> s.MessageRouter_RemoveHandler(this.thriftId(), rhandler.thriftId()));
        RemoteMessageRouterHandler.FACTORY.dispose(rhandler.getId());
        return true;
    }

    public void cancelPending(CefBrowser browser, CefMessageRouterHandler handler) {
        RemoteMessageRouterHandler rhandler = RemoteMessageRouterHandler.findByDelegate(handler);
        if (rhandler == null) {
            return;
        }
        if (browser != null && !(browser instanceof RemoteBrowser)) {
            CefLog.Error("Can't cancelPending on non-remote browser " + browser, new Object[0]);
        } else {
            int bid = browser == null ? -1 : ((RemoteBrowser)browser).getBid();
            this.myServer.exec(s -> s.MessageRouter_CancelPending(this.thriftId(), bid, rhandler.thriftId()));
        }
    }

    public String toString() {
        return String.format("Router<%s | %s>", this.myQuery, this.myCancel);
    }
}

