/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cef.misc.CefLog;

public class RemoteJavaObjectFactory<T> {
    private final Map<Integer, T> INSTANCES = new ConcurrentHashMap<Integer, T>();
    private AtomicInteger COUNTER = new AtomicInteger(0);

    public T create(Function<Integer, T> creator) {
        int newId = this.COUNTER.getAndIncrement();
        T result = creator.apply(newId);
        this.INSTANCES.put(newId, result);
        return result;
    }

    public T find(int id) {
        return this.INSTANCES.get(id);
    }

    public T find(Predicate<T> predicate) {
        for (T inst : this.INSTANCES.values()) {
            if (!predicate.test(inst)) continue;
            return inst;
        }
        return null;
    }

    public T get(int id) {
        T result = this.INSTANCES.get(id);
        if (result == null) {
            CefLog.Error("Can't find instance in '%s' by id %d", this.INSTANCES, id);
        }
        return result;
    }

    public void dispose(int id) {
        this.INSTANCES.remove(id);
    }

    protected String getGenericName() {
        return ((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getTypeName();
    }
}

