/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.IdentityHashCodeKt;
import androidx.compose.runtime.collection.IdentityArraySet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0019\u001a\u00020\u001aJ+\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001dH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0014\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 J\b\u0010!\u001a\u00020\u0012H\u0016J\u0006\u0010\"\u001a\u00020\u0012J\u0013\u0010#\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J \u0010$\u001a\u00020\u001a2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u001dH\u0086\b\u00f8\u0001\u0000J\u0012\u0010&\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0016\u0010+\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.H\u0096\u0002J\b\u0010/\u001a\u000200H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR8\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b8\u0000@BX\u0081\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u0012\u0004\b\r\u0010\u0005\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Landroidx/compose/runtime/collection/IdentityArraySet;", "T", "", "", "<init>", "()V", "value", "", "size", "getSize", "()I", "", "values", "getValues$annotations", "getValues", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "contains", "", "element", "(Ljava/lang/Object;)Z", "get", "index", "(I)Ljava/lang/Object;", "add", "clear", "", "fastForEach", "block", "Lkotlin/Function1;", "addAll", "collection", "", "isEmpty", "isNotEmpty", "remove", "removeValueIf", "predicate", "find", "findExactIndex", "midIndex", "valueHash", "checkIndexBounds", "containsAll", "elements", "iterator", "", "toString", "", "fleet.noria.cells"})
@SourceDebugExtension(value={"SMAP\nIdentityArraySet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n1734#2,3:375\n*S KotlinDebug\n*F\n+ 1 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n*L\n351#1:375,3\n*E\n"})
public final class IdentityArraySet<T>
implements Set<T>,
KMappedMarker {
    private int size;
    @NotNull
    private Object[] values = new Object[16];

    public int getSize() {
        return this.size;
    }

    @NotNull
    public final Object[] getValues() {
        return this.values;
    }

    @PublishedApi
    public static /* synthetic */ void getValues$annotations() {
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.find(element) >= 0;
    }

    @NotNull
    public final T get(int index) {
        this.checkIndexBounds(index);
        Object object = this.values[index];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
        return (T)object;
    }

    @Override
    public final boolean add(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int index = 0;
        if (this.size() > 0) {
            index = this.find(value);
            if (index >= 0) {
                return false;
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        if (this.size() == this.values.length) {
            Object[] newSorted = new Object[this.values.length * 2];
            ArraysKt.copyInto((Object[])this.values, (Object[])newSorted, (int)(insertIndex + 1), (int)insertIndex, (int)this.size());
            ArraysKt.copyInto$default((Object[])this.values, (Object[])newSorted, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.values = newSorted;
        } else {
            ArraysKt.copyInto((Object[])this.values, (Object[])this.values, (int)(insertIndex + 1), (int)insertIndex, (int)this.size());
        }
        this.values[insertIndex] = value;
        int n = this.size();
        this.size = n + 1;
        return true;
    }

    @Override
    public final void clear() {
        ArraysKt.fill$default((Object[])this.values, null, (int)0, (int)0, (int)6, null);
        this.size = 0;
    }

    public final void fastForEach(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$fastForEach = false;
        Object[] values = this.getValues();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object object = values[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            block.invoke(object);
        }
    }

    public final void addAll(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        if (collection.isEmpty()) {
            return;
        }
        if (!(collection instanceof IdentityArraySet)) {
            for (T value : collection) {
                this.add(value);
            }
        } else {
            boolean elementsInOrder;
            int otherSize;
            Object[] thisValues = this.values;
            Object[] otherValues = ((IdentityArraySet)collection).values;
            int thisSize = this.size();
            int combinedSize = thisSize + (otherSize = ((IdentityArraySet)collection).size());
            boolean needsResize = this.values.length < combinedSize;
            boolean bl = elementsInOrder = thisSize == 0 || IdentityHashCodeKt.identityHashCode(thisValues[thisSize - 1]) < IdentityHashCodeKt.identityHashCode(otherValues[0]);
            if (!needsResize && elementsInOrder) {
                ArraysKt.copyInto((Object[])otherValues, (Object[])thisValues, (int)thisSize, (int)0, (int)otherSize);
                this.size = this.size() + otherSize;
            } else {
                Object[] newArray = needsResize ? new Object[combinedSize] : thisValues;
                int thisIndex = thisSize - 1;
                int otherIndex = otherSize - 1;
                int nextInsertIndex = combinedSize - 1;
                while (true) {
                    Object object;
                    if (thisIndex < 0) {
                        if (otherIndex < 0) break;
                    }
                    if (thisIndex < 0) {
                        object = otherValues[otherIndex--];
                    } else if (otherIndex < 0) {
                        object = thisValues[thisIndex--];
                    } else {
                        Object thisValue = thisValues[thisIndex];
                        Object otherValue = otherValues[otherIndex];
                        int thisHash = IdentityHashCodeKt.identityHashCode(thisValue);
                        int otherHash = IdentityHashCodeKt.identityHashCode(otherValue);
                        if (thisHash > otherHash) {
                            --thisIndex;
                            object = thisValue;
                        } else if (thisHash < otherHash) {
                            --otherIndex;
                            object = otherValue;
                        } else if (thisValue == otherValue) {
                            --thisIndex;
                            --otherIndex;
                            object = thisValue;
                        } else {
                            Object value;
                            int i = thisIndex - 1;
                            boolean foundDuplicate = false;
                            while (i >= 0 && IdentityHashCodeKt.identityHashCode(value = thisValues[i--]) == otherHash) {
                                if (otherValue != value) continue;
                                foundDuplicate = true;
                                break;
                            }
                            if (foundDuplicate) {
                                --otherIndex;
                                continue;
                            }
                            --otherIndex;
                            object = otherValue;
                        }
                    }
                    Object nextValue = object;
                    newArray[nextInsertIndex--] = nextValue;
                }
                if (nextInsertIndex >= 0) {
                    ArraysKt.copyInto((Object[])newArray, (Object[])newArray, (int)0, (int)(nextInsertIndex + 1), (int)combinedSize);
                }
                int newSize = combinedSize - (nextInsertIndex + 1);
                ArraysKt.fill((Object[])newArray, null, (int)newSize, (int)combinedSize);
                this.values = newArray;
                this.size = newSize;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean isNotEmpty() {
        return this.size() > 0;
    }

    @Override
    public final boolean remove(@Nullable T value) {
        if (value == null) {
            return false;
        }
        int index = this.find(value);
        if (index >= 0) {
            if (index < this.size() - 1) {
                ArraysKt.copyInto((Object[])this.values, (Object[])this.values, (int)index, (int)(index + 1), (int)this.size());
            }
            int n = this.size();
            this.size = n + -1;
            this.values[this.size()] = null;
            return true;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function1<? super T, Boolean> predicate) {
        int i;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeValueIf = false;
        int destinationIndex = 0;
        int n = this.size();
        for (i = 0; i < n; ++i) {
            Object item;
            Intrinsics.checkNotNull((Object)this.getValues()[i], (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            if (((Boolean)predicate.invoke(item)).booleanValue()) continue;
            if (destinationIndex != i) {
                this.getValues()[destinationIndex] = item;
            }
            ++destinationIndex;
        }
        n = this.size();
        for (i = destinationIndex; i < n; ++i) {
            this.getValues()[i] = null;
        }
        this.size = destinationIndex;
    }

    private final int find(Object value) {
        int low = 0;
        int high = this.size() - 1;
        int valueIdentity = IdentityHashCodeKt.identityHashCode(value);
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = this.get(mid);
            int midIdentity = IdentityHashCodeKt.identityHashCode(midVal);
            if (midIdentity < valueIdentity) {
                low = mid + 1;
                continue;
            }
            if (midIdentity > valueIdentity) {
                high = mid - 1;
                continue;
            }
            if (midVal == value) {
                return mid;
            }
            return this.findExactIndex(mid, value, valueIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object value, int valueHash) {
        int i;
        for (i = midIndex - 1; -1 < i; --i) {
            Object v = this.values[i];
            if (v == value) {
                return i;
            }
            if (IdentityHashCodeKt.identityHashCode(v) != valueHash) break;
        }
        int n = this.size();
        for (i = midIndex + 1; i < n; ++i) {
            Object v = this.values[i];
            if (v == value) {
                return i;
            }
            if (IdentityHashCodeKt.identityHashCode(v) == valueHash) continue;
            return -(i + 1);
        }
        return -(this.size() + 1);
    }

    private final void checkIndexBounds(int index) {
        if (!(0 <= index ? index < this.size() : false)) {
            throw new IndexOutOfBoundsException("Index " + index + ", size " + this.size());
        }
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int index;
            final /* synthetic */ IdentityArraySet<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            public T next() {
                int n = this.index;
                this.index = n + 1;
                Object object = this.this$0.getValues()[n];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
                return (T)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.INSTANCE, (int)25, null);
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

