/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.javascript.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a,\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\r"}, d2={"isQuotedString", "", "s", "", "parseStringCharacters", "chars", "outChars", "Ljava/lang/StringBuilder;", "regExp", "escapeBacktick", "unquoteAndUnescapeString", "content", "unquoteString", "fleet.plugins.javascript.common"})
public final class JSStringUtilKt {
    @NotNull
    public static final String unquoteAndUnescapeString(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String stringContent = JSStringUtilKt.unquoteString(content);
        StringBuilder builder = new StringBuilder();
        JSStringUtilKt.parseStringCharacters(stringContent, builder, false, false);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String possibleParent = string;
        return possibleParent;
    }

    private static final boolean isQuotedString(String s) {
        int length = s.length();
        if (length <= 1) {
            return false;
        }
        char firstChar = s.charAt(0);
        if (firstChar != '\'' && firstChar != '\"') {
            return false;
        }
        return firstChar == s.charAt(length - 1);
    }

    private static final String unquoteString(String s) {
        String string;
        if (JSStringUtilKt.isQuotedString(s)) {
            String string2 = s.substring(1, s.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = s;
        }
        return string;
    }

    private static final boolean parseStringCharacters(String chars, StringBuilder outChars, boolean regExp, boolean escapeBacktick) {
        if (StringsKt.indexOf$default((CharSequence)chars, (char)'\\', (int)0, (boolean)false, (int)6, null) < 0) {
            outChars.append(chars);
            return true;
        }
        int index = 0;
        boolean result = true;
        while (index < chars.length()) {
            int v;
            int v2;
            char c;
            if ((c = chars.charAt(index++)) != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                result = false;
                break;
            }
            c = chars.charAt(index++);
            if (escapeBacktick && c == '`') {
                outChars.append(c);
                continue;
            }
            if (regExp) {
                if (c != '/') {
                    outChars.append('\\');
                }
                outChars.append(c);
                continue;
            }
            char c2 = c;
            if (c2 == 'b') {
                outChars.append('\b');
                continue;
            }
            if (c2 == 't') {
                outChars.append('\t');
                continue;
            }
            if (c2 == 'n' ? true : c2 == '\n') {
                outChars.append('\n');
                continue;
            }
            if (c2 == 'r') {
                outChars.append('\r');
                continue;
            }
            if (c2 == '\"') {
                outChars.append('\"');
                continue;
            }
            if (c2 == '/') {
                outChars.append('/');
                continue;
            }
            if (c2 == '\'') {
                outChars.append('\'');
                continue;
            }
            if (c2 == '\\') {
                outChars.append('\\');
                continue;
            }
            if (((((((c2 == '0' ? true : c2 == '1') ? true : c2 == '2') ? true : c2 == '3') ? true : c2 == '4') ? true : c2 == '5') ? true : c2 == '6') ? true : c2 == '7') {
                char startC = c;
                v2 = c - 48;
                if (index < chars.length()) {
                    if (Intrinsics.compare((int)48, (int)(c = chars.charAt(index++))) <= 0 && Intrinsics.compare((int)c, (int)55) <= 0) {
                        v2 <<= 3;
                        v2 += c - 48;
                        if (Intrinsics.compare((int)startC, (int)51) <= 0 && index < chars.length()) {
                            if (Intrinsics.compare((int)48, (int)(c = chars.charAt(index++))) <= 0 && Intrinsics.compare((int)c, (int)55) <= 0) {
                                v2 <<= 3;
                                v2 += c - 48;
                            } else {
                                --index;
                            }
                        }
                    } else {
                        --index;
                    }
                }
                outChars.append((char)v2);
                continue;
            }
            if (c2 == 'x') {
                if (index + 2 <= chars.length()) {
                    try {
                        String string = chars.substring(index, index + 2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        v = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                        outChars.append((char)v);
                        index += 2;
                        continue;
                    }
                    catch (Exception e) {
                        result = false;
                        break;
                    }
                }
                result = false;
                break;
            }
            if (c2 == 'u') {
                if (index + 3 <= chars.length() && chars.charAt(index) == '{') {
                    int end = StringsKt.indexOf$default((CharSequence)chars, (char)'}', (int)(index + 1), (boolean)false, (int)4, null);
                    if (end < 0) {
                        result = false;
                        break;
                    }
                    try {
                        String string = chars.substring(index + 1, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        v2 = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                        c = chars.charAt(index + 1);
                        if (c == '+' || c == '-') {
                            result = false;
                            break;
                        }
                        outChars.appendCodePoint(v2);
                        index = end + 1;
                        continue;
                    }
                    catch (Exception e) {
                        result = false;
                        break;
                    }
                }
                if (index + 4 <= chars.length()) {
                    try {
                        String string = chars.substring(index, index + 4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        v = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                        c = chars.charAt(index);
                        if (c == '+' || c == '-') {
                            result = false;
                            break;
                        }
                        outChars.append((char)v);
                        index += 4;
                        continue;
                    }
                    catch (Exception e) {
                        result = false;
                        break;
                    }
                }
                result = false;
                break;
            }
            outChars.append(c);
        }
        return result;
    }

    static /* synthetic */ boolean parseStringCharacters$default(String string, StringBuilder stringBuilder, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return JSStringUtilKt.parseStringCharacters(string, stringBuilder, bl, bl2);
    }
}

