/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.keychain;

import com.jetbrains.keychain.KeychainBackend;
import com.jetbrains.keychain.LinuxLibsecretKeychainBackend;
import com.jetbrains.keychain.interop.CloseableMemoryKt;
import com.jetbrains.keychain.interop.GError;
import com.jetbrains.keychain.interop.GErrorByRef;
import com.jetbrains.keychain.interop.SecretLibrary;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.Closeable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0016J&\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0014\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/jetbrains/keychain/LinuxLibsecretKeychainBackend;", "Lcom/jetbrains/keychain/KeychainBackend;", "()V", "isAvailable", "", "()Z", "library", "Lcom/jetbrains/keychain/interop/SecretLibrary;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "name", "", "getName", "()Ljava/lang/String;", "schema", "Lcom/sun/jna/Pointer;", "getSchema", "()Lcom/sun/jna/Pointer;", "schema$delegate", "Lkotlin/Lazy;", "serverAttributeNamePointer", "Lcom/sun/jna/Memory;", "getServerAttributeNamePointer", "()Lcom/sun/jna/Memory;", "serverAttributeNamePointer$delegate", "userAttributeNamePointer", "getUserAttributeNamePointer", "userAttributeNamePointer$delegate", "getPassword", "service", "account", "setPassword", "", "password", "tryGetPassword", "Lkotlin/Pair;", "Lcom/jetbrains/keychain/interop/GErrorByRef;", "keychain"})
public final class LinuxLibsecretKeychainBackend
implements KeychainBackend {
    private final Logger logger = LoggerFactory.getLogger(LinuxLibsecretKeychainBackend.class);
    @NotNull
    private final String name;
    @Nullable
    private final SecretLibrary library;
    @NotNull
    private final Lazy schema$delegate;
    @NotNull
    private final Lazy serverAttributeNamePointer$delegate;
    @NotNull
    private final Lazy userAttributeNamePointer$delegate;

    public LinuxLibsecretKeychainBackend() {
        SecretLibrary secretLibrary;
        LinuxLibsecretKeychainBackend linuxLibsecretKeychainBackend;
        this.name = "linux-libsecret";
        LinuxLibsecretKeychainBackend linuxLibsecretKeychainBackend2 = this;
        try {
            linuxLibsecretKeychainBackend = linuxLibsecretKeychainBackend2;
            secretLibrary = (SecretLibrary)Native.load((String)"secret-1", SecretLibrary.class);
        }
        catch (Throwable t) {
            linuxLibsecretKeychainBackend = linuxLibsecretKeychainBackend2;
            this.logger.info("Failed to load libsecret: " + t.getMessage());
            secretLibrary = null;
        }
        linuxLibsecretKeychainBackend.library = secretLibrary;
        this.schema$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pointer>(this){
            final /* synthetic */ LinuxLibsecretKeychainBackend this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Pointer invoke() {
                SecretLibrary secretLibrary = LinuxLibsecretKeychainBackend.access$getLibrary$p(this.this$0);
                Intrinsics.checkNotNull((Object)secretLibrary);
                Object[] objectArray = new Object[]{LinuxLibsecretKeychainBackend.access$getServerAttributeNamePointer(this.this$0), 0, LinuxLibsecretKeychainBackend.access$getUserAttributeNamePointer(this.this$0), 0, null};
                return secretLibrary.secret_schema_new("org.gnome.keyring.NetworkPassword", 2, objectArray);
            }
        }));
        this.serverAttributeNamePointer$delegate = LazyKt.lazy((Function0)serverAttributeNamePointer.2.INSTANCE);
        this.userAttributeNamePointer$delegate = LazyKt.lazy((Function0)userAttributeNamePointer.2.INSTANCE);
    }

    @Override
    public boolean isAvailable() {
        if (this.library == null) {
            return false;
        }
        GErrorByRef error = (GErrorByRef)((Object)this.tryGetPassword("", "").component2());
        GError gError = error.getValue();
        return (gError == null ? null : gError.message) == null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPassword(@NotNull String service, @NotNull String account) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        if (!this.isAvailable()) {
            return null;
        }
        String password = (String)this.tryGetPassword(service, account).component1();
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<String, GErrorByRef> tryGetPassword(String service, String account) {
        Closeable closeable = (Closeable)CloseableMemoryKt.stringPointer(service);
        Throwable throwable = null;
        try {
            Pair pair;
            Memory serviceNamePointer = (Memory)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)CloseableMemoryKt.stringPointer(account);
            Throwable throwable2 = null;
            try {
                Memory accountNamePointer = (Memory)closeable2;
                boolean bl2 = false;
                GErrorByRef errorRef = new GErrorByRef();
                SecretLibrary secretLibrary = this.library;
                Intrinsics.checkNotNull((Object)secretLibrary);
                Pointer[] pointerArray = new Pointer[]{(Pointer)this.getServerAttributeNamePointer(), (Pointer)serviceNamePointer, (Pointer)this.getUserAttributeNamePointer(), (Pointer)accountNamePointer, null};
                String password = secretLibrary.secret_password_lookup_sync(this.getSchema(), null, errorRef, pointerArray);
                GError gError = errorRef.getValue();
                if (gError != null) {
                    String string = gError.message;
                    if (string != null) {
                        String it = string;
                        boolean bl3 = false;
                        this.logger.error("Could not get password: " + it);
                    }
                }
                pair = TuplesKt.to((Object)password, (Object)((Object)errorRef));
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            Pair pair2 = pair;
            return pair2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(@NotNull String service, @NotNull String account, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (!this.isAvailable()) {
            return;
        }
        Closeable closeable = (Closeable)CloseableMemoryKt.stringPointer(service);
        Throwable throwable = null;
        try {
            Unit unit;
            Memory serviceNamePointer = (Memory)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)CloseableMemoryKt.stringPointer(account);
            Throwable throwable2 = null;
            try {
                Unit unit2;
                Memory accountNamePointer = (Memory)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = (Closeable)CloseableMemoryKt.stringPointer(password);
                Throwable throwable3 = null;
                try {
                    Unit unit3;
                    Memory passwordPointer = (Memory)closeable3;
                    boolean bl3 = false;
                    GErrorByRef errorRef = new GErrorByRef();
                    SecretLibrary secretLibrary = this.library;
                    if (secretLibrary != null) {
                        Pointer[] pointerArray = new Pointer[]{(Pointer)this.getServerAttributeNamePointer(), (Pointer)serviceNamePointer, (Pointer)this.getUserAttributeNamePointer(), (Pointer)accountNamePointer, null};
                        secretLibrary.secret_password_store_sync(this.getSchema(), null, (Pointer)serviceNamePointer, (Pointer)passwordPointer, null, errorRef, pointerArray);
                    }
                    GError gError = errorRef.getValue();
                    if (gError == null) {
                        unit3 = null;
                    } else {
                        String string = gError.message;
                        if (string == null) {
                            unit3 = null;
                        } else {
                            String it = string;
                            boolean bl4 = false;
                            this.logger.error("Could not set password: " + it);
                            unit3 = Unit.INSTANCE;
                        }
                    }
                    unit2 = unit3;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                unit = unit2;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit4 = unit;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Pointer getSchema() {
        Lazy lazy = this.schema$delegate;
        return (Pointer)lazy.getValue();
    }

    private final Memory getServerAttributeNamePointer() {
        Lazy lazy = this.serverAttributeNamePointer$delegate;
        return (Memory)lazy.getValue();
    }

    private final Memory getUserAttributeNamePointer() {
        Lazy lazy = this.userAttributeNamePointer$delegate;
        return (Memory)lazy.getValue();
    }

    public static final /* synthetic */ SecretLibrary access$getLibrary$p(LinuxLibsecretKeychainBackend $this) {
        return $this.library;
    }

    public static final /* synthetic */ Memory access$getServerAttributeNamePointer(LinuxLibsecretKeychainBackend $this) {
        return $this.getServerAttributeNamePointer();
    }

    public static final /* synthetic */ Memory access$getUserAttributeNamePointer(LinuxLibsecretKeychainBackend $this) {
        return $this.getUserAttributeNamePointer();
    }
}

