/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.analysis.AnalysisBundle;
import fleet.com.intellij.lang.javascript.JSLexerUtil;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.parsing.JSTagOrGenericsFlowHelper;
import fleet.com.intellij.lexer.FlexLexer;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTagOrGenericUtil {
    private static final int MAX_RECURSION_LEVEL = 1000;
    private static final int CLOSING_TAG_LOOKAHEAD = 20;

    public static boolean recursion_guard_(State state, int level, String funcName) {
        if (level > 1000) {
            Logger.getInstance(JSTagOrGenericUtil.class).warn(AnalysisBundle.message((String)"parsing.error.maximum.recursion.level.reached.in", (Object[])new Object[]{1000, funcName}));
            return false;
        }
        return true;
    }

    public static boolean nextTokenIs(State state, IElementType token) {
        return state.nextTokenIs(token);
    }

    public static boolean nextTokenIs(State state, TokenSet tokenSet) {
        return state.nextTokenIs(tokenSet);
    }

    public static boolean nextTokenIs(State state, String frameName, Object ... tokens) {
        for (Object token : tokens) {
            IElementType elementType;
            if (!(token instanceof IElementType ? state.nextTokenIs(elementType = (IElementType)token) : state.nextTokenIs((TokenSet)token))) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeToken(State state, IElementType token) {
        if (state.nextTokenIs(token)) {
            state.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeToken(State state, TokenSet tokenSet) {
        if (state.nextTokenIs(tokenSet)) {
            state.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean parseTokens(State state, int pin, Object ... tokens) {
        Marker mark = state.mark(null);
        boolean result = JSTagOrGenericUtil.consumeTokens(state, pin, tokens);
        if (result) {
            mark.drop();
        } else {
            mark.rollbackTo();
        }
        return result;
    }

    public static boolean consumeTokens(State state, int pin, Object ... tokens) {
        for (Object token : tokens) {
            IElementType elementType;
            if (!(token instanceof IElementType ? !JSTagOrGenericUtil.consumeToken(state, elementType = (IElementType)token) : !JSTagOrGenericUtil.consumeToken(state, (TokenSet)token))) continue;
            return false;
        }
        return true;
    }

    public static Marker enter_section_(State state) {
        return JSTagOrGenericUtil.enter_section_(state, -1, 0);
    }

    public static Marker enter_section_(State state, int level, int modifiers) {
        return JSTagOrGenericUtil.enter_section_(state, level, modifiers, null, "");
    }

    public static Marker enter_section_(State state, int level, int modifiers, ElementType elementType, String frameName) {
        return state.mark(elementType);
    }

    public static void exit_section_(State state, Marker marker, @Nullable ElementType elementType, boolean result) {
        JSTagOrGenericUtil.exit_section_(state, -1, marker, result, false, elementType);
    }

    public static void exit_section_(State state, int level, Marker marker, boolean result, boolean pinned, @Nullable ElementType elementType) {
        if (marker == null) {
            return;
        }
        if (result) {
            marker.done(elementType);
        } else {
            marker.rollbackTo();
        }
    }

    public static int current_position_(State state) {
        return state.myOffset;
    }

    public static boolean empty_element_parsed_guard_(State state, String funcName, int pos) {
        return pos != JSTagOrGenericUtil.current_position_(state);
    }

    public static boolean parseFlowParameterList(State state, int level) {
        return JSTagOrGenericsFlowHelper.parseFlowParameterList(state);
    }

    public static boolean startsWithDiv(IElementType next) {
        return next == JSTokenTypes.REGEXP_LITERAL || next == JSTokenTypes.DIV;
    }

    public static boolean parseContentAndClosingTag(State state, int level) {
        boolean wasLt = false;
        for (int i = 0; i < 20; ++i) {
            IElementType token = state.getCurrentToken();
            if (token == JSTokenTypes.XML_END_TAG_START) {
                return true;
            }
            if (token == JSTokenTypes.LT) {
                wasLt = true;
            } else if (JSTagOrGenericUtil.startsWithDiv(token)) {
                if (wasLt) {
                    return true;
                }
            } else {
                wasLt = false;
            }
            state.advanceLexer();
        }
        return false;
    }

    public static final class State {
        private final FlexLexer myLexer;
        private final List<IElementType> myTokens;
        private int myOffset;
        private ElementType myLastElementType;

        public State(@NotNull FlexLexer lexer) {
            this.myLexer = lexer;
            this.myTokens = new ArrayList<IElementType>();
            this.myOffset = 0;
        }

        public Marker mark(@Nullable ElementType elementType) {
            return new Marker(this, elementType);
        }

        public boolean nextTokenIs(IElementType token) {
            this.prepareNextToken();
            return this.myTokens.get(this.myOffset) == token;
        }

        public boolean nextTokenIs(@NotNull TokenSet tokenSet) {
            this.prepareNextToken();
            return tokenSet.contains(this.myTokens.get(this.myOffset));
        }

        public void advanceLexer() {
            this.prepareNextToken();
            ++this.myOffset;
        }

        private void prepareNextToken() {
            if (this.myOffset == this.myTokens.size()) {
                try {
                    IElementType type = JSLexerUtil.skipCommentsAndWhitespaces(this.myLexer);
                    this.myTokens.add(type);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Nullable
        public IElementType getCurrentToken() {
            this.prepareNextToken();
            return this.myTokens.get(this.myOffset);
        }

        @Nullable
        public ElementType getLastElementType() {
            return this.myLastElementType;
        }
    }

    public static enum ElementType {
        GENERICS,
        TAG_OR_GENERICS;

    }

    public static final class Marker {
        @NotNull
        private final State myState;
        private final int myOffset;
        @Nullable
        private final ElementType myElementType;

        public Marker(@NotNull State state, @Nullable ElementType elementType) {
            this.myState = state;
            this.myOffset = state.myOffset;
            this.myElementType = elementType;
        }

        public void drop() {
        }

        public void rollbackTo() {
            this.myState.myOffset = this.myOffset;
        }

        public void done(@Nullable ElementType type) {
            if (type == null) {
                type = this.myElementType;
            }
            if (type != null) {
                this.myState.myLastElementType = type;
            }
        }
    }
}

