/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lang.javascript.JSKeywordSets;
import fleet.com.intellij.lang.javascript.JSStubElementTypes;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.JavaScriptBundle;
import fleet.com.intellij.lang.javascript.dialects.JSLanguageFeature;
import fleet.com.intellij.lang.javascript.parsing.ExpressionParser;
import fleet.com.intellij.lang.javascript.parsing.JSArrowFunctionDetector;
import fleet.com.intellij.lang.javascript.parsing.JSParseResult;
import fleet.com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import fleet.com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParser;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import fleet.com.intellij.lang.javascript.parsing.StatementParser;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    public static final Key<MethodEmptiness> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");

    protected FunctionParser(T parser) {
        super(parser);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        @Nullable MethodEmptiness prevMethodEmptiness = (MethodEmptiness)((Object)this.builder.getUserData(methodsEmptinessKey));
        try {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(Context context, @NotNull PsiBuilder.Marker functionMarker) {
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSTokenTypes.MULT && this.isJSorTS()) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = JSParsingContextUtil.isGeneratorContext(this.builder);
        JSParsingContextUtil.setIsGenerator(isGeneratorContext, this.builder);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.function.name", new Object[0]));
            parsedWithoutErrors = false;
        }
        parsedWithoutErrors &= !this.parseParameterList((boolean)(context == Context.EXPRESSION || context == Context.PROPERTY ? true : false)).hasErrors;
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        @Nullable MethodEmptiness methodEmptiness = (MethodEmptiness)((Object)this.builder.getUserData(methodsEmptinessKey));
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
        } else if (methodEmptiness == MethodEmptiness.ALWAYS) {
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                String key = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "javascript.ambient.declaration.should.have.no.body" : "interface.function.declaration.should.have.no.body";
                parsedWithoutErrors = false;
                this.builder.error(JavaScriptBundle.message(key, new Object[0]));
            }
        } else if (methodEmptiness == MethodEmptiness.POSSIBLY) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            } else if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        JSParsingContextUtil.setIsGenerator(wasGenerator, this.builder);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context) {
        if (this.myJavaScriptParser.getDialect().hasFeature(JSLanguageFeature.E4X) && this.parseGetSetAndNameAfterFunctionKeyword(context)) {
            return true;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(this.isIdentifierToken(tokenType) || functionKeywordWasOmitted && JSKeywordSets.PROPERTY_NAMES.contains(tokenType))) {
            return context == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    protected boolean parseGetSetAndNameAfterFunctionKeyword(Context context) {
        IElementType firstToken = this.builder.getTokenType();
        if (JSTokenTypes.GET_SET.contains(firstToken) && context != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSKeywordSets.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context == Context.PROPERTY && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parsePropertyName();
                return true;
            }
        }
        return false;
    }

    public void parseFunctionIdentifier() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).advancePropertyName(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSStubElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.EXPORT_KEYWORD || type == JSTokenTypes.GET_KEYWORD || type == JSTokenTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
        return true;
    }

    public IElementType getAttributeListElementType() {
        return JSStubElementTypes.ATTRIBUTE_LIST;
    }

    public void parseES7Decorators() {
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.AT);
        while (this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker attribute = this.builder.mark();
            this.builder.advanceLexer();
            Object expressionParser = this.myJavaScriptParser.getExpressionParser();
            ((ExpressionParser)expressionParser).parseLeftHandSideExpression(EnumSet.of(ExpressionParser.ParseLeftHandSideExpressionOptions.DISALLOW_INDEXER));
            attribute.done((IElementType)JSStubElementTypes.ES6_DECORATOR);
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation;
        boolean bl = hadAnnotation = this.builder.getTokenType() == JSTokenTypes.AT;
        if (hadAnnotation && this.hasSupportDecorators()) {
            this.parseES7Decorators();
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public JSParseResult parseParameterList(boolean funExpr) {
        if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList()) {
            return JSParseResult.UNACCEPTABLE;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.lparen", new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(this.getParameterListElementType());
            }
            return JSParseResult.UNACCEPTABLE;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.comma.or.rparen", new Object[0]));
                hasErrors = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            this.parseParameterAttributeList();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.parameter.name", new Object[0]));
                while (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                    this.builder.advanceLexer();
                }
                hasErrors = true;
            }
            hasErrors |= !this.parseSingleParameter(parameter);
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        return JSParseResult.acceptable(hasErrors, null);
    }

    public boolean parseSingleParameter(PsiBuilder.Marker parameter) {
        JSParseResult result = this.doParseSingleParameter();
        IElementType elementType = result.elementType;
        if (elementType != null) {
            parameter.done(elementType);
        } else {
            parameter.drop();
        }
        return !result.hasErrors;
    }

    @NotNull
    protected JSParseResult doParseSingleParameter() {
        boolean acceptResult;
        boolean hasErrors = false;
        IElementType elementType = this.getParameterType();
        IElementType tokenType = this.builder.getTokenType();
        if (this.isParameterName(false, tokenType)) {
            this.builder.advanceLexer();
            this.parseParameterOptionalMark();
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true)) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
            }
            acceptResult = true;
        } else if (this.willParseDestructuringAssignment()) {
            elementType = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElementNoMarker(this.getParameterType(), true, true);
            acceptResult = true;
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.formal.parameter.name", new Object[0]));
            hasErrors = true;
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true);
            } else {
                ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            }
            acceptResult = false;
        }
        return acceptResult && elementType != null ? JSParseResult.acceptable(hasErrors, elementType) : JSParseResult.UNACCEPTABLE;
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType);
    }

    protected boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    public IElementType getParameterType() {
        return JSStubElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    public boolean willParseDestructuringAssignment() {
        return !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(this.builder.getTokenType());
    }

    public static boolean willParseDestructuringAssignment(IElementType tokenType) {
        return tokenType == JSTokenTypes.LBRACKET || tokenType == JSTokenTypes.LBRACE;
    }

    protected void parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.tryParseES7Decorators();
            mark.done(this.getAttributeListElementType());
        }
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionWithoutModifiers(this.builder.mark());
    }

    protected boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        IElementType firstToken = this.builder.getTokenType();
        if (this.isIdentifierToken(firstToken) && JSTokenTypes.ARROWS.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            if (!JSArrowFunctionDetector.INSTANCE.isArrowFunctionExpression(this.builder, this)) {
                arrowFunction.rollbackTo();
                return false;
            }
            this.parseParameterList(true);
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType();
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSTokenTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                this.parseArrowFunctionExpressionBody();
            } else {
                ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlock();
            }
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.eqgt", new Object[0]));
        }
        arrowFunction.done(this.getFunctionExpressionElementType());
        arrowFunction.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    private void parseArrowFunctionExpressionBody() {
        PsiBuilder.Marker expressionBody = this.builder.mark();
        if (((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true)) {
            expressionBody.drop();
        } else {
            expressionBody.rollbackTo();
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
        }
    }

    protected boolean isValidFirstParameterStart(IElementType next) {
        if (next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT || !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(next)) {
            return true;
        }
        boolean isParameterName = this.isParameterName(true, next);
        if (!isParameterName) {
            return false;
        }
        int lookaheadSteps = 2;
        if (next == JSTokenTypes.CLASS_KEYWORD || next == JSTokenTypes.FUNCTION_KEYWORD || next == JSTokenTypes.ASYNC_KEYWORD && (next = this.builder.lookAhead(lookaheadSteps++)) == JSTokenTypes.FUNCTION_KEYWORD) {
            IElementType lookAhead = this.builder.lookAhead(lookaheadSteps);
            if (this.isIdentifierToken(lookAhead)) {
                return false;
            }
            if (next == JSTokenTypes.FUNCTION_KEYWORD) {
                return lookAhead != JSTokenTypes.LPAR && lookAhead != JSTokenTypes.MULT;
            }
            return lookAhead != JSTokenTypes.LBRACE;
        }
        return true;
    }

    protected boolean supportsColonTypeCast() {
        return false;
    }

    public IElementType getParameterListElementType() {
        return JSStubElementTypes.PARAMETER_LIST;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSStubElementTypes.FUNCTION_EXPRESSION;
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        boolean lexerAdvanced = !((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterList((boolean)false).hasErrors;
        lexerAdvanced |= ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }

    public static enum MethodEmptiness {
        ALWAYS,
        POSSIBLY;

    }
}

