/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.flow.psi;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.ecmascript6.parsing.ES6Parser;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.flow.psi.FlowInJSPsiTypeParser;
import fleet.com.intellij.lang.javascript.parsing.FunctionParser;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.psi.tree.IElementType;

public final class FlowJSPsiTypeParser<T extends ES6Parser<?, ?, ?, ?>>
extends FlowInJSPsiTypeParser<T> {
    static final Key<Boolean> FORCED_TYPE_KEY = Key.create((String)"js.parser.forced.type");
    static final Key<Boolean> OPAQUE_TYPE_KEY = Key.create((String)"js.parser.flow.opaque.type");

    public FlowJSPsiTypeParser(T parser) {
        super(parser);
    }

    @Override
    public boolean parseQualifiedTypeName() {
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            return this.parseQualifiedTypeNameTail(marker);
        }
        return super.parseQualifiedTypeName();
    }

    @Override
    public boolean tryParseArrowFunctionReturnType() {
        this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, (Object)Boolean.TRUE);
        boolean result = false;
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            result = true;
            if (this.builder.getTokenType() != JSTokenTypes.PERC) {
                result = this.parseInUnionOrIntersectionType(true, true, true);
            }
            this.tryParseTypePredicate();
        }
        this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, null);
        return result;
    }

    @Override
    protected boolean isFunctionTypeExpected() {
        IElementType elementTypeAfterLPar = this.builder.lookAhead(1);
        if (FunctionParser.willParseDestructuringAssignment(elementTypeAfterLPar) && Boolean.TRUE.equals(this.builder.getUserData(ARROW_FUNCTION_RETURN_TYPE_KEY))) {
            return false;
        }
        return super.isFunctionTypeExpected();
    }
}

