/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.smartMode.frontend;

import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.RowKt;
import androidx.compose.foundation.layout.RowScope;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Dp;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.BackendServiceApi;
import fleet.api.topology.ApiKey;
import fleet.common.WorkspaceEntity;
import fleet.common.WorkspaceEntityKt;
import fleet.common.ai.AiCommonKt;
import fleet.common.fs.SharedWorkspaceRootEntity;
import fleet.common.smartMode.SmartModeEntityKt;
import fleet.common.smartMode.SmartModeState;
import fleet.common.topology.ServiceKt;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.ButtonKt;
import fleet.compose.theme.components.IconKt;
import fleet.compose.theme.components.MutableProgressIndicator;
import fleet.compose.theme.components.ProgressIndicatorKt;
import fleet.compose.theme.components.ProgressState;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.frontend.KernelExtKt;
import fleet.frontend.ai.AiFrontendActionIds;
import fleet.frontend.ai.AiFrontendDataKeys;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.notifications.NotificationCategoryId;
import fleet.frontend.notifications.NotificationEntity;
import fleet.frontend.notifications.NotificationState;
import fleet.frontend.ui.components.ActionButtonKt;
import fleet.frontend.ui.controlCenter.ControlCenterKt;
import fleet.frontend.ui.controlCenter.ControlCenterProgress;
import fleet.frontend.ui.controlCenter.ControlCenterStatusProvider;
import fleet.kernel.plugins.PluginScope;
import fleet.plugins.smartMode.common.SmartModeProblemEntity;
import fleet.plugins.smartMode.common.SmartModeProblemEntityKt;
import fleet.plugins.smartMode.common.SmartModeProblemSeverity;
import fleet.plugins.smartMode.frontend.SmartModeControlCenterStatusProvider;
import fleet.plugins.smartMode.frontend.SmartModeControlCenterStatusProviderKt;
import fleet.plugins.smartMode.frontend.SmartModeProblemNotificationEntityKt;
import fleet.util.openmap.SerializableOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import noria.NoriaContext;
import noria.NoriaContextKt;
import noria.ReadScope;
import noria.impl.NoriaState;
import noria.impl.NoriaStateKt;
import noria.impl.Runtime;
import noria.model.ActionContext;
import noria.model.ActionId;
import noria.model.ActionsKt;
import noria.model.CommonTrigger;
import noria.model.FleetActionIds;
import noria.model.ThemeKey;
import noria.model.Trigger;
import noria.ui.ApplyModifierKt;
import noria.ui.events.HandlerScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u0005H\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProvider;", "Lfleet/frontend/ui/controlCenter/ControlCenterStatusProvider;", "<init>", "()V", "hasProblems", "", "getHasProblems", "()Z", "progress", "Lfleet/frontend/ui/controlCenter/ControlCenterProgress;", "getProgress", "()Lfleet/frontend/ui/controlCenter/ControlCenterProgress;", "isShown", "render", "", "Lnoria/NoriaContext;", "markAllSmartModeNotificationsAsRead", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "fleet.plugins.smartMode.frontend"})
@SourceDebugExtension(value={"SMAP\nSmartModeControlCenterStatusProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartModeControlCenterStatusProvider.kt\nfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,268:1\n1755#2,3:269\n774#2:273\n865#2,2:274\n155#3:272\n*S KotlinDebug\n*F\n+ 1 SmartModeControlCenterStatusProvider.kt\nfleet/plugins/smartMode/frontend/SmartModeControlCenterStatusProvider\n*L\n53#1:269,3\n191#1:273\n191#1:274,2\n87#1:272\n*E\n"})
public final class SmartModeControlCenterStatusProvider
implements ControlCenterStatusProvider {
    public boolean getHasProblems() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = SmartModeProblemEntity.Companion.all();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == SmartModeProblemSeverity.Error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public ControlCenterProgress getProgress() {
        SmartModeState smartModeState = SmartModeEntityKt.smartModeState();
        Set backendTypes = SmartModeControlCenterStatusProviderKt.access$getKnownBackendProjectRootTypes();
        List projectRoots = SmartModeControlCenterStatusProviderKt.access$filterIgnored(SmartModeControlCenterStatusProviderKt.access$projectRoots(backendTypes));
        return switch (WhenMappings.$EnumSwitchMapping$0[smartModeState.ordinal()]) {
            case 1 -> ControlCenterProgress.Off;
            case 2 -> {
                if (projectRoots.isEmpty() || !SmartModeControlCenterStatusProviderKt.access$isReady(projectRoots)) {
                    yield ControlCenterProgress.InProgress;
                }
                yield ControlCenterProgress.Finished;
            }
            case 3 -> {
                if (projectRoots.isEmpty()) {
                    yield ControlCenterProgress.Finished;
                }
                yield ControlCenterProgress.Off;
            }
            case 4, 5 -> ControlCenterProgress.InProgress;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean isShown() {
        return true;
    }

    @Composable
    public void render(@NotNull NoriaContext $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        WorkspaceEntity workspaceEntity = WorkspaceEntityKt.currentWorkspace();
        if (workspaceEntity == null) {
            return;
        }
        WorkspaceEntity currentWorkspace = workspaceEntity;
        PluginScope pluginScope = (PluginScope)$this$render.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope());
        Runtime.enterScope((NoriaContext)$this$render, (int)51);
        int $this$dp$iv = 3;
        boolean $i$f$getDp = false;
        Object[] objectArray = new Object[]{this, currentWorkspace, pluginScope};
        ProgressIndicatorKt.ProgressIndicatorBox-2lqI77k$default((NoriaContext)$this$render, null, (boolean)false, (float)Dp.constructor-impl((float)$this$dp$iv), (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<NoriaContext, MutableProgressIndicator, Unit>(this, currentWorkspace, pluginScope){
            final /* synthetic */ SmartModeControlCenterStatusProvider this$0;
            final /* synthetic */ WorkspaceEntity $currentWorkspace;
            final /* synthetic */ PluginScope $pluginScope;
            {
                this.this$0 = $receiver;
                this.$currentWorkspace = $currentWorkspace;
                this.$pluginScope = $pluginScope;
                super(2);
            }

            public final void invoke(NoriaContext $this$ProgressIndicatorBox, MutableProgressIndicator progressIndicator) {
                Intrinsics.checkNotNullParameter((Object)$this$ProgressIndicatorBox, (String)"$this$ProgressIndicatorBox");
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                SmartModeState smartModeState = SmartModeEntityKt.smartModeState();
                Set backendTypes = SmartModeControlCenterStatusProviderKt.access$getKnownBackendProjectRootTypes();
                ControlCenterProgress progressState = this.this$0.getProgress();
                ProgressIndicatorKt.setState((MutableProgressIndicator)progressIndicator, (ProgressState)ControlCenterKt.toProgressState((ControlCenterProgress)progressState));
                Runtime.enterScope((NoriaContext)$this$ProgressIndicatorBox, (int)50);
                int $this$dp$iv = 12;
                boolean $i$f$getDp = false;
                Object[] objectArray = new Object[]{backendTypes, smartModeState, this.$currentWorkspace, this.$pluginScope, this.this$0};
                ColumnKt.Column$default((NoriaContext)$this$ProgressIndicatorBox, (Modifier)PaddingKt.padding-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)), null, null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>((Set<String>)backendTypes, smartModeState, this.$currentWorkspace, this.$pluginScope, this.this$0){
                    final /* synthetic */ Set<String> $backendTypes;
                    final /* synthetic */ SmartModeState $smartModeState;
                    final /* synthetic */ WorkspaceEntity $currentWorkspace;
                    final /* synthetic */ PluginScope $pluginScope;
                    final /* synthetic */ SmartModeControlCenterStatusProvider this$0;
                    {
                        this.$backendTypes = $backendTypes;
                        this.$smartModeState = $smartModeState;
                        this.$currentWorkspace = $currentWorkspace;
                        this.$pluginScope = $pluginScope;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(ColumnScope $this$Column) {
                        int $this$dp$iv22;
                        Object object;
                        boolean bl;
                        SmartModeProblemEntity stopRequestedProblem;
                        List restartRequiredBackends;
                        Set smartModeProblems;
                        boolean hasControllerServices;
                        boolean hasAttachedBackendServices;
                        block22: {
                            Object v0;
                            block21: {
                                void $this$mapNotNullTo$iv$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$Column, (String)"$this$Column");
                                hasAttachedBackendServices = !((Collection)ServiceKt.all((ApiKey)((ApiKey)BackendServiceApi.Companion))).isEmpty();
                                hasControllerServices = !((Collection)this.$backendTypes).isEmpty();
                                smartModeProblems = SmartModeProblemEntity.Companion.all();
                                Iterable $this$mapNotNull$iv = smartModeProblems;
                                boolean $i$f$mapNotNull = false;
                                Iterable iterable = $this$mapNotNull$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    String it$iv$iv;
                                    T element$iv$iv$iv;
                                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                                    boolean bl2 = false;
                                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv$iv;
                                    boolean bl3 = false;
                                    if (SmartModeProblemEntityKt.getRestartRequiredRootTag((SerializableOpenMap)it.getProblemData()) == null) continue;
                                    boolean bl4 = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                restartRequiredBackends = (List)destination$iv$iv;
                                Iterable $this$firstOrNull$iv = smartModeProblems;
                                boolean $i$f$firstOrNull = false;
                                for (E element$iv : $this$firstOrNull$iv) {
                                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv;
                                    boolean bl5 = false;
                                    if (!(SmartModeProblemEntityKt.getStopRequestedRootTag((SerializableOpenMap)it.getProblemData()) != null)) continue;
                                    v0 = element$iv;
                                    break block21;
                                }
                                v0 = null;
                            }
                            stopRequestedProblem = v0;
                            Iterable $this$any$iv = smartModeProblems;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    SmartModeProblemEntity it = (SmartModeProblemEntity)element$iv;
                                    boolean bl6 = false;
                                    if (!(it.getSeverity() == SmartModeProblemSeverity.Error && SmartModeProblemEntityKt.getStopRequestedRootTag((SerializableOpenMap)it.getProblemData()) == null)) continue;
                                    bl = true;
                                    break block22;
                                }
                                bl = false;
                            }
                        }
                        boolean hasProblems = bl;
                        boolean canBeEnabled = hasControllerServices || hasAttachedBackendServices;
                        String state = "Smart Mode is " + (switch (render.WhenMappings.$EnumSwitchMapping$0[this.$smartModeState.ordinal()]) {
                            case 1 -> "off";
                            case 2, 3 -> {
                                if (hasProblems) {
                                    yield "partially on";
                                }
                                yield "on";
                            }
                            case 4 -> "starting\u2026";
                            case 5 -> "stopping\u2026";
                            default -> throw new NoWhenBranchMatchedException();
                        });
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)26);
                        TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Column), (String)state, (long)0L, (ThemeKey)TextStyleKeys.INSTANCE.getDefaultSemiBold(), null, null, null, null, null, null, null, (int)1018, null);
                        Unit element$iv = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)27);
                        int $this$dp$iv = 4;
                        boolean $i$f$getDp = false;
                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                        element$iv = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        if (!((Collection)restartRequiredBackends).isEmpty()) {
                            String backends = restartRequiredBackends.size() == 1 ? CollectionsKt.first((List)restartRequiredBackends) + " backend" : CollectionsKt.joinToString$default((Iterable)restartRequiredBackends, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " backends";
                            object = backends + " restart is required because some settings were changed";
                        } else {
                            SmartModeProblemEntity smartModeProblemEntity = stopRequestedProblem;
                            if ((smartModeProblemEntity != null && (smartModeProblemEntity = smartModeProblemEntity.getProblemData()) != null ? SmartModeProblemEntityKt.getTitle((SerializableOpenMap)smartModeProblemEntity) : null) != null) {
                                String string = SmartModeProblemEntityKt.getTitle((SerializableOpenMap)stopRequestedProblem.getProblemData());
                                object = string;
                                Intrinsics.checkNotNull((Object)string);
                            } else {
                                object = hasProblems ? "Some of Smart Mode functionality didn't start properly" : "Analyzes code to provide completion, error detection, fixes, and refactorings";
                            }
                        }
                        String stateText = object;
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)28);
                        TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Column), (String)stateText, (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$Column)).get(ThemeKeys.INSTANCE.getTextDimmed())).unbox-impl(), (ThemeKey)TextStyleKeys.INSTANCE.getSmall(), null, (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, null, (int)1000, null);
                        Object object2 = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        if (canBeEnabled && this.$smartModeState == SmartModeState.OFF && !this.$currentWorkspace.getTrusted()) {
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)29);
                            $this$dp$iv22 = 8;
                            boolean $i$f$getDp2 = false;
                            SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv22)));
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)33);
                            RowKt.Row$default((NoriaContext)((NoriaContext)$this$Column), null, null, (Alignment.Vertical)Alignment.Companion.getCenterVertically(), (boolean)false, (Function1)((Function1)Runtime.closure((Object[])new Object[0], (Object)((Object)render.1.INSTANCE))), (int)11, null);
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        }
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)34);
                        $this$dp$iv22 = 8;
                        boolean $i$f$getDp3 = false;
                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv22)));
                        object2 = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)42);
                        Object[] $this$dp$iv22 = new Object[]{canBeEnabled, this.$currentWorkspace, this.$pluginScope};
                        RowKt.Row$default((NoriaContext)((NoriaContext)$this$Column), null, null, (Alignment.Vertical)Alignment.Companion.getCenterVertically(), (boolean)false, (Function1)((Function1)Runtime.closure((Object[])$this$dp$iv22, (Object)new Function1<RowScope, Unit>(canBeEnabled, this.$currentWorkspace, this.$pluginScope){
                            final /* synthetic */ boolean $canBeEnabled;
                            final /* synthetic */ WorkspaceEntity $currentWorkspace;
                            final /* synthetic */ PluginScope $pluginScope;
                            {
                                this.$canBeEnabled = $canBeEnabled;
                                this.$currentWorkspace = $currentWorkspace;
                                this.$pluginScope = $pluginScope;
                                super(1);
                            }

                            public final void invoke(RowScope $this$Row) {
                                Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
                                if (this.$canBeEnabled) {
                                    Unit unit;
                                    if (this.$currentWorkspace.getSmartModeEnabled()) {
                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)35);
                                        ActionButtonKt.actionButton$default((NoriaContext)((NoriaContext)$this$Row), (Trigger)((Trigger)FleetActionIds.ToggleSmartMode.getId()), (String)"Disable", null, null, (boolean)false, null, (int)44, null);
                                        unit = Unit.INSTANCE;
                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    } else {
                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)36);
                                        ActionButtonKt.primaryActionButton$default((NoriaContext)((NoriaContext)$this$Row), (Trigger)((Trigger)FleetActionIds.ToggleSmartMode.getId()), (String)"Enable", null, null, (boolean)false, null, (int)44, null);
                                        unit = Unit.INSTANCE;
                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    }
                                    if (AiCommonKt.aiSmartModeInDockerAvailable()) {
                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)37);
                                        int $this$dp$iv22 = 8;
                                        boolean $i$f$getDp = false;
                                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Row), (Modifier)SizeKt.size-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv22)));
                                        unit = Unit.INSTANCE;
                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)38);
                                        Object[] $this$dp$iv22 = new Object[]{this.$pluginScope};
                                        ButtonKt.Button$default((NoriaContext)((NoriaContext)$this$Row), null, (String)"Open in Docker", null, null, null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])$this$dp$iv22, (Object)new Function1<HandlerScope, Unit>(this.$pluginScope){
                                            final /* synthetic */ PluginScope $pluginScope;
                                            {
                                                this.$pluginScope = $pluginScope;
                                                super(1);
                                            }

                                            public final void invoke(HandlerScope $this$Button) {
                                                Intrinsics.checkNotNullParameter((Object)$this$Button, (String)"$this$Button");
                                                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)this.$pluginScope), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$Button, null){
                                                    int label;
                                                    final /* synthetic */ HandlerScope $this_Button;
                                                    {
                                                        this.$this_Button = $this_Button;
                                                        super(2, $completion);
                                                    }

                                                    public final Object invokeSuspend(Object object) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)object);
                                                                SharedWorkspaceRootEntity sharedWorkspaceRootEntity = (SharedWorkspaceRootEntity)CollectionsKt.singleOrNull((Iterable)SharedWorkspaceRootEntity.Companion.all());
                                                                if (sharedWorkspaceRootEntity == null || (sharedWorkspaceRootEntity = sharedWorkspaceRootEntity.getDirAddress()) == null) {
                                                                    return Unit.INSTANCE;
                                                                }
                                                                SharedWorkspaceRootEntity openedDir = sharedWorkspaceRootEntity;
                                                                ActionsKt.performAction((ActionContext)this.$this_Button.getActionContext().put(AiFrontendDataKeys.INSTANCE.getWorkspaceInDockerProjectDir(), (Object)openedDir), (ActionId)AiFrontendActionIds.workspaceInDocker.getId());
                                                                ActionsKt.performAction((ActionContext)this.$this_Button.getActionContext(), (CommonTrigger)CommonTrigger.Cancel);
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (int)3, null);
                                            }
                                        })), (int)61, null);
                                        unit = Unit.INSTANCE;
                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    }
                                } else {
                                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)39);
                                    IconKt.Icon-USBMPiE$default((NoriaContext)((NoriaContext)$this$Row), (ThemeKey)IconKeys.INSTANCE.getInfo(), (long)0L, null, null, null, (int)30, null);
                                    Unit unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)40);
                                    int $this$dp$iv = 4;
                                    boolean $i$f$getDp = false;
                                    SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Row), (Modifier)SizeKt.width-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                                    unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                    Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)41);
                                    TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Row), (String)"No smart backends to run", (long)0L, (ThemeKey)TextStyleKeys.INSTANCE.getSmall(), null, null, null, null, null, null, null, (int)1018, null);
                                    unit = Unit.INSTANCE;
                                    Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                                }
                            }
                        })), (int)11, null);
                        object2 = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)43);
                        NoriaContextKt.sideEffect((NoriaContext)((NoriaContext)$this$Column), (Object[])new Object[0], (Function0)((Function0)new Function0<Unit>(this.this$0, this.$pluginScope){
                            final /* synthetic */ SmartModeControlCenterStatusProvider this$0;
                            final /* synthetic */ PluginScope $pluginScope;
                            {
                                this.this$0 = $receiver;
                                this.$pluginScope = $pluginScope;
                                super(0);
                            }

                            public final void invoke() {
                                SmartModeControlCenterStatusProvider.access$markAllSmartModeNotificationsAsRead(this.this$0, this.$pluginScope);
                            }
                        }));
                        object2 = Unit.INSTANCE;
                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                        if (!((Collection)smartModeProblems).isEmpty()) {
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)44);
                            int $this$dp$iv3 = 12;
                            $i$f$getDp3 = false;
                            SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv3)));
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)46);
                            ApplyModifierKt.withModifier((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.fillMaxWidth$default((Modifier)((Modifier)Modifier.Companion), (float)0.0f, (int)1, null), (Function1)((Function1)Runtime.closure((Object[])new Object[0], (Object)((Object)render.4.INSTANCE))));
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)47);
                            $this$dp$iv3 = 4;
                            $i$f$getDp3 = false;
                            SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv3)));
                            object2 = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                            object2 = ((Iterable)smartModeProblems).iterator();
                            int n = 0;
                            while (object2.hasNext()) {
                                int index = n++;
                                SmartModeProblemEntity notification2 = (SmartModeProblemEntity)object2.next();
                                NoriaContext $this$scope$iv = (NoriaContext)$this$Column;
                                boolean $i$f$scope = false;
                                NoriaState noriaState = $this$scope$iv.getNoriaState();
                                if (noriaState != null) {
                                    NoriaStateKt.enterScope((NoriaState)noriaState, (int)index);
                                }
                                ColumnScope $this$invoke_u24lambda_u243 = (ColumnScope)$this$scope$iv;
                                boolean bl7 = false;
                                Runtime.enterScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243), (int)48);
                                int $this$dp$iv4 = 8;
                                boolean $i$f$getDp4 = false;
                                SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv4)));
                                Runtime.exitScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243));
                                Runtime.enterScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243), (int)49);
                                SmartModeControlCenterStatusProviderKt.access$renderNotification((NoriaContext)$this$invoke_u24lambda_u243, notification2);
                                Runtime.exitScope((NoriaContext)((NoriaContext)$this$invoke_u24lambda_u243));
                                Unit returnValue$iv = Unit.INSTANCE;
                                NoriaState noriaState2 = $this$scope$iv.getNoriaState();
                                if (noriaState2 != null) {
                                    NoriaStateKt.exitScope((NoriaState)noriaState2);
                                }
                            }
                        }
                    }
                })), (int)14, null);
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)$this$ProgressIndicatorBox);
            }
        })), (int)1, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$render);
    }

    /*
     * WARNING - void declaration
     */
    private final void markAllSmartModeNotificationsAsRead(PluginScope pluginScope) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)NotificationEntity.Companion.getCategoryAttr()), (Object)NotificationCategoryId.box-impl((String)SmartModeProblemNotificationEntityKt.getSmartModeNotificationProblemCategory().getId-L6wPaKM()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotificationEntity it = (NotificationEntity)element$iv$iv;
            boolean bl = false;
            if (!(it.getState() == NotificationState.NEW)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notReadNotifications = (List)destination$iv$iv;
        if (!((Collection)notReadNotifications).isEmpty()) {
            pluginScope.changeAsync((Function1)new Function1<ChangeScope, Unit>((List<NotificationEntity>)notReadNotifications){
                final /* synthetic */ List<NotificationEntity> $notReadNotifications;
                {
                    this.$notReadNotifications = $notReadNotifications;
                    super(1);
                }

                public final void invoke(ChangeScope $this$changeAsync) {
                    Intrinsics.checkNotNullParameter((Object)$this$changeAsync, (String)"$this$changeAsync");
                    Iterable $this$forEach$iv = this.$notReadNotifications;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        NotificationEntity it = (NotificationEntity)element$iv;
                        boolean bl = false;
                        it.setState(NotificationState.READ);
                    }
                }
            });
        }
    }

    public static final /* synthetic */ void access$markAllSmartModeNotificationsAsRead(SmartModeControlCenterStatusProvider $this, PluginScope pluginScope) {
        $this.markAllSmartModeNotificationsAsRead(pluginScope);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SmartModeState.values().length];
            try {
                nArray[SmartModeState.OFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.IDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.STARTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SmartModeState.STOPPING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

