/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.navigation;

import andel.text.Text;
import andel.text.TextLines;
import fleet.api.FileAddress;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.frontend.navigation.NavigationLocation;
import fleet.kernel.DurableEntityKt;
import fleet.util.StringKt;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a_\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062:\u0010\u0013\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\n\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u0002H\u000f0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001a\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001b"}, d2={"fileAddress", "Lfleet/api/FileAddress;", "Lfleet/frontend/navigation/NavigationLocation;", "getFileAddress", "(Lfleet/frontend/navigation/NavigationLocation;)Lfleet/api/FileAddress;", "correctOffset", "", "offset", "line", "", "lineStartOffset", "nextLineStartOffset", "originalLineStartOffset", "charsCount", "withLineRange", "T", "text", "Landel/text/Text;", "lineNumber", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "(Landel/text/Text;JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "navigationLocation", "Lfleet/frontend/navigation/NavigationLocation$Document;", "Lfleet/common/document/DocumentEntity;", "fleet.frontend"})
public final class NavigationPositionKt {
    @Nullable
    public static final FileAddress getFileAddress(@NotNull NavigationLocation $this$fileAddress) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fileAddress, (String)"<this>");
        NavigationLocation navigationLocation = $this$fileAddress;
        if (navigationLocation instanceof NavigationLocation.File) {
            object = ((NavigationLocation.File)$this$fileAddress).getFileAddress();
        } else if (navigationLocation instanceof NavigationLocation.Document) {
            DocumentEntity documentEntity = (DocumentEntity)DurableEntityKt.byUidOrNull((UID)((NavigationLocation.Document)$this$fileAddress).getDocumentId());
            object = documentEntity != null ? DocumentEntityKt.getLocationFileAddress((DocumentEntity)documentEntity) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public static final NavigationLocation.Document navigationLocation(@NotNull DocumentEntity $this$navigationLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$navigationLocation, (String)"<this>");
        return new NavigationLocation.Document($this$navigationLocation.getUid(), DocumentEntityKt.getVersion((DocumentEntity)$this$navigationLocation));
    }

    private static final <T> T withLineRange(Text text2, long lineNumber, Function2<? super Long, ? super Long, ? extends T> block) {
        TextLines lines = Text.lines$default((Text)text2, (boolean)false, (int)1, null);
        long linesCount = text2.linesCount();
        if (lineNumber >= linesCount) {
            return (T)block.invoke(null, null);
        }
        long lineStartOffset = lines.lineStartOffset(lineNumber);
        long nextLineOffset = lineNumber + 1L < linesCount ? lines.lineStartOffset(lineNumber + 1L) : text2.charsCount();
        return (T)block.invoke((Object)lineStartOffset, (Object)nextLineOffset);
    }

    private static final long correctOffset(long offset, String line, long lineStartOffset, long nextLineStartOffset, long originalLineStartOffset, long charsCount) {
        long lineLength;
        long offsetInLine = StringKt.offset8to16((String)line, (int)((int)(offset - originalLineStartOffset)));
        return RangesKt.coerceIn((long)(offsetInLine > (lineLength = nextLineStartOffset - lineStartOffset) ? nextLineStartOffset : offsetInLine + lineStartOffset), (long)0L, (long)charsCount);
    }

    public static final /* synthetic */ Object access$withLineRange(Text text2, long lineNumber, Function2 block) {
        return NavigationPositionKt.withLineRange(text2, lineNumber, block);
    }

    public static final /* synthetic */ long access$correctOffset(long offset, String line, long lineStartOffset, long nextLineStartOffset, long originalLineStartOffset, long charsCount) {
        return NavigationPositionKt.correctOffset(offset, line, lineStartOffset, nextLineStartOffset, originalLineStartOffset, charsCount);
    }
}

