/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.fus.reports;

import com.jetbrains.fus.reporting.schema.EventId2;
import com.jetbrains.fus.reporting.schema.EventLogGroup;
import fleet.common.FusEntityKt;
import fleet.common.fus.StateReporter;
import fleet.common.fus.StateReporterType;
import fleet.frontend.fus.reports.OSReports;
import fleet.util.os.Os;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lfleet/frontend/fus/reports/OSReporter;", "Lfleet/common/fus/StateReporter;", "()V", "group", "Lcom/jetbrains/fus/reporting/schema/EventLogGroup;", "getGroup", "()Lcom/jetbrains/fus/reporting/schema/EventLogGroup;", "type", "Lfleet/common/fus/StateReporterType;", "getType", "()Lfleet/common/fus/StateReporterType;", "parseVersion", "", "versionString", "report", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "fleet.frontend"})
final class OSReporter
implements StateReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StateReporterType type = StateReporterType.Companion.getApplication();
    @NotNull
    private static final Regex VERSION_REGEX = new Regex("(\\d+).*");

    @NotNull
    public StateReporterType getType() {
        return this.type;
    }

    @Nullable
    public Object report(@NotNull Continuation<? super Unit> $completion) {
        EventId2<String, String> eventId2 = OSReports.INSTANCE.getOSEvent();
        String string = OSReports.INSTANCE.getOsNames().get(Os.INSTANCE.getType());
        Intrinsics.checkNotNull((Object)string);
        String string2 = Os.INSTANCE.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVersion(...)");
        String string3 = this.parseVersion(string2);
        if (string3 == null) {
            string3 = "0.0";
        }
        FusEntityKt.log(eventId2, (Object)string, (Object)string3);
        return Unit.INSTANCE;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return OSReports.INSTANCE.getEnvGroup();
    }

    private final String parseVersion(String versionString) {
        Integer minor;
        Integer major;
        StringBuilder stringBuilder;
        StringBuilder $this$parseVersion_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        char[] cArray = new char[]{'.'};
        List versions = StringsKt.split$default((CharSequence)versionString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String version = (String)versions.get(0);
        Integer n = major = OSReporter.parseVersion$parseNumber(version);
        if (n == null) {
            return null;
        }
        n.intValue();
        $this$parseVersion_u24lambda_u240.append(major).append(".");
        Integer n2 = minor = versions.size() > 1 ? OSReporter.parseVersion$parseNumber((String)versions.get(1)) : null;
        $this$parseVersion_u24lambda_u240.append(n2 != null ? n2 : 0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Integer parseVersion$parseNumber(String num) {
        CharSequence charSequence = num;
        Regex regex = VERSION_REGEX;
        String string = "$1";
        String adjusted = regex.replaceFirst(charSequence, string);
        return StringsKt.toIntOrNull((String)adjusted);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lfleet/frontend/fus/reports/OSReporter$Companion;", "", "()V", "VERSION_REGEX", "Lkotlin/text/Regex;", "fleet.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

