/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.editor;

import andel.editor.Document;
import andel.editor.Editor;
import andel.editor.MultiCaret;
import andel.text.TextRange;
import andel.undo.UndoLog;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.EditorEntity;
import fleet.common.document.UndoLogEntityKt;
import fleet.common.user.UserEntity;
import fleet.frontend.editor.ComposableTextKt;
import fleet.frontend.editor.ComposableTextRangeEntity;
import fleet.frontend.editor.EditorEntityExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lfleet/frontend/editor/EditorFromEntity;", "Landel/editor/Editor;", "editor", "Lfleet/common/document/EditorEntity;", "oneLine", "", "(Lfleet/common/document/EditorEntity;Z)V", "composableTextRange", "Landel/text/TextRange;", "getComposableTextRange", "()Landel/text/TextRange;", "document", "Landel/editor/Document;", "getDocument", "()Landel/editor/Document;", "getEditor", "()Lfleet/common/document/EditorEntity;", "multiCaret", "Landel/editor/MultiCaret;", "getMultiCaret", "()Landel/editor/MultiCaret;", "getOneLine", "()Z", "undoLog", "Landel/undo/UndoLog;", "getUndoLog", "()Landel/undo/UndoLog;", "writable", "getWritable", "fleet.frontend"})
public final class EditorFromEntity
implements Editor {
    @NotNull
    private final EditorEntity editor;
    private final boolean oneLine;

    public EditorFromEntity(@NotNull EditorEntity editor2, boolean oneLine) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.oneLine = oneLine;
    }

    @NotNull
    public final EditorEntity getEditor() {
        return this.editor;
    }

    public boolean getOneLine() {
        return this.oneLine;
    }

    @NotNull
    public Document getDocument() {
        return DocumentEntityKt.asDocument((DocumentEntity)this.editor.getDocument());
    }

    @NotNull
    public MultiCaret getMultiCaret() {
        return EditorEntityExtKt.getMultiCaret(this.editor);
    }

    public boolean getWritable() {
        return this.editor.getDocument().getWritable();
    }

    @NotNull
    public UndoLog getUndoLog() {
        return (UndoLog)UndoLogEntityKt.getUndoLog((DocumentEntity)this.editor.getDocument(), (UserEntity)this.editor.getUser());
    }

    @Nullable
    public TextRange getComposableTextRange() {
        ComposableTextRangeEntity composableTextRangeEntity2 = ComposableTextKt.getComposableTextRangeEntity(this.editor);
        return composableTextRangeEntity2 != null ? composableTextRangeEntity2.getRange() : null;
    }
}

