/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.editor;

import andel.CapturedOperationKt;
import andel.EditLog;
import andel.editor.Caret;
import andel.editor.CaretExtKt;
import andel.editor.CaretId;
import andel.editor.CaretPosition;
import andel.editor.DocumentComponent;
import andel.editor.MultiCaret;
import andel.editor.MultiCaretData;
import andel.editor.MultiCaretMeta;
import andel.editor.MutableMultiCaret;
import andel.intervals.Interval;
import andel.lines.Fold;
import andel.operation.Operation;
import andel.operation.OperationKt;
import andel.operation.Sticky;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import fleet.common.document.DbMutableDocument;
import fleet.common.document.EditorEntity;
import fleet.common.document.EditorEntityKt;
import fleet.common.document.MultiCaretEntity;
import fleet.common.document.UnsharedHackKt;
import fleet.frontend.editor.DbMutableEditor;
import fleet.frontend.editor.EditorEntityExtKt;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.SharedEntityKt;
import fleet.kernel.SharedKt;
import fleet.util.UID;
import fleet.util.openmap.MutableBoundedOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010)\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0006H\u0016J\u0016\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010/\u001a\u00020-2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000700H\u0016J\u001e\u00101\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u00103\u001a\u00020+H\u0002J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010$\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00065"}, d2={"Lfleet/frontend/editor/DbMutableMultiCaret;", "Landel/editor/MutableMultiCaret;", "editor", "Lfleet/frontend/editor/DbMutableEditor;", "(Lfleet/frontend/editor/DbMutableEditor;)V", "carets", "", "Landel/editor/Caret;", "getCarets", "()Ljava/util/List;", "changeScope", "Lcom/jetbrains/rhizomedb/ChangeScope;", "getChangeScope", "()Lcom/jetbrains/rhizomedb/ChangeScope;", "dbEditor", "Lfleet/common/document/EditorEntity;", "getDbEditor", "()Lfleet/common/document/EditorEntity;", "document", "Lfleet/common/document/DbMutableDocument;", "getDocument", "()Lfleet/common/document/DbMutableDocument;", "getEditor", "()Lfleet/frontend/editor/DbMutableEditor;", "meta", "Lfleet/util/openmap/MutableBoundedOpenMap;", "Landel/editor/MultiCaretMeta;", "", "Lfleet/util/openmap/MutableOpenMap;", "getMeta", "()Lfleet/util/openmap/MutableBoundedOpenMap;", "multiCaretData", "Landel/editor/MultiCaretData;", "getMultiCaretData", "()Landel/editor/MultiCaretData;", "value", "primaryCaret", "getPrimaryCaret", "()Landel/editor/Caret;", "setPrimaryCaret", "(Landel/editor/Caret;)V", "addCarets", "positions", "Landel/editor/CaretPosition;", "moveCarets", "", "moves", "removeCarets", "", "setCaretsInternal", "mergedCarets", "primaryCaretPosition", "transformCaretsWithComponents", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nDbMutableEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMutableEditor.kt\nfleet/frontend/editor/DbMutableMultiCaret\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1549#2:249\n1620#2,3:250\n661#2,11:253\n618#2,12:264\n1045#2:276\n1603#2,9:277\n1855#2:286\n1789#2,2:287\n1791#2:290\n1856#2:292\n1612#2:293\n1#3:289\n1#3:291\n*S KotlinDebug\n*F\n+ 1 DbMutableEditor.kt\nfleet/frontend/editor/DbMutableMultiCaret\n*L\n169#1:249\n169#1:250,3\n175#1:253,11\n177#1:264,12\n231#1:276\n232#1:277,9\n232#1:286\n233#1:287,2\n233#1:290\n232#1:292\n232#1:293\n232#1:291\n*E\n"})
final class DbMutableMultiCaret
implements MutableMultiCaret {
    @NotNull
    private final DbMutableEditor editor;
    @NotNull
    private final MutableBoundedOpenMap<MultiCaretMeta, Object> meta;

    public DbMutableMultiCaret(@NotNull DbMutableEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.meta = EditorEntityExtKt.getMultiCaret(this.getDbEditor()).getMeta().mutable();
    }

    @NotNull
    public final DbMutableEditor getEditor() {
        return this.editor;
    }

    @NotNull
    public MutableBoundedOpenMap<MultiCaretMeta, Object> getMeta() {
        return this.meta;
    }

    @NotNull
    public List<Caret> getCarets() {
        return EditorEntityExtKt.getMultiCaret(this.getDbEditor()).getCarets();
    }

    @NotNull
    public MultiCaretData getMultiCaretData() {
        return EditorEntityExtKt.getMultiCaret(this.getDbEditor()).getMultiCaretData();
    }

    @NotNull
    public final DbMutableDocument getDocument() {
        return this.editor.getDocument();
    }

    @NotNull
    public final EditorEntity getDbEditor() {
        return this.editor.getDbEditor();
    }

    @NotNull
    public final ChangeScope getChangeScope() {
        return this.editor.getChangeScope();
    }

    @NotNull
    public Caret getPrimaryCaret() {
        return EditorEntityExtKt.getMultiCaret(this.getDbEditor()).getPrimaryCaret();
    }

    public void setPrimaryCaret(@NotNull Caret value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (SharedEntityKt.isShared((Entity)((Entity)this.getDbEditor()))) {
            SharedKt.shared((ChangeScope)this.getChangeScope(), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this, value){
                final /* synthetic */ DbMutableMultiCaret this$0;
                final /* synthetic */ Caret $value;
                {
                    this.this$0 = $receiver;
                    this.$value = $value;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull SharedChangeScope $this$shared) {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$shared, (String)"$this$shared");
                    Iterable $this$map$iv = EditorEntityExtKt.getMultiCaret(this.this$0.getDbEditor()).getCarets();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Caret caret = (Caret)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getCaretId());
                    }
                    if (!((List)destination$iv$iv).contains(this.$value.getCaretId())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    EditorEntityKt.getMultiCaretEntity((EditorEntity)this.this$0.getDbEditor()).setPrimaryCaretId(this.$value.getCaretId());
                }
            }));
        } else {
            EditorEntityKt.getMultiCaretEntity((EditorEntity)this.getDbEditor()).setPrimaryCaretId(value.getCaretId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Caret addCarets(@NotNull List<CaretPosition> positions) {
        Caret caret;
        Object v1;
        List mergedCarets;
        CaretId primaryCaretId;
        block8: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            Iterable $this$map$iv = positions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CaretPosition caretPosition = (CaretPosition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Caret((CaretPosition)it, new CaretId(UID.Companion.random()), null, 4, null));
            }
            List caretsToAdd = (List)destination$iv$iv;
            MultiCaretEntity $this$addCarets_u24lambda_u241 = EditorEntityKt.getMultiCaretEntity((EditorEntity)this.getDbEditor());
            boolean bl = false;
            Caret caret2 = (Caret)$this$addCarets_u24lambda_u241.getMultiCaretData().getCaretsById().get($this$addCarets_u24lambda_u241.getPrimaryCaretId());
            if (caret2 == null) {
                caret2 = (Caret)CollectionsKt.first((List)caretsToAdd);
            }
            primaryCaretId = caret2.getCaretId();
            List<Caret> transformedCaretsToAdd = this.transformCaretsWithComponents(caretsToAdd);
            mergedCarets = CaretExtKt.mergeCaretsBeforeMoves((Collection)CollectionsKt.plus((Collection)this.getCarets(), (Iterable)transformedCaretsToAdd));
            Iterable $this$singleOrNull$iv = mergedCarets;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Caret it = (Caret)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getCaretId(), (Object)primaryCaretId)) continue;
                if (found$iv) {
                    v1 = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        if ((caret = (Caret)v1) == null || (caret = caret.getPosition()) == null) {
            caret = (CaretPosition)CollectionsKt.first(positions);
        }
        Caret transformedPrimaryCaretPosition = caret;
        this.setCaretsInternal(mergedCarets, (CaretPosition)transformedPrimaryCaretPosition);
        Iterable $this$single$iv = mergedCarets;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Caret it = (Caret)element$iv;
            boolean bl = false;
            boolean bl3 = Intrinsics.areEqual((Object)primaryCaretId, (Object)it.getCaretId()) || it.getPosition().getSelectionStart() < transformedPrimaryCaretPosition.getOffset() && transformedPrimaryCaretPosition.getOffset() < it.getPosition().getSelectionEnd();
            if (!bl3) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    public void removeCarets(@NotNull Collection<Caret> carets2) {
        Intrinsics.checkNotNullParameter(carets2, (String)"carets");
        ChangeScope $this$removeCarets_u24lambda_u244 = this.getChangeScope();
        boolean bl = false;
        UnsharedHackKt.maybeShared((ChangeScope)$this$removeCarets_u24lambda_u244, (Entity)((Entity)this.getDbEditor().getDocument()), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this, carets2){
            final /* synthetic */ DbMutableMultiCaret this$0;
            final /* synthetic */ Collection<Caret> $carets;
            {
                this.this$0 = $receiver;
                this.$carets = $carets;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull SharedChangeScope $this$maybeShared) {
                boolean bl;
                Object object;
                MultiCaretEntity multiCaretEntity;
                long oldPrimaryCaretOffset;
                MultiCaretEntity multiCaret;
                block7: {
                    Collection<CaretId> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$maybeShared, (String)"$this$maybeShared");
                    multiCaret = EditorEntityKt.getMultiCaretEntity((EditorEntity)this.this$0.getDbEditor());
                    MultiCaretData data = multiCaret.getMultiCaretData();
                    oldPrimaryCaretOffset = this.this$0.getPrimaryCaret().getOffset();
                    Iterable iterable = this.$carets;
                    MultiCaretData multiCaretData = data;
                    multiCaretEntity = multiCaret;
                    boolean $i$f$map = false;
                    object = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Caret caret = (Caret)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.getCaretId());
                    }
                    collection = (List)destination$iv$iv;
                    multiCaretEntity.setMultiCaretData(multiCaretData.removeCarets((Collection)collection));
                    Iterable $this$any$iv = this.$carets;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Caret it = (Caret)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getCaretId(), (Object)multiCaret.getPrimaryCaretId())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    Caret caret;
                    Iterator<Object> iterator;
                    List newCarets;
                    block8: {
                        newCarets = multiCaret.getMultiCaretData().getCarets();
                        object = newCarets;
                        multiCaretEntity = multiCaret;
                        Object object2 = object;
                        ListIterator<E> listIterator = object2.listIterator(object2.size());
                        while (listIterator.hasPrevious()) {
                            Iterator<Object> iterator2 = listIterator.previous();
                            Caret it = (Caret)iterator2;
                            boolean bl4 = false;
                            if (!(it.getOffset() < oldPrimaryCaretOffset)) continue;
                            iterator = iterator2;
                            break block8;
                        }
                        iterator = null;
                    }
                    if ((caret = (Caret)iterator) == null || (caret = caret.getCaretId()) == null) {
                        Caret caret2 = (Caret)CollectionsKt.firstOrNull((List)newCarets);
                        caret = caret2 != null ? caret2.getCaretId() : new CaretId(UID.Companion.fromString("undefined"));
                    }
                    multiCaretEntity.setPrimaryCaretId((CaretId)caret);
                }
            }
        }));
    }

    private final void setCaretsInternal(List<Caret> mergedCarets, CaretPosition primaryCaretPosition) {
        EditLog baseEdits = this.getDocument().getEdits();
        MultiCaretData multiCaretData = new MultiCaretData(null, null, null, 7, null).addCarets(mergedCarets);
        ChangeScope $this$setCaretsInternal_u24lambda_u245 = this.getChangeScope();
        boolean bl = false;
        UnsharedHackKt.maybeShared((ChangeScope)$this$setCaretsInternal_u24lambda_u245, (Entity)((Entity)this.getDbEditor().getDocument()), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this, baseEdits, multiCaretData, primaryCaretPosition){
            final /* synthetic */ DbMutableMultiCaret this$0;
            final /* synthetic */ EditLog $baseEdits;
            final /* synthetic */ MultiCaretData $multiCaretData;
            final /* synthetic */ CaretPosition $primaryCaretPosition;
            {
                this.this$0 = $receiver;
                this.$baseEdits = $baseEdits;
                this.$multiCaretData = $multiCaretData;
                this.$primaryCaretPosition = $primaryCaretPosition;
                super(1);
            }

            public final void invoke(@NotNull SharedChangeScope $this$maybeShared) {
                Caret caret;
                Object v0;
                MultiCaretEntity multiCaretEntity;
                MultiCaretData transformedData;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)$this$maybeShared, (String)"$this$maybeShared");
                    this.this$0.getDbEditor().getDocument().getText();
                    Operation arrow = CapturedOperationKt.bridge((EditLog)this.$baseEdits, (EditLog)this.this$0.getDocument().getEdits());
                    transformedData = (OperationKt.isNotIdentity((Operation)arrow) ? this.$multiCaretData.edit(arrow, true) : this.$multiCaretData).ensureValidOffsets(this.this$0.getDbEditor().getDocument().getText().charsCount());
                    CaretPosition transformedPrimary = OperationKt.transformOnto((CaretPosition)this.$primaryCaretPosition, (Operation)arrow, (Sticky)Sticky.LEFT);
                    EditorEntityKt.getMultiCaretEntity((EditorEntity)this.this$0.getDbEditor()).setMultiCaretData(transformedData);
                    Iterable iterable = transformedData.getSortedCarets();
                    multiCaretEntity = EditorEntityKt.getMultiCaretEntity((EditorEntity)this.this$0.getDbEditor());
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        Caret it = (Caret)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getPosition(), (Object)transformedPrimary)) continue;
                        v0 = t;
                        break block2;
                    }
                    v0 = null;
                }
                if ((caret = (Caret)v0) == null || (caret = caret.getCaretId()) == null) {
                    caret = ((Caret)CollectionsKt.last((List)transformedData.getSortedCarets())).getCaretId();
                }
                multiCaretEntity.setPrimaryCaretId((CaretId)caret);
            }
        }));
        List affectedFolds2 = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.getCarets()), (Function1)((Function1)new Function1<Caret, Sequence<? extends Interval<? extends Object, ? extends Fold>>>(this){
            final /* synthetic */ DbMutableMultiCaret this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<Interval<Object, Fold>> invoke(@NotNull Caret caret) {
                Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                return SequencesKt.filter((Sequence)this.this$0.getEditor().getLayout().getFolds().query(caret.getOffset(), caret.getOffset()), (Function1)((Function1)new Function1<Interval<? extends Object, ? extends Fold>, Boolean>(caret){
                    final /* synthetic */ Caret $caret;
                    {
                        this.$caret = $caret;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Interval<? extends Object, ? extends Fold> interval) {
                        Intrinsics.checkNotNullParameter(interval, (String)"interval");
                        return interval.from != this.$caret.getOffset() && interval.to != this.$caret.getOffset();
                    }
                }));
            }
        }))));
        this.editor.getLayout().unfold(affectedFolds2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Caret> transformCaretsWithComponents(List<Caret> carets2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$sortedBy$iv = this.editor.getComponents().asMap().values();
        boolean $i$f$sortedBy = false;
        List components2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b2) {
                DocumentComponent it = (DocumentComponent)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOrder());
                it = (DocumentComponent)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrder()));
            }
        });
        Iterable $this$mapNotNull$iv = carets2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Caret it$iv$iv;
            void $this$fold$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Caret it = (Caret)element$iv$iv;
            boolean bl2 = false;
            Iterable iterable2 = components2;
            Caret initial$iv = it;
            boolean $i$f$fold = false;
            Caret accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                Caret caret;
                DocumentComponent documentComponent = (DocumentComponent)element$iv;
                Caret caret2 = accumulator$iv;
                boolean bl3 = false;
                if (caret2 != null) {
                    void component;
                    boolean bl4 = false;
                    caret = component.transformCaret(caret2);
                } else {
                    caret = null;
                }
                accumulator$iv = caret;
            }
            if (accumulator$iv == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void moveCarets(@NotNull List<Caret> moves) {
        Caret caret;
        Object v0;
        List exhaustiveMoves;
        block3: {
            Intrinsics.checkNotNullParameter(moves, (String)"moves");
            if (moves.isEmpty()) {
                return;
            }
            List<Caret> transformedMoves = this.transformCaretsWithComponents(moves);
            exhaustiveMoves = CaretExtKt.exhaustiveMoves((MultiCaret)((MultiCaret)this), transformedMoves);
            Iterable iterable = exhaustiveMoves;
            for (Object t : iterable) {
                Caret it = (Caret)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCaretId(), (Object)this.getPrimaryCaret().getCaretId())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((caret = (Caret)v0) == null || (caret = caret.getPosition()) == null) {
            caret = this.getPrimaryCaret().getPosition();
        }
        Caret primaryCaretPosition = caret;
        List mergedCarets = CaretExtKt.mergeCaretsBeforeMoves((Collection)exhaustiveMoves);
        this.setCaretsInternal(mergedCarets, (CaretPosition)primaryCaretPosition);
    }
}

