/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.anonymization;

import fleet.reporting.anonymization.DeviceIdManager;
import fleet.util.os.Os;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002/0B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0015\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J(\u0010(\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0004H\u0002J\u001d\u0010,\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"Lfleet/reporting/anonymization/DeviceIdManager;", "", "()V", "DEVICE_ID_PREFERENCE_KEY", "", "DEVICE_ID_SHARED_FILE", "UNDEFINED", "UTF8_BOM", "", "oSChar", "", "getOSChar", "()C", "oSChar$delegate", "Lkotlin/Lazy;", "preferences", "Ljava/util/prefs/Preferences;", "getPreferences", "()Ljava/util/prefs/Preferences;", "assertAllowed", "", "token", "Lfleet/reporting/anonymization/DeviceIdManager$DeviceIdToken;", "recorderId", "deleteLegacySharedFile", "fileName", "generateId", "calendar", "Ljava/util/Calendar;", "getOrGenerateId", "getPreferenceKey", "hasUTF8Bom", "", "bom", "isBaseRecorder", "isUndefinedRecorder", "loadFromFile", "file", "Ljava/io/File;", "loadFromFile$fleet_reporting_anonymization", "syncWithSharedFile", "installationId", "prefs", "prefsKey", "writeToFile", "text", "writeToFile$fleet_reporting_anonymization", "DeviceIdToken", "InvalidDeviceIdTokenException", "fleet.reporting.anonymization"})
@SourceDebugExtension(value={"SMAP\nDeviceIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceIdManager.kt\nfleet/reporting/anonymization/DeviceIdManager\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n107#2:173\n79#2,22:174\n1726#3,3:196\n1#4:199\n*S KotlinDebug\n*F\n+ 1 DeviceIdManager.kt\nfleet/reporting/anonymization/DeviceIdManager\n*L\n85#1:173\n85#1:174,22\n123#1:196,3\n*E\n"})
public final class DeviceIdManager {
    @NotNull
    public static final DeviceIdManager INSTANCE = new DeviceIdManager();
    @NotNull
    private static final String UNDEFINED = "UNDEFINED";
    @NotNull
    private static final String DEVICE_ID_SHARED_FILE = "PermanentDeviceId";
    @NotNull
    private static final String DEVICE_ID_PREFERENCE_KEY = "device_id";
    @NotNull
    private static final byte[] UTF8_BOM;
    @NotNull
    private static final Lazy oSChar$delegate;

    private DeviceIdManager() {
    }

    @NotNull
    public final String getOrGenerateId(@Nullable DeviceIdToken token, @NotNull String recorderId) throws InvalidDeviceIdTokenException {
        CharSequence charSequence;
        String deviceId;
        String preferenceKey;
        Preferences prefs;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
                this.assertAllowed(token, recorderId);
                prefs = this.getPreferences();
                preferenceKey = this.getPreferenceKey(recorderId);
                deviceId = prefs.get(preferenceKey, null);
                charSequence = deviceId;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block6;
                charSequence = deviceId;
                Intrinsics.checkNotNull((Object)charSequence);
                if (StringsKt.contains$default((CharSequence)charSequence, (char)'_', (boolean)false, (int)2, null)) break block7;
            }
            Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
            deviceId = this.generateId(calendar);
            prefs.put(preferenceKey, deviceId);
        }
        if (Os.INSTANCE.isWindows()) {
            if (this.isBaseRecorder(recorderId)) {
                charSequence = deviceId;
                Intrinsics.checkNotNull((Object)charSequence);
                deviceId = this.syncWithSharedFile(DEVICE_ID_SHARED_FILE, (String)charSequence, prefs, preferenceKey);
            } else {
                this.deleteLegacySharedFile(recorderId + "_PermanentDeviceId");
            }
        }
        charSequence = deviceId;
        Intrinsics.checkNotNull((Object)charSequence);
        return charSequence;
    }

    private final void assertAllowed(DeviceIdToken token, String recorderId) throws InvalidDeviceIdTokenException {
        if (this.isBaseRecorder(recorderId)) {
            if (token == null) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from unknown class");
            }
        } else if (!this.isUndefinedRecorder(recorderId) && token == null) {
            throw new InvalidDeviceIdTokenException("Cannot access device id from unknown class");
        }
    }

    private final String getPreferenceKey(String recorderId) {
        Object object;
        if (this.isBaseRecorder(recorderId)) {
            object = DEVICE_ID_PREFERENCE_KEY;
        } else {
            String string = recorderId.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            object = string + "_device_id";
        }
        return object;
    }

    private final boolean isBaseRecorder(String recorderId) {
        return Intrinsics.areEqual((Object)"FUS", (Object)recorderId);
    }

    private final boolean isUndefinedRecorder(String recorderId) {
        return Intrinsics.areEqual((Object)UNDEFINED, (Object)recorderId);
    }

    private final String syncWithSharedFile(String fileName, String installationId, Preferences prefs, String prefsKey) {
        File dir;
        String installationId2 = installationId;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, fileName);
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    String $this$trim$iv = this.loadFromFile$fleet_reporting_anonymization(permanentIdFile);
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    fromFile = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                if (!(((CharSequence)fromFile).length() == 0)) {
                    if (!Intrinsics.areEqual((Object)fromFile, (Object)installationId2)) {
                        installationId2 = fromFile;
                        prefs.put(prefsKey, installationId2);
                    }
                } else {
                    this.writeToFile$fleet_reporting_anonymization(permanentIdFile, installationId2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return installationId2;
    }

    private final void deleteLegacySharedFile(String fileName) {
        try {
            File permanentIdFile;
            File dir;
            String appdata = System.getenv("APPDATA");
            if (appdata != null && (dir = new File(appdata, "JetBrains")).exists() && (permanentIdFile = new File(dir, fileName)).exists()) {
                permanentIdFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUTF8Bom(byte[] bom) {
        boolean bl;
        if (bom.length < 3) return false;
        Iterable $this$all$iv = ArraysKt.zip((byte[])UTF8_BOM, (byte[])bom);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            byte b;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            byte a = ((Number)pair.component1()).byteValue();
            if (a != (b = ((Number)pair.component2()).byteValue())) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String loadFromFile$fleet_reporting_anonymization(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream is = (FileInputStream)closeable;
            boolean bl = false;
            byte[] byArray = is.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] bytes = byArray;
            int offset = INSTANCE.hasUTF8Bom(bytes) ? UTF8_BOM.length : 0;
            int n = bytes.length - offset;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String string = new String(bytes, offset, n, charset2);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile$fleet_reporting_anonymization(@NotNull File file, @NotNull String text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Closeable closeable = new DataOutputStream(new FileOutputStream(file));
        Throwable throwable = null;
        try {
            DataOutputStream stream = (DataOutputStream)closeable;
            boolean bl = false;
            String string = text;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            stream.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Preferences getPreferences() {
        Preferences preferences = Preferences.userRoot().node("jetbrains");
        Intrinsics.checkNotNullExpressionValue((Object)preferences, (String)"node(...)");
        return preferences;
    }

    private final String generateId(Calendar calendar) {
        int year = calendar.get(1);
        if (year < 2000) {
            year = 2000;
        }
        if (year > 2099) {
            year = 2099;
        }
        calendar.set(1, year);
        return new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).format(calendar.getTime()) + "_" + UUID.randomUUID();
    }

    public final char getOSChar() {
        Lazy lazy = oSChar$delegate;
        return ((Character)lazy.getValue()).charValue();
    }

    static {
        byte[] byArray = new byte[]{-17, -69, -65};
        UTF8_BOM = byArray;
        oSChar$delegate = LazyKt.lazy((Function0)oSChar.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lfleet/reporting/anonymization/DeviceIdManager$DeviceIdToken;", "", "fleet.reporting.anonymization"})
    public static interface DeviceIdToken {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lfleet/reporting/anonymization/DeviceIdManager$InvalidDeviceIdTokenException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "fleet.reporting.anonymization"})
    public static final class InvalidDeviceIdTokenException
    extends Exception {
        public InvalidDeviceIdTokenException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

